/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.unbreakables;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import net.blay09.mods.unbreakables.BreakContextImpl;
import net.blay09.mods.unbreakables.api.BreakContext;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class BreakTracker {
    private static final Map<UUID, BreakContext> contexts = Collections.synchronizedMap(new HashMap());

    public static void startBreak(Player player) {
        contexts.remove(BreakTracker.getKeyForPlayer(player));
    }

    public static void stopBreak(Player player) {
        contexts.remove(BreakTracker.getKeyForPlayer(player));
    }

    private static UUID getKeyForPlayer(Player player) {
        return player.getGameProfile().getId();
    }

    public static BreakContext getOrCreateContext(BlockGetter blockGetter, BlockPos pos, BlockState state, Player player, Consumer<BreakContext> initializer) {
        return contexts.computeIfAbsent(BreakTracker.getKeyForPlayer(player), key -> {
            BreakContextImpl breakContext = new BreakContextImpl(blockGetter, pos, state, player);
            initializer.accept(breakContext);
            return breakContext;
        });
    }

    public static Optional<BreakContext> getContext(Player player) {
        return BreakTracker.getContext(player, null);
    }

    public static Optional<BreakContext> getContext(Player player, @Nullable BlockPos pos) {
        UUID cacheKey = BreakTracker.getKeyForPlayer(player);
        BreakContext breakContext = contexts.get(cacheKey);
        if (breakContext != null && (pos == null || breakContext.getPos().equals((Object)pos))) {
            return Optional.of(breakContext);
        }
        contexts.remove(cacheKey);
        return Optional.empty();
    }
}

