/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.unbreakables.client.hint;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import net.blay09.mods.unbreakables.api.client.BreakHintRenderer;
import net.blay09.mods.unbreakables.rules.hint.ItemHint;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class ItemHintRenderer
implements BreakHintRenderer<ItemHint> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"unbreakables", (String)"textures/gui/icons.png");

    @Override
    public void render(Window window, GuiGraphics guiGraphics, float partialTicks, ItemHint hint) {
        Font font = Minecraft.getInstance().font;
        boolean canAfford = hint.canAfford();
        MutableComponent component = Component.translatable((String)"gui.unbreakables.item", (Object[])new Object[]{hint.count(), hint.itemStack().getHoverName()}).withStyle(canAfford ? ChatFormatting.GREEN : ChatFormatting.RED);
        int textWidth = font.width((FormattedText)component);
        int x = window.getGuiScaledWidth() / 2 - 8 - textWidth / 2;
        int y = window.getGuiScaledHeight() / 2 - 8 + 16;
        guiGraphics.blit(TEXTURE, x, y, 48.0f, 0.0f, 16, 16, 256, 256);
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        poseStack.translate((float)(x + 5), (float)(y + 7), 1.0f);
        poseStack.scale(0.5f, 0.5f, 0.5f);
        guiGraphics.renderFakeItem(hint.itemStack(), 0, 0);
        poseStack.popPose();
        if (!canAfford) {
            poseStack.pushPose();
            poseStack.translate(0.0f, 0.0f, 302.0f);
            guiGraphics.blit(TEXTURE, x, y, 64.0f, 0.0f, 16, 16, 256, 256);
            poseStack.popPose();
        }
        Objects.requireNonNull(font);
        guiGraphics.drawString(font, (Component)component, x + 16 + 4, y + 8 - 9 / 2 + 1, -1);
    }
}

