/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.unbreakables;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.WeakHashMap;
import java.util.function.Consumer;
import net.blay09.mods.unbreakables.BreakContextImpl;
import net.blay09.mods.unbreakables.api.BreakContext;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import org.jetbrains.annotations.Nullable;

public class BreakTracker {
    private static final Map<class_1657, BreakContext> contexts = Collections.synchronizedMap(new WeakHashMap());

    public static void startBreak(class_1657 player) {
        contexts.remove(player);
    }

    public static void stopBreak(class_1657 player) {
        contexts.remove(player);
    }

    public static BreakContext getOrCreateContext(class_1922 blockGetter, class_2338 pos, class_2680 state, class_1657 player, Consumer<BreakContext> initializer) {
        return contexts.computeIfAbsent(player, key -> {
            BreakContextImpl breakContext = new BreakContextImpl(blockGetter, pos, state, player);
            initializer.accept(breakContext);
            return breakContext;
        });
    }

    public static Optional<BreakContext> getContext(class_1657 player) {
        return BreakTracker.getContext(player, null);
    }

    public static Optional<BreakContext> getContext(class_1657 player, @Nullable class_2338 pos) {
        BreakContext breakContext = contexts.get(player);
        if (breakContext != null && (pos == null || breakContext.getPos().equals((Object)pos))) {
            return Optional.of(breakContext);
        }
        contexts.remove(player);
        return Optional.empty();
    }
}

