/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.unbreakables.rules;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import net.blay09.mods.unbreakables.api.BreakContext;
import net.blay09.mods.unbreakables.api.BreakModifierFunction;
import net.blay09.mods.unbreakables.api.BreakRequirement;
import net.blay09.mods.unbreakables.api.ConditionResolver;
import net.blay09.mods.unbreakables.api.ParameterSerializer;
import net.blay09.mods.unbreakables.api.RequirementFunction;
import net.blay09.mods.unbreakables.api.RequirementType;
import net.blay09.mods.unbreakables.api.VariableResolver;
import net.blay09.mods.unbreakables.rules.RuleParser;
import net.minecraft.class_2960;

public class RuleRegistry {
    private static final Map<class_2960, RequirementType<?>> requirementTypes = new HashMap();
    private static final Map<class_2960, RequirementFunction<?, ?>> requirementFunctions = new HashMap();
    private static final Map<Class<?>, ParameterSerializer<?>> parameterSerializers = new HashMap();
    private static final Map<class_2960, VariableResolver> variableResolvers = new HashMap<class_2960, VariableResolver>();
    private static final Map<class_2960, ConditionResolver<?>> conditionResolvers = new HashMap();

    public static <T extends BreakRequirement> RequirementType<T> createDefaultType(final String name, final Class<T> requirementClass) {
        RequirementType requirementType = new RequirementType<T>(){

            @Override
            public class_2960 getId() {
                return new class_2960("unbreakables", name);
            }

            @Override
            public T createInstance() {
                try {
                    return (BreakRequirement)requirementClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };
        RuleRegistry.register(requirementType);
        return requirementType;
    }

    public static void register(RequirementType<?> requirementType) {
        requirementTypes.put(requirementType.getId(), requirementType);
    }

    public static void register(RequirementFunction<?, ?> requirementFunction) {
        requirementFunctions.put(requirementFunction.getId(), requirementFunction);
    }

    public static void register(ParameterSerializer<?> parameterSerializer) {
        parameterSerializers.put(parameterSerializer.getType(), parameterSerializer);
    }

    public static void register(VariableResolver variableResolver) {
        variableResolvers.put(variableResolver.getId(), variableResolver);
    }

    public static void register(ConditionResolver<?> conditionResolver) {
        conditionResolvers.put(conditionResolver.getId(), conditionResolver);
    }

    public static void registerVariableResolver(final String name, final Function<BreakContext, Float> resolver) {
        RuleRegistry.register(new VariableResolver(){

            @Override
            public class_2960 getId() {
                return new class_2960("unbreakables", name);
            }

            @Override
            public float resolve(BreakContext context) {
                return ((Float)resolver.apply(context)).floatValue();
            }
        });
    }

    public static <P> void registerConditionResolver(final String name, final Class<P> parameterType, final BiFunction<BreakContext, P, Boolean> resolver) {
        RuleRegistry.register(new ConditionResolver<P>(){

            @Override
            public class_2960 getId() {
                return new class_2960("unbreakables", name);
            }

            @Override
            public Class<P> getParameterType() {
                return parameterType;
            }

            @Override
            public boolean matches(BreakContext context, P parameters) {
                return (Boolean)resolver.apply(context, parameters);
            }
        });
        int index = name.indexOf("is_");
        final String notName = index != -1 ? name.substring(0, index + 3) + "not_" + name.substring(index + 3) : "not_" + name;
        RuleRegistry.register(new ConditionResolver<P>(){

            @Override
            public class_2960 getId() {
                return new class_2960("unbreakables", notName);
            }

            @Override
            public Class<P> getParameterType() {
                return parameterType;
            }

            @Override
            public boolean matches(BreakContext context, P parameters) {
                return (Boolean)resolver.apply(context, parameters) == false;
            }
        });
    }

    public static <T> void registerDefaultSerializer(Class<T> type) {
        RuleRegistry.registerSerializer(type, it -> RuleParser.deserializeParameterList(type, it));
    }

    public static <T> void registerSerializer(final Class<T> type, final Function<String, T> deserializer) {
        RuleRegistry.register(new ParameterSerializer<T>(){

            @Override
            public Class<T> getType() {
                return type;
            }

            @Override
            public T deserialize(String value) {
                return deserializer.apply(value);
            }
        });
    }

    public static <T extends BreakRequirement, P> void registerModifier(final String name, final RequirementType<T> requirementType, final Class<P> parameterType, final BreakModifierFunction<T, P> function, final Supplier<Boolean> predicate) {
        RuleRegistry.register(new RequirementFunction<T, P>(){

            @Override
            public class_2960 getId() {
                return new class_2960("unbreakables", name);
            }

            @Override
            public class_2960 getRequirementType() {
                return requirementType.getId();
            }

            @Override
            public Class<P> getParameterType() {
                return parameterType;
            }

            @Override
            public T apply(T requirement, BreakContext context, P parameters) {
                return (BreakRequirement)function.apply(requirement, context, parameters);
            }

            @Override
            public boolean isEnabled() {
                return (Boolean)predicate.get();
            }
        });
    }

    public static <T extends BreakRequirement> RequirementType<T> getRequirementType(class_2960 id) {
        return requirementTypes.get(id);
    }

    public static <T extends BreakRequirement, P> RequirementFunction<T, P> getRequirementFunction(class_2960 id) {
        return requirementFunctions.get(id);
    }

    public static VariableResolver getVariableResolver(class_2960 id) {
        return variableResolvers.get(id);
    }

    public static ConditionResolver<?> getConditionResolver(class_2960 id) {
        return conditionResolvers.get(id);
    }

    public static <T> ParameterSerializer<T> getParameterSerializer(Class<T> type) {
        return parameterSerializers.get(type);
    }
}

