/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.unbreakables.rules.requirements;

import java.util.Collection;
import java.util.Optional;
import net.blay09.mods.unbreakables.api.BreakContext;
import net.blay09.mods.unbreakables.api.BreakHint;
import net.blay09.mods.unbreakables.api.BreakRequirement;
import net.blay09.mods.unbreakables.rules.hint.CombinedHint;
import net.minecraft.class_1657;

public record CombinedRequirement(Collection<BreakRequirement> requirements) implements BreakRequirement
{
    @Override
    public boolean canAfford(BreakContext context, class_1657 player) {
        return this.requirements.stream().allMatch(requirement -> requirement.canAfford(context, player));
    }

    @Override
    public void consume(class_1657 player) {
        this.requirements.forEach(requirement -> requirement.consume(player));
    }

    @Override
    public void rollback(class_1657 player) {
        this.requirements.forEach(requirement -> requirement.rollback(player));
    }

    @Override
    public Optional<BreakHint<?>> hint(BreakContext context, class_1657 player) {
        return Optional.of(new CombinedHint(this.requirements.stream().map(it -> it.hint(context, player)).filter(Optional::isPresent).map(Optional::get).toList()));
    }

    @Override
    public boolean isEmpty() {
        return this.requirements.stream().allMatch(BreakRequirement::isEmpty);
    }
}

