/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.unbreakables.rules.requirements;

import java.util.Optional;
import net.blay09.mods.unbreakables.CooldownTracker;
import net.blay09.mods.unbreakables.api.BreakContext;
import net.blay09.mods.unbreakables.api.BreakHint;
import net.blay09.mods.unbreakables.api.BreakRequirement;
import net.blay09.mods.unbreakables.rules.hint.CooldownHint;
import net.minecraft.class_1657;
import net.minecraft.class_2960;

public class CooldownRequirement
implements BreakRequirement {
    private class_2960 id;
    private int seconds;

    public CooldownRequirement(class_2960 id, int seconds) {
        this.id = id;
        this.seconds = seconds;
    }

    @Override
    public boolean canAfford(BreakContext context, class_1657 player) {
        return context.viaServer(level -> this.getCooldownMillisLeft(player) <= 0L);
    }

    @Override
    public void consume(class_1657 player) {
        if (this.seconds > 0) {
            CooldownTracker.setCooldownUntil(player, this.id, System.currentTimeMillis() + (long)this.seconds * 1000L);
        }
    }

    @Override
    public void rollback(class_1657 player) {
        CooldownTracker.setCooldownUntil(player, this.id, 0L);
    }

    @Override
    public Optional<BreakHint<?>> hint(BreakContext context, class_1657 player) {
        long secondsLeft = this.getCooldownMillisLeft(player) / 1000L;
        return Optional.of(new CooldownHint((int)secondsLeft));
    }

    private long getCooldownMillisLeft(class_1657 player) {
        return CooldownTracker.getCooldownMillisLeft(player, this.id);
    }

    @Override
    public boolean isEmpty() {
        return this.seconds <= 0;
    }

    public void setCooldown(class_2960 key, int seconds) {
        this.id = key;
        this.seconds = seconds;
    }

    public class_2960 getCooldownId() {
        return this.id;
    }

    public int getCooldownSeconds() {
        return this.seconds;
    }
}

