/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.unbreakables.rulesets;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.unbreakables.Unbreakables;
import net.blay09.mods.unbreakables.UnbreakablesConfig;
import net.blay09.mods.unbreakables.network.UnbreakableRulesMessage;
import net.blay09.mods.unbreakables.rules.ConfiguredRule;
import net.blay09.mods.unbreakables.rules.RuleParser;
import net.blay09.mods.unbreakables.rulesets.JsonRulesetData;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_4013;
import net.minecraft.class_7654;
import net.minecraft.server.MinecraftServer;

public class RulesetLoader
implements class_4013 {
    private static final Gson gson = new Gson();
    private static final class_7654 COMPAT_JSONS = class_7654.method_45114((String)"unbreakables");
    private static final List<String> rules = new ArrayList<String>();
    private static final Set<String> knownRulesets = new HashSet<String>();
    private static final List<ConfiguredRule<?, ?>> loadedRules = new ArrayList();

    public void method_14491(class_3300 resourceManager) {
        RulesetLoader.reset();
        RulesetLoader.load(UnbreakablesConfig.getActive().rules);
        List<String> enabledRulesets = UnbreakablesConfig.getActive().rulesets;
        for (Map.Entry entry : COMPAT_JSONS.method_45113(resourceManager).entrySet()) {
            try {
                BufferedReader reader = ((class_3298)entry.getValue()).method_43039();
                try {
                    String rulesetId = ((class_2960)entry.getKey()).method_12836() + ":" + ((class_2960)entry.getKey()).method_12832().replace("unbreakables/", "").replace(".json", "");
                    knownRulesets.add(rulesetId);
                    if (!enabledRulesets.contains(rulesetId)) continue;
                    RulesetLoader.load(((JsonRulesetData)gson.fromJson((Reader)reader, JsonRulesetData.class)).getRules());
                }
                finally {
                    if (reader == null) continue;
                    reader.close();
                }
            }
            catch (Exception e) {
                Unbreakables.logger.error("Parsing error loading Unbreakables rulesets at {}", entry.getKey(), (Object)e);
            }
        }
        for (String enabledRuleset : enabledRulesets) {
            if (knownRulesets.contains(enabledRuleset)) continue;
            Unbreakables.logger.warn("Unknown Unbreakables ruleset: {}", (Object)enabledRuleset);
        }
        Unbreakables.logger.info("{} breakable rules loaded", (Object)loadedRules.size());
        MinecraftServer server = Balm.getHooks().getServer();
        if (server != null) {
            Balm.getNetworking().sendToAll(server, (Object)new UnbreakableRulesMessage(RulesetLoader.getRules()));
        }
    }

    public static void reset() {
        rules.clear();
        loadedRules.clear();
        knownRulesets.clear();
    }

    public static void load(List<String> rules) {
        RulesetLoader.rules.addAll(rules);
        for (String rule : rules) {
            if (rule.isBlank()) continue;
            Unbreakables.logger.info("Loading breakable rule {}", (Object)rule);
            RuleParser.parse(rule).filter(configuredModifier -> configuredModifier.requirement().modifier().isEnabled()).ifPresent(loadedRules::add);
        }
    }

    public static List<String> getRules() {
        return rules;
    }

    public static List<ConfiguredRule<?, ?>> getLoadedRules() {
        return loadedRules;
    }
}

