/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.unbreakables;

import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.event.BreakBlockEvent;
import net.blay09.mods.balm.api.event.EventPriority;
import net.blay09.mods.balm.api.event.PlayerLoginEvent;
import net.blay09.mods.unbreakables.BreakContextImpl;
import net.blay09.mods.unbreakables.BreakTracker;
import net.blay09.mods.unbreakables.UnbreakablesConfig;
import net.blay09.mods.unbreakables.api.BreakContext;
import net.blay09.mods.unbreakables.api.BreakRequirement;
import net.blay09.mods.unbreakables.api.UnbreakablesAPI;
import net.blay09.mods.unbreakables.event.NewDigSpeedEvent;
import net.blay09.mods.unbreakables.network.ModNetworking;
import net.blay09.mods.unbreakables.network.UnbreakableRulesMessage;
import net.blay09.mods.unbreakables.rules.InbuiltConditions;
import net.blay09.mods.unbreakables.rules.InbuiltParameters;
import net.blay09.mods.unbreakables.rules.InbuiltRequirements;
import net.blay09.mods.unbreakables.rules.hint.CombinedHint;
import net.blay09.mods.unbreakables.rules.hint.CooldownHint;
import net.blay09.mods.unbreakables.rules.hint.ExperienceLevelHint;
import net.blay09.mods.unbreakables.rules.hint.ExperiencePointsHint;
import net.blay09.mods.unbreakables.rules.hint.ItemHint;
import net.blay09.mods.unbreakables.rules.hint.MessageHint;
import net.blay09.mods.unbreakables.rules.hint.NoHint;
import net.blay09.mods.unbreakables.rulesets.RulesetLoader;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Unbreakables {
    public static final Logger logger = LoggerFactory.getLogger(Unbreakables.class);
    public static final String MOD_ID = "unbreakables";

    public static void initialize() {
        InbuiltParameters.register();
        InbuiltConditions.register();
        InbuiltRequirements.register();
        UnbreakablesAPI.registerHintSerializer(CombinedHint.ID, CombinedHint.CombinedBreakHintSerializer.INSTANCE);
        UnbreakablesAPI.registerHintSerializer(NoHint.ID, NoHint.NoHintSerializer.INSTANCE);
        UnbreakablesAPI.registerHintSerializer(MessageHint.ID, MessageHint.MessageHintSerializer.INSTANCE);
        UnbreakablesAPI.registerHintSerializer(CooldownHint.ID, CooldownHint.CooldownHintSerializer.INSTANCE);
        UnbreakablesAPI.registerHintSerializer(ExperienceLevelHint.ID, ExperienceLevelHint.ExperienceLevelHintSerializer.INSTANCE);
        UnbreakablesAPI.registerHintSerializer(ExperiencePointsHint.ID, ExperiencePointsHint.ExperiencePointsHintSerializer.INSTANCE);
        UnbreakablesAPI.registerHintSerializer(ItemHint.ID, ItemHint.ItemHintSerializer.INSTANCE);
        UnbreakablesConfig.initialize();
        ModNetworking.initialize(Balm.getNetworking());
        Balm.addServerReloadListener((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)"json_rulesets"), (PreparableReloadListener)new RulesetLoader());
        Balm.getEvents().onEvent(PlayerLoginEvent.class, event -> Balm.getNetworking().sendTo((Player)event.getPlayer(), (CustomPacketPayload)new UnbreakableRulesMessage(RulesetLoader.getRules())));
        Balm.getEvents().onEvent(NewDigSpeedEvent.class, event -> {
            BreakContext breakContext = BreakTracker.getOrCreateContext(event.getBlockGetter(), event.getPos(), event.getState(), event.getPlayer(), context -> RulesetLoader.getLoadedRules().forEach(it -> ((BreakContextImpl)context).apply(it)));
            BreakRequirement requirement = breakContext.resolve();
            if (!requirement.canAfford(breakContext, event.getPlayer())) {
                event.setSpeedOverride(Float.valueOf(0.0f));
            }
        });
        Balm.getEvents().onEvent(BreakBlockEvent.class, event -> {
            if (event.getPlayer().getAbilities().instabuild) {
                return;
            }
            BreakContextImpl breakContext = new BreakContextImpl((BlockGetter)event.getLevel(), event.getPos(), event.getState(), event.getPlayer());
            RulesetLoader.getLoadedRules().forEach(breakContext::apply);
            BreakRequirement requirement = breakContext.resolve();
            if (!requirement.canAfford(breakContext, event.getPlayer())) {
                event.setCanceled(true);
            }
        }, EventPriority.Highest);
        Balm.getEvents().onEvent(BreakBlockEvent.class, event -> {
            if (event.getPlayer().getAbilities().instabuild) {
                return;
            }
            BreakContextImpl breakContext = new BreakContextImpl((BlockGetter)event.getLevel(), event.getPos(), event.getState(), event.getPlayer());
            RulesetLoader.getLoadedRules().forEach(breakContext::apply);
            BreakRequirement requirement = breakContext.resolve();
            if (!requirement.canAfford(breakContext, event.getPlayer())) {
                event.setCanceled(true);
            } else {
                requirement.consume(event.getPlayer());
            }
        }, EventPriority.Lowest);
    }
}

