/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.unbreakables.rules;

import java.util.Optional;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.unbreakables.api.BreakContext;
import net.blay09.mods.unbreakables.api.parameter.FloatParameter;
import net.blay09.mods.unbreakables.api.parameter.IdParameter;
import net.blay09.mods.unbreakables.api.parameter.PositionParameter;
import net.blay09.mods.unbreakables.api.parameter.TaggableIdParameter;
import net.blay09.mods.unbreakables.rules.RuleRegistry;
import net.blay09.mods.unbreakables.rules.parameters.BiFloatParameter;
import net.blay09.mods.unbreakables.rules.parameters.BoundsParameter;
import net.blay09.mods.unbreakables.rules.parameters.EntityNearbyParameter;
import net.blay09.mods.unbreakables.rules.parameters.FloatCountedIdParameter;
import net.blay09.mods.unbreakables.rules.parameters.IsNearParameter;
import net.blay09.mods.unbreakables.rules.parameters.IsNearPoiParameter;
import net.blay09.mods.unbreakables.rules.parameters.PropertyParameter;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class InbuiltConditions {
    public static void register() {
        RuleRegistry.registerConditionResolver("is_block", TaggableIdParameter.class, (context, parameters) -> parameters.isTag() ? context.getState().is(TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)parameters.value())) : BuiltInRegistries.BLOCK.getKey((Object)context.getState().getBlock()).equals((Object)parameters.value()));
        RuleRegistry.registerConditionResolver("is_tag", IdParameter.class, (context, parameters) -> context.getState().is(TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)parameters.value())));
        RuleRegistry.registerConditionResolver("is_state", PropertyParameter.class, (context, parameters) -> {
            for (Property property : context.getState().getProperties()) {
                String stringValue;
                String string;
                if (!property.getName().equals(parameters.property().value())) continue;
                Comparable value = context.getState().getValue(property);
                if (value instanceof StringRepresentable) {
                    StringRepresentable rep = (StringRepresentable)value;
                    string = rep.getSerializedName();
                } else {
                    string = value.toString();
                }
                if (!(stringValue = string).equals(parameters.value().value())) continue;
                return true;
            }
            return false;
        });
        RuleRegistry.registerConditionResolver("is_in_dimension", IdParameter.class, (context, parameters) -> InbuiltConditions.pickLevel(context).map(it -> it.dimension().location().equals((Object)parameters.value())).orElse(false));
        RuleRegistry.registerConditionResolver("is_in_biome", TaggableIdParameter.class, (context, parameters) -> InbuiltConditions.pickLevelAccessor(context).map(it -> parameters.isTag() ? it.getBiome(context.getPos()).is(TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)parameters.value())) : it.getBiome(context.getPos()).is(parameters.value())).orElse(false));
        RuleRegistry.registerConditionResolver("has_effect", FloatCountedIdParameter.class, (context, parameters) -> {
            boolean bl;
            Player player = context.getPlayer();
            if (player != null) {
                if (BuiltInRegistries.MOB_EFFECT.get(parameters.id().value()).map(arg_0 -> ((Player)player).getEffect(arg_0)).map(MobEffectInstance::getAmplifier).map(it -> (float)it.intValue() >= parameters.count().value() - 1.0f).orElse(false).booleanValue()) {
                    bl = true;
                    return bl;
                }
            }
            bl = false;
            return bl;
        });
        RuleRegistry.registerConditionResolver("is_tool", TaggableIdParameter.class, (context, parameters) -> {
            Player player = context.getPlayer();
            if (player == null) {
                return false;
            }
            return parameters.isTag() ? player.getMainHandItem().is(TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)parameters.value())) : player.getMainHandItem().is((Item)BuiltInRegistries.ITEM.getValue(parameters.value()));
        });
        RuleRegistry.registerConditionResolver("is_enchanted", FloatCountedIdParameter.class, (context, parameters) -> {
            Player player = context.getPlayer();
            if (player == null) {
                return false;
            }
            ItemStack item = player.getMainHandItem();
            return player.registryAccess().lookup(Registries.ENCHANTMENT).flatMap(it -> it.get(parameters.id().value())).map(it -> EnchantmentHelper.getItemEnchantmentLevel((Holder)it, (ItemStack)item)).map(it -> (float)it.intValue() >= parameters.count().value()).orElse(false);
        });
        RuleRegistry.registerConditionResolver("players_nearby", BiFloatParameter.class, (context, parameters) -> InbuiltConditions.pickLevel(context).map(level -> (float)level.getEntities((Entity)context.getPlayer(), AABB.ofSize((Vec3)context.getPos().getCenter(), (double)parameters.first().value(), (double)parameters.first().value(), (double)parameters.first().value()), EntitySelector.NO_SPECTATORS).size() >= parameters.second().value()).orElse(false));
        RuleRegistry.registerConditionResolver("mobs_nearby", BiFloatParameter.class, (context, parameters) -> InbuiltConditions.pickLevel(context).map(level -> (float)level.getEntities((Entity)context.getPlayer(), AABB.ofSize((Vec3)context.getPos().getCenter(), (double)parameters.first().value(), (double)parameters.first().value(), (double)parameters.first().value()), it -> it instanceof Mob).size() >= parameters.second().value()).orElse(false));
        RuleRegistry.registerConditionResolver("animals_nearby", BiFloatParameter.class, (context, parameters) -> InbuiltConditions.pickLevel(context).map(level -> (float)level.getEntities((Entity)context.getPlayer(), AABB.ofSize((Vec3)context.getPos().getCenter(), (double)parameters.first().value(), (double)parameters.first().value(), (double)parameters.first().value()), it -> it instanceof Animal).size() >= parameters.second().value()).orElse(false));
        RuleRegistry.registerConditionResolver("entity_nearby", EntityNearbyParameter.class, (context, parameters) -> InbuiltConditions.pickLevel(context).map(level -> (float)level.getEntities((Entity)context.getPlayer(), AABB.ofSize((Vec3)context.getPos().getCenter(), (double)parameters.distance().value(), (double)parameters.distance().value(), (double)parameters.distance().value()), it -> parameters.entity().isTag() ? it.getType().is(TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)parameters.entity().value())) : BuiltInRegistries.ENTITY_TYPE.getKey((Object)it.getType()).equals((Object)parameters.entity().value())).size() >= parameters.minimum().value()).orElse(false));
        RuleRegistry.registerConditionResolver("is_above_y", FloatParameter.class, (context, parameters) -> {
            BlockPos pos = context.getPos();
            return (float)pos.getY() > parameters.value();
        });
        RuleRegistry.registerConditionResolver("is_below_y", FloatParameter.class, (context, parameters) -> {
            BlockPos pos = context.getPos();
            return (float)pos.getY() < parameters.value();
        });
        RuleRegistry.registerConditionResolver("is_within", BoundsParameter.class, (context, parameters) -> {
            BlockPos pos = context.getPos();
            return pos.getX() >= parameters.minX().value() && pos.getX() <= parameters.maxX().value() && pos.getY() >= parameters.minY().value() && pos.getY() <= parameters.maxY().value() && pos.getZ() >= parameters.minZ().value() && pos.getZ() <= parameters.maxZ().value();
        });
        RuleRegistry.registerConditionResolver("is_at", PositionParameter.class, (context, parameters) -> {
            BlockPos pos = context.getPos();
            return pos.getX() == parameters.x().value() && pos.getY() == parameters.y().value() && pos.getZ() == parameters.z().value();
        });
        RuleRegistry.registerConditionResolver("is_near", IsNearParameter.class, (context, parameters) -> {
            BlockPos pos = context.getPos();
            BlockPos rulePos = new BlockPos(parameters.x().value(), parameters.y().value(), parameters.z().value());
            float maxDist = parameters.distance().value();
            double dist = pos.distSqr((Vec3i)rulePos);
            return dist <= (double)(maxDist * maxDist);
        });
        RuleRegistry.registerConditionResolver("is_near_poi", IsNearPoiParameter.class, (context, parameters) -> context.viaServer(serverLevel -> {
            Optional poi = serverLevel.getPoiManager().findClosestWithType(it -> false, context.getPos(), (int)parameters.distance().value(), PoiManager.Occupancy.ANY);
            return poi.isPresent();
        }));
        RuleRegistry.registerConditionResolver("is_player", IsNearParameter.class, (context, parameters) -> {
            Player player = context.getPlayer();
            return player != null && !Balm.getHooks().isFakePlayer(player);
        });
        RuleRegistry.registerConditionResolver("has_advancement", IdParameter.class, (context, parameters) -> context.viaServer(serverLevel -> {
            ServerPlayer serverPlayer;
            AdvancementHolder advancement;
            Player patt0$temp = context.getPlayer();
            if (patt0$temp instanceof ServerPlayer && (advancement = (serverPlayer = (ServerPlayer)patt0$temp).level().getServer().getAdvancements().get(parameters.value())) != null) {
                return serverPlayer.getAdvancements().getOrStartProgress(advancement).isDone();
            }
            return false;
        }));
    }

    private static Optional<LevelAccessor> pickLevelAccessor(BreakContext context) {
        BlockGetter blockGetter = context.getBlockGetter();
        if (blockGetter instanceof LevelAccessor) {
            LevelAccessor level = (LevelAccessor)blockGetter;
            return Optional.of(level);
        }
        return Optional.ofNullable(context.getPlayer()).map(Entity::level);
    }

    private static Optional<Level> pickLevel(BreakContext context) {
        BlockGetter blockGetter = context.getBlockGetter();
        if (blockGetter instanceof Level) {
            Level level = (Level)blockGetter;
            return Optional.of(level);
        }
        return Optional.ofNullable(context.getPlayer()).map(Entity::level);
    }
}

