/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.unbreakables.rules.requirements;

import java.util.Optional;
import net.blay09.mods.unbreakables.api.BreakContext;
import net.blay09.mods.unbreakables.api.BreakHint;
import net.blay09.mods.unbreakables.api.BreakRequirement;
import net.blay09.mods.unbreakables.rules.hint.ItemHint;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class ItemRequirement
implements BreakRequirement {
    private ItemStack itemStack;
    private int count;

    public ItemRequirement(ItemStack item, int count) {
        this.itemStack = item;
        this.count = count;
    }

    @Override
    public boolean canAfford(BreakContext context, Player player) {
        int count = 0;
        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
            ItemStack slotStack = player.getInventory().getItem(i);
            if (!ItemStack.isSameItemSameComponents((ItemStack)this.itemStack, (ItemStack)slotStack) || (count += slotStack.getCount()) < this.count) continue;
            return true;
        }
        return false;
    }

    @Override
    public void consume(Player player) {
        int consumed = 0;
        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
            int leftToConsume = this.count - consumed;
            ItemStack slotStack = player.getInventory().getItem(i);
            if (!ItemStack.isSameItemSameComponents((ItemStack)this.itemStack, (ItemStack)slotStack)) continue;
            int count = Math.min(slotStack.getCount(), leftToConsume);
            slotStack.shrink(count);
            if ((consumed += count) < this.count) continue;
            return;
        }
    }

    @Override
    public void rollback(Player player) {
        ItemStack itemStack;
        for (int added = 0; added < this.count; added += itemStack.getCount()) {
            int leftToAdd = this.count - added;
            itemStack = this.itemStack.copy();
            itemStack.setCount(Math.min(itemStack.getMaxStackSize(), leftToAdd));
            if (player.addItem(itemStack)) continue;
            player.drop(itemStack, false, false);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.itemStack.isEmpty() || this.count <= 0;
    }

    @Override
    public Optional<BreakHint<?>> hint(BreakContext context, Player player) {
        return Optional.of(new ItemHint(this.itemStack, this.count, this.canAfford(context, player)));
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public void setItemStack(ItemStack itemStack) {
        this.itemStack = itemStack;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }
}

