/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.unbreakables.network;

import net.blay09.mods.unbreakables.BreakContextImpl;
import net.blay09.mods.unbreakables.BreakTracker;
import net.blay09.mods.unbreakables.api.BreakHint;
import net.blay09.mods.unbreakables.rules.hint.BreakHintRegistry;
import net.blay09.mods.unbreakables.rules.requirements.ServersideResponseRequirement;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public record ClientboundUnbreakableStatusPacket(BlockPos pos, BreakHint<?> hint, boolean breakable) {
    public static void encode(ClientboundUnbreakableStatusPacket message, FriendlyByteBuf buf) {
        buf.m_130064_(message.pos);
        buf.writeBoolean(message.breakable);
        buf.m_130085_(message.hint.id());
        BreakHint.Serializer<?> serializer = message.hint.serializer();
        serializer.encode(buf, message.hint);
    }

    public static ClientboundUnbreakableStatusPacket decode(FriendlyByteBuf buf) {
        BlockPos pos = buf.m_130135_();
        boolean unbreakable = buf.readBoolean();
        ResourceLocation hintId = buf.m_130281_();
        BreakHint.Serializer<BreakHint<?>> hintSerializer = BreakHintRegistry.getSerializer(hintId);
        BreakHint<?> hint = hintSerializer.decode(buf);
        return new ClientboundUnbreakableStatusPacket(pos, hint, unbreakable);
    }

    public static void handle(Player player, ClientboundUnbreakableStatusPacket message) {
        BreakTracker.getContext(player, message.pos).ifPresent(context -> ((BreakContextImpl)context).resolve(new ServersideResponseRequirement(message.hint(), message.breakable)));
    }
}

