/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.unbreakables.rules.hint;

import java.util.Objects;
import net.blay09.mods.unbreakables.api.BreakHint;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;

public final class CooldownHint
implements BreakHint<CooldownHint> {
    public static final ResourceLocation ID = new ResourceLocation("unbreakables", "cooldown");
    private final int secondsLeft;
    private float ticksPassed;

    public CooldownHint(int secondsLeft) {
        this.secondsLeft = secondsLeft;
    }

    @Override
    public ResourceLocation id() {
        return ID;
    }

    @Override
    public BreakHint.Serializer<CooldownHint> serializer() {
        return CooldownHintSerializer.INSTANCE;
    }

    public int secondsLeft() {
        return this.secondsLeft;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        CooldownHint that = (CooldownHint)obj;
        return this.secondsLeft == that.secondsLeft;
    }

    public int hashCode() {
        return Objects.hash(this.secondsLeft);
    }

    public String toString() {
        return "CooldownHint[secondsLeft=" + this.secondsLeft + "]";
    }

    public float getTicksPassed() {
        return this.ticksPassed;
    }

    public void setTicksPassed(float ticksPassed) {
        this.ticksPassed = ticksPassed;
    }

    public static class CooldownHintSerializer
    implements BreakHint.Serializer<CooldownHint> {
        public static final CooldownHintSerializer INSTANCE = new CooldownHintSerializer();

        @Override
        public void encode(FriendlyByteBuf buf, CooldownHint hint) {
            buf.writeInt(hint.secondsLeft());
        }

        @Override
        public CooldownHint decode(FriendlyByteBuf buf) {
            return new CooldownHint(buf.readInt());
        }
    }
}

