/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.unbreakables.rules.requirements;

import java.util.Optional;
import net.blay09.mods.unbreakables.api.BreakContext;
import net.blay09.mods.unbreakables.api.BreakHint;
import net.blay09.mods.unbreakables.api.BreakRequirement;
import net.blay09.mods.unbreakables.rules.hint.ExperienceLevelHint;
import net.minecraft.world.entity.player.Player;

public class ExperienceLevelRequirement
implements BreakRequirement {
    private int levels;

    public ExperienceLevelRequirement(int levels) {
        this.levels = Math.max(0, levels);
    }

    @Override
    public boolean canAfford(BreakContext context, Player player) {
        return player.f_36078_ >= this.levels;
    }

    @Override
    public void consume(Player player) {
        player.m_6749_(-this.levels);
    }

    @Override
    public void rollback(Player player) {
        player.m_6749_(this.levels);
    }

    @Override
    public boolean isEmpty() {
        return this.levels <= 0;
    }

    @Override
    public Optional<BreakHint<?>> hint(BreakContext context, Player player) {
        return Optional.of(new ExperienceLevelHint(this.levels));
    }

    public void setLevels(int levels) {
        this.levels = levels;
    }

    public int getLevels() {
        return this.levels;
    }
}

