/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.unbreakables.rules.requirements;

import java.util.Optional;
import net.blay09.mods.unbreakables.api.BreakContext;
import net.blay09.mods.unbreakables.api.BreakHint;
import net.blay09.mods.unbreakables.api.BreakRequirement;
import net.blay09.mods.unbreakables.rules.hint.ItemHint;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class ItemRequirement
implements BreakRequirement {
    private ItemStack itemStack;
    private int count;

    public ItemRequirement(ItemStack item, int count) {
        this.itemStack = item;
        this.count = count;
    }

    @Override
    public boolean canAfford(BreakContext context, Player player) {
        int count = 0;
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            ItemStack slotStack = player.m_150109_().m_8020_(i);
            if (!ItemStack.m_150942_((ItemStack)this.itemStack, (ItemStack)slotStack) || (count += slotStack.m_41613_()) < this.count) continue;
            return true;
        }
        return false;
    }

    @Override
    public void consume(Player player) {
        int consumed = 0;
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            int leftToConsume = this.count - consumed;
            ItemStack slotStack = player.m_150109_().m_8020_(i);
            if (!ItemStack.m_150942_((ItemStack)this.itemStack, (ItemStack)slotStack)) continue;
            int count = Math.min(slotStack.m_41613_(), leftToConsume);
            slotStack.m_41774_(count);
            if ((consumed += count) < this.count) continue;
            return;
        }
    }

    @Override
    public void rollback(Player player) {
        ItemStack itemStack;
        for (int added = 0; added < this.count; added += itemStack.m_41613_()) {
            int leftToAdd = this.count - added;
            itemStack = this.itemStack.m_41777_();
            itemStack.m_41764_(Math.min(itemStack.m_41741_(), leftToAdd));
            if (player.m_36356_(itemStack)) continue;
            player.m_7197_(itemStack, false, false);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.itemStack.m_41619_() || this.count <= 0;
    }

    @Override
    public Optional<BreakHint<?>> hint(BreakContext context, Player player) {
        return Optional.of(new ItemHint(this.itemStack, this.count, this.canAfford(context, player)));
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public void setItemStack(ItemStack itemStack) {
        this.itemStack = itemStack;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }
}

