/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.unbreakables;

import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.event.BreakBlockEvent;
import net.blay09.mods.balm.api.event.EventPriority;
import net.blay09.mods.balm.api.event.PlayerLoginEvent;
import net.blay09.mods.unbreakables.BreakContextImpl;
import net.blay09.mods.unbreakables.BreakTracker;
import net.blay09.mods.unbreakables.UnbreakablesConfig;
import net.blay09.mods.unbreakables.api.BreakContext;
import net.blay09.mods.unbreakables.api.BreakRequirement;
import net.blay09.mods.unbreakables.api.UnbreakablesAPI;
import net.blay09.mods.unbreakables.event.NewDigSpeedEvent;
import net.blay09.mods.unbreakables.network.ModNetworking;
import net.blay09.mods.unbreakables.network.UnbreakableRulesMessage;
import net.blay09.mods.unbreakables.rules.InbuiltConditions;
import net.blay09.mods.unbreakables.rules.InbuiltParameters;
import net.blay09.mods.unbreakables.rules.InbuiltRequirements;
import net.blay09.mods.unbreakables.rules.hint.CombinedHint;
import net.blay09.mods.unbreakables.rules.hint.CooldownHint;
import net.blay09.mods.unbreakables.rules.hint.ExperienceLevelHint;
import net.blay09.mods.unbreakables.rules.hint.ExperiencePointsHint;
import net.blay09.mods.unbreakables.rules.hint.ItemHint;
import net.blay09.mods.unbreakables.rules.hint.MessageHint;
import net.blay09.mods.unbreakables.rules.hint.NoHint;
import net.blay09.mods.unbreakables.rulesets.RulesetLoader;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_2960;
import net.minecraft.class_3302;
import net.minecraft.class_8710;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Unbreakables {
    public static final Logger logger = LoggerFactory.getLogger(Unbreakables.class);
    public static final String MOD_ID = "unbreakables";

    public static void initialize() {
        InbuiltParameters.register();
        InbuiltConditions.register();
        InbuiltRequirements.register();
        UnbreakablesAPI.registerHintSerializer(CombinedHint.ID, CombinedHint.CombinedBreakHintSerializer.INSTANCE);
        UnbreakablesAPI.registerHintSerializer(NoHint.ID, NoHint.NoHintSerializer.INSTANCE);
        UnbreakablesAPI.registerHintSerializer(MessageHint.ID, MessageHint.MessageHintSerializer.INSTANCE);
        UnbreakablesAPI.registerHintSerializer(CooldownHint.ID, CooldownHint.CooldownHintSerializer.INSTANCE);
        UnbreakablesAPI.registerHintSerializer(ExperienceLevelHint.ID, ExperienceLevelHint.ExperienceLevelHintSerializer.INSTANCE);
        UnbreakablesAPI.registerHintSerializer(ExperiencePointsHint.ID, ExperiencePointsHint.ExperiencePointsHintSerializer.INSTANCE);
        UnbreakablesAPI.registerHintSerializer(ItemHint.ID, ItemHint.ItemHintSerializer.INSTANCE);
        UnbreakablesConfig.initialize();
        ModNetworking.initialize(Balm.getNetworking());
        Balm.addServerReloadListener((class_2960)class_2960.method_60655((String)MOD_ID, (String)"json_rulesets"), (class_3302)new RulesetLoader());
        Balm.getEvents().onEvent(PlayerLoginEvent.class, event -> Balm.getNetworking().sendTo((class_1657)event.getPlayer(), (class_8710)new UnbreakableRulesMessage(RulesetLoader.getRules())));
        Balm.getEvents().onEvent(NewDigSpeedEvent.class, event -> {
            BreakContext breakContext = BreakTracker.getOrCreateContext(event.getBlockGetter(), event.getPos(), event.getState(), event.getPlayer(), context -> RulesetLoader.getLoadedRules().forEach(it -> ((BreakContextImpl)context).apply(it)));
            BreakRequirement requirement = breakContext.resolve();
            if (!requirement.canAfford(breakContext, event.getPlayer())) {
                event.setSpeedOverride(Float.valueOf(0.0f));
            }
        });
        Balm.getEvents().onEvent(BreakBlockEvent.class, event -> {
            if (event.getPlayer().method_31549().field_7477) {
                return;
            }
            BreakContextImpl breakContext = new BreakContextImpl((class_1922)event.getLevel(), event.getPos(), event.getState(), event.getPlayer());
            RulesetLoader.getLoadedRules().forEach(breakContext::apply);
            BreakRequirement requirement = breakContext.resolve();
            if (!requirement.canAfford(breakContext, event.getPlayer())) {
                event.setCanceled(true);
            }
        }, EventPriority.Highest);
        Balm.getEvents().onEvent(BreakBlockEvent.class, event -> {
            if (event.getPlayer().method_31549().field_7477) {
                return;
            }
            BreakContextImpl breakContext = new BreakContextImpl((class_1922)event.getLevel(), event.getPos(), event.getState(), event.getPlayer());
            RulesetLoader.getLoadedRules().forEach(breakContext::apply);
            BreakRequirement requirement = breakContext.resolve();
            if (!requirement.canAfford(breakContext, event.getPlayer())) {
                event.setCanceled(true);
            } else {
                requirement.consume(event.getPlayer());
            }
        }, EventPriority.Lowest);
    }
}

