/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.unbreakables.rules;

import java.util.Optional;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.unbreakables.api.BreakContext;
import net.blay09.mods.unbreakables.api.parameter.FloatParameter;
import net.blay09.mods.unbreakables.api.parameter.IdParameter;
import net.blay09.mods.unbreakables.api.parameter.PositionParameter;
import net.blay09.mods.unbreakables.api.parameter.TaggableIdParameter;
import net.blay09.mods.unbreakables.rules.RuleRegistry;
import net.blay09.mods.unbreakables.rules.parameters.BiFloatParameter;
import net.blay09.mods.unbreakables.rules.parameters.BoundsParameter;
import net.blay09.mods.unbreakables.rules.parameters.EntityNearbyParameter;
import net.blay09.mods.unbreakables.rules.parameters.FloatCountedIdParameter;
import net.blay09.mods.unbreakables.rules.parameters.IsNearParameter;
import net.blay09.mods.unbreakables.rules.parameters.IsNearPoiParameter;
import net.blay09.mods.unbreakables.rules.parameters.PropertyParameter;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1301;
import net.minecraft.class_1308;
import net.minecraft.class_1429;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3542;
import net.minecraft.class_4153;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8779;

public class InbuiltConditions {
    public static void register() {
        RuleRegistry.registerConditionResolver("is_block", TaggableIdParameter.class, (context, parameters) -> parameters.isTag() ? context.getState().method_26164(class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)parameters.value())) : class_7923.field_41175.method_10221((Object)context.getState().method_26204()).equals((Object)parameters.value()));
        RuleRegistry.registerConditionResolver("is_tag", IdParameter.class, (context, parameters) -> context.getState().method_26164(class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)parameters.value())));
        RuleRegistry.registerConditionResolver("is_state", PropertyParameter.class, (context, parameters) -> {
            for (class_2769 property : context.getState().method_28501()) {
                String stringValue;
                String string;
                if (!property.method_11899().equals(parameters.property().value())) continue;
                Comparable value = context.getState().method_11654(property);
                if (value instanceof class_3542) {
                    class_3542 rep = (class_3542)value;
                    string = rep.method_15434();
                } else {
                    string = value.toString();
                }
                if (!(stringValue = string).equals(parameters.value().value())) continue;
                return true;
            }
            return false;
        });
        RuleRegistry.registerConditionResolver("is_in_dimension", IdParameter.class, (context, parameters) -> InbuiltConditions.pickLevel(context).map(it -> it.method_27983().method_29177().equals((Object)parameters.value())).orElse(false));
        RuleRegistry.registerConditionResolver("is_in_biome", TaggableIdParameter.class, (context, parameters) -> InbuiltConditions.pickLevelAccessor(context).map(it -> parameters.isTag() ? it.method_23753(context.getPos()).method_40220(class_6862.method_40092((class_5321)class_7924.field_41236, (class_2960)parameters.value())) : it.method_23753(context.getPos()).method_40226(parameters.value())).orElse(false));
        RuleRegistry.registerConditionResolver("has_effect", FloatCountedIdParameter.class, (context, parameters) -> class_7923.field_41174.method_10223(parameters.id().value()).map(it -> context.getPlayer().method_6112((class_6880)it)).map(class_1293::method_5578).map(it -> (float)it.intValue() >= parameters.count().value() - 1.0f).orElse(false));
        RuleRegistry.registerConditionResolver("is_tool", TaggableIdParameter.class, (context, parameters) -> parameters.isTag() ? context.getPlayer().method_6047().method_31573(class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)parameters.value())) : context.getPlayer().method_6047().method_31574((class_1792)class_7923.field_41178.method_63535(parameters.value())));
        RuleRegistry.registerConditionResolver("is_enchanted", FloatCountedIdParameter.class, (context, parameters) -> {
            class_1799 item = context.getPlayer().method_6047();
            return context.getPlayer().method_56673().method_46759(class_7924.field_41265).flatMap(it -> it.method_10223(parameters.id().value())).map(it -> class_1890.method_8225((class_6880)it, (class_1799)item)).map(it -> (float)it.intValue() >= parameters.count().value()).orElse(false);
        });
        RuleRegistry.registerConditionResolver("players_nearby", BiFloatParameter.class, (context, parameters) -> InbuiltConditions.pickLevel(context).map(level -> (float)level.method_8333((class_1297)context.getPlayer(), class_238.method_30048((class_243)context.getPos().method_46558(), (double)parameters.first().value(), (double)parameters.first().value(), (double)parameters.first().value()), class_1301.field_6155).size() >= parameters.second().value()).orElse(false));
        RuleRegistry.registerConditionResolver("mobs_nearby", BiFloatParameter.class, (context, parameters) -> InbuiltConditions.pickLevel(context).map(level -> (float)level.method_8333((class_1297)context.getPlayer(), class_238.method_30048((class_243)context.getPos().method_46558(), (double)parameters.first().value(), (double)parameters.first().value(), (double)parameters.first().value()), it -> it instanceof class_1308).size() >= parameters.second().value()).orElse(false));
        RuleRegistry.registerConditionResolver("animals_nearby", BiFloatParameter.class, (context, parameters) -> InbuiltConditions.pickLevel(context).map(level -> (float)level.method_8333((class_1297)context.getPlayer(), class_238.method_30048((class_243)context.getPos().method_46558(), (double)parameters.first().value(), (double)parameters.first().value(), (double)parameters.first().value()), it -> it instanceof class_1429).size() >= parameters.second().value()).orElse(false));
        RuleRegistry.registerConditionResolver("entity_nearby", EntityNearbyParameter.class, (context, parameters) -> InbuiltConditions.pickLevel(context).map(level -> (float)level.method_8333((class_1297)context.getPlayer(), class_238.method_30048((class_243)context.getPos().method_46558(), (double)parameters.distance().value(), (double)parameters.distance().value(), (double)parameters.distance().value()), it -> parameters.entity().isTag() ? it.method_5864().method_20210(class_6862.method_40092((class_5321)class_7924.field_41266, (class_2960)parameters.entity().value())) : class_7923.field_41177.method_10221((Object)it.method_5864()).equals((Object)parameters.entity().value())).size() >= parameters.minimum().value()).orElse(false));
        RuleRegistry.registerConditionResolver("is_above_y", FloatParameter.class, (context, parameters) -> {
            class_2338 pos = context.getPos();
            return (float)pos.method_10264() > parameters.value();
        });
        RuleRegistry.registerConditionResolver("is_below_y", FloatParameter.class, (context, parameters) -> {
            class_2338 pos = context.getPos();
            return (float)pos.method_10264() < parameters.value();
        });
        RuleRegistry.registerConditionResolver("is_within", BoundsParameter.class, (context, parameters) -> {
            class_2338 pos = context.getPos();
            return pos.method_10263() >= parameters.minX().value() && pos.method_10263() <= parameters.maxX().value() && pos.method_10264() >= parameters.minY().value() && pos.method_10264() <= parameters.maxY().value() && pos.method_10260() >= parameters.minZ().value() && pos.method_10260() <= parameters.maxZ().value();
        });
        RuleRegistry.registerConditionResolver("is_at", PositionParameter.class, (context, parameters) -> {
            class_2338 pos = context.getPos();
            return pos.method_10263() == parameters.x().value() && pos.method_10264() == parameters.y().value() && pos.method_10260() == parameters.z().value();
        });
        RuleRegistry.registerConditionResolver("is_near", IsNearParameter.class, (context, parameters) -> {
            class_2338 pos = context.getPos();
            class_2338 rulePos = new class_2338(parameters.x().value(), parameters.y().value(), parameters.z().value());
            float maxDist = parameters.distance().value();
            double dist = pos.method_10262((class_2382)rulePos);
            return dist <= (double)(maxDist * maxDist);
        });
        RuleRegistry.registerConditionResolver("is_near_poi", IsNearPoiParameter.class, (context, parameters) -> context.viaServer(serverLevel -> {
            Optional poi = serverLevel.method_19494().method_43985(it -> false, context.getPos(), (int)parameters.distance().value(), class_4153.class_4155.field_18489);
            return poi.isPresent();
        }));
        RuleRegistry.registerConditionResolver("is_player", IsNearParameter.class, (context, parameters) -> !Balm.getHooks().isFakePlayer(context.getPlayer()));
        RuleRegistry.registerConditionResolver("has_advancement", IdParameter.class, (context, parameters) -> context.viaServer(serverLevel -> {
            class_3222 player = (class_3222)context.getPlayer();
            class_8779 advancement = player.method_51469().method_8503().method_3851().method_12896(parameters.value());
            if (advancement != null) {
                return player.method_14236().method_12882(advancement).method_740();
            }
            return false;
        }));
    }

    private static Optional<class_1936> pickLevelAccessor(BreakContext context) {
        class_1922 class_19222 = context.getBlockGetter();
        if (class_19222 instanceof class_1936) {
            class_1936 level = (class_1936)class_19222;
            return Optional.of(level);
        }
        return Optional.ofNullable(context.getPlayer()).map(class_1297::method_73183);
    }

    private static Optional<class_1937> pickLevel(BreakContext context) {
        class_1922 class_19222 = context.getBlockGetter();
        if (class_19222 instanceof class_1937) {
            class_1937 level = (class_1937)class_19222;
            return Optional.of(level);
        }
        return Optional.ofNullable(context.getPlayer()).map(class_1297::method_73183);
    }
}

