/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.unbreakables.rules.requirements;

import java.util.Optional;
import net.blay09.mods.unbreakables.api.BreakContext;
import net.blay09.mods.unbreakables.api.BreakHint;
import net.blay09.mods.unbreakables.api.BreakRequirement;
import net.blay09.mods.unbreakables.rules.hint.ExperiencePointsHint;
import net.minecraft.class_1657;

public class ExperiencePointsRequirement
implements BreakRequirement {
    private int points;

    public ExperiencePointsRequirement(int points) {
        this.points = Math.max(0, points);
    }

    @Override
    public boolean canAfford(BreakContext context, class_1657 player) {
        double xpForProgress;
        int xpForLevel = ExperiencePointsRequirement.getCumulativeXpNeededForLevel(player.field_7520);
        double totalXp = (double)xpForLevel + (xpForProgress = Math.floor(player.field_7510 * (float)ExperiencePointsRequirement.getXpNeededForNextLevel(player.field_7520)));
        return totalXp >= (double)this.points;
    }

    @Override
    public void consume(class_1657 player) {
        player.method_7255(-this.points);
    }

    @Override
    public void rollback(class_1657 player) {
        player.method_7255(this.points);
    }

    @Override
    public boolean isEmpty() {
        return this.points <= 0;
    }

    @Override
    public Optional<BreakHint<?>> hint(BreakContext context, class_1657 player) {
        return Optional.of(new ExperiencePointsHint(this.points));
    }

    public static int calculateLevelCostFromExperiencePoints(int currentLevel, int xpLoss) {
        return currentLevel - ExperiencePointsRequirement.calculateLevelMinusExperiencePoints(currentLevel, xpLoss);
    }

    private static int calculateLevelMinusExperiencePoints(int currentLevel, int xpLoss) {
        int currentCumulativeXp = ExperiencePointsRequirement.getCumulativeXpNeededForLevel(currentLevel);
        int remainingXp = currentCumulativeXp - xpLoss;
        int newLevel = 0;
        int newCumulativeXp = 0;
        for (int level = 0; level <= currentLevel; ++level) {
            if (remainingXp >= (newCumulativeXp += ExperiencePointsRequirement.getXpNeededForNextLevel(level))) continue;
            newLevel = level;
            break;
        }
        return newLevel;
    }

    private static int getXpNeededForNextLevel(int level) {
        if (level >= 30) {
            return 112 + (level - 30) * 9;
        }
        return level >= 15 ? 37 + (level - 15) * 5 : 7 + level * 2;
    }

    private static int getCumulativeXpNeededForLevel(int targetLevel) {
        int currentCumulativeXp = 0;
        for (int level = 0; level < targetLevel; ++level) {
            currentCumulativeXp += ExperiencePointsRequirement.getXpNeededForNextLevel(level);
        }
        return currentCumulativeXp;
    }

    public void setPoints(int value) {
        this.points = value;
    }

    public int getPoints() {
        return this.points;
    }
}

