/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.unbreakables;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.unbreakables.api.BreakContext;
import net.blay09.mods.unbreakables.api.BreakRequirement;
import net.blay09.mods.unbreakables.api.ConfiguredCondition;
import net.blay09.mods.unbreakables.api.RequirementFunction;
import net.blay09.mods.unbreakables.api.VariableResolver;
import net.blay09.mods.unbreakables.network.ClientboundUnbreakableStatusPacket;
import net.blay09.mods.unbreakables.rules.ConfiguredRule;
import net.blay09.mods.unbreakables.rules.RuleRegistry;
import net.blay09.mods.unbreakables.rules.hint.NoHint;
import net.blay09.mods.unbreakables.rules.requirements.ClientsideAssumedRequirement;
import net.blay09.mods.unbreakables.rules.requirements.CombinedRequirement;
import net.blay09.mods.unbreakables.rules.requirements.ConfiguredRequirement;
import net.blay09.mods.unbreakables.rules.requirements.NoRequirement;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;

public class BreakContextImpl
implements BreakContext {
    private final Map<ResourceLocation, BreakRequirement> requirements = new HashMap<ResourceLocation, BreakRequirement>();
    private final BlockGetter blockGetter;
    private final BlockPos pos;
    private final BlockState state;
    private final Player player;
    private boolean hasServersideConditions;
    private BreakRequirement resolvedRequirement;

    public BreakContextImpl(BlockGetter blockGetter, BlockPos pos, BlockState state, Player player) {
        this.blockGetter = blockGetter;
        this.pos = pos;
        this.state = state;
        this.player = player;
    }

    public <T extends BreakRequirement, P> void apply(ConfiguredRule<T, P> configuredModifier) {
        for (ConfiguredCondition<?> condition : configuredModifier.conditions()) {
            if (this.matchesCondition(condition)) continue;
            return;
        }
        ConfiguredRequirement<T, P> requirement = configuredModifier.requirement();
        RequirementFunction<T, P> modifier = requirement.modifier();
        P parameters = requirement.parameters();
        BreakRequirement existing = this.requirements.get(modifier.getRequirementType());
        if (existing == null) {
            existing = RuleRegistry.getRequirementType(modifier.getRequirementType()).createInstance();
        }
        this.requirements.put(modifier.getRequirementType(), modifier.apply(existing, this, parameters));
    }

    @Override
    public float getContextValue(ResourceLocation id) {
        VariableResolver resolver = RuleRegistry.getVariableResolver(id);
        if (resolver != null) {
            return resolver.resolve(this);
        }
        return 0.0f;
    }

    @Override
    public <P> boolean matchesCondition(ConfiguredCondition<P> configuredCondition) {
        return configuredCondition.resolver().matches(this, configuredCondition.parameters());
    }

    @Override
    public BreakRequirement resolve() {
        if (this.resolvedRequirement != null) {
            return this.resolvedRequirement;
        }
        BreakRequirement result = this.requirements.isEmpty() ? NoRequirement.INSTANCE : (this.requirements.size() == 1 ? this.requirements.values().iterator().next() : new CombinedRequirement(this.requirements.values()));
        this.resolvedRequirement = result;
        boolean breakable = this.resolvedRequirement.canAfford(this, this.player);
        if (this.hasServersideConditions && this.player instanceof ServerPlayer) {
            Balm.getNetworking().sendTo(this.player, (CustomPacketPayload)new ClientboundUnbreakableStatusPacket(this.pos, result.hint(this, this.player).orElse(NoHint.INSTANCE), breakable));
        }
        return result;
    }

    public void resolve(BreakRequirement resolvedRequirement) {
        this.resolvedRequirement = resolvedRequirement;
    }

    @Override
    public BlockGetter getBlockGetter() {
        return this.blockGetter;
    }

    @Override
    public BlockPos getPos() {
        return this.pos;
    }

    @Override
    public BlockState getState() {
        return this.state;
    }

    @Override
    public boolean viaServer(Function<ServerLevel, Boolean> runner) {
        this.hasServersideConditions = true;
        BlockGetter blockGetter = this.blockGetter;
        if (blockGetter instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)blockGetter;
            return runner.apply(serverLevel);
        }
        this.resolvedRequirement = ClientsideAssumedRequirement.INSTANCE;
        return false;
    }

    @Override
    public Player getPlayer() {
        return this.player;
    }
}

