/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.unbreakables.client.hint;

import com.mojang.blaze3d.platform.Window;
import java.util.Objects;
import net.blay09.mods.unbreakables.api.client.BreakHintRenderer;
import net.blay09.mods.unbreakables.rules.hint.MessageHint;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;

public class MessageHintRenderer
implements BreakHintRenderer<MessageHint> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"unbreakables", (String)"textures/gui/icons.png");

    @Override
    public void render(Window window, GuiGraphics guiGraphics, float partialTicks, MessageHint hint) {
        Font font = Minecraft.getInstance().font;
        int textWidth = font.width((FormattedText)hint.component());
        int x = window.getGuiScaledWidth() / 2 - 8 - textWidth / 2;
        int y = window.getGuiScaledHeight() / 2 - 8 + 16;
        guiGraphics.blit(TEXTURE, x, y, 0.0f, 0.0f, 16, 16, 256, 256);
        Component component = hint.component();
        Objects.requireNonNull(font);
        guiGraphics.drawString(font, component, x + 16 + 4, y + 8 - 9 / 2 + 1, -1);
    }
}

