/*
 * Decompiled with CFR 0.152.
 */
package com.alekiponi.ihearttfc;

import com.alekiponi.ihearttfc.IHTFCConfig;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Locale;
import net.dries007.tfc.client.ClimateRenderCache;
import net.dries007.tfc.common.component.food.INutritionData;
import net.dries007.tfc.common.component.food.Nutrient;
import net.dries007.tfc.common.entities.livestock.horse.TFCHorse;
import net.dries007.tfc.common.entities.misc.TFCFishingHook;
import net.dries007.tfc.common.player.IPlayerInfo;
import net.dries007.tfc.common.player.PlayerInfo;
import net.dries007.tfc.config.TFCConfig;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.camel.Camel;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FishingHook;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;
import net.neoforged.neoforge.client.event.RenderGuiLayerEvent;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;
import oshi.util.tuples.Pair;

public final class IngameOverlays
extends Enum<IngameOverlays> {
    public static final /* enum */ IngameOverlays HEALTH = new IngameOverlays(IngameOverlays::renderHealth);
    public static final /* enum */ IngameOverlays FOOD = new IngameOverlays(IngameOverlays::renderFood);
    public static final /* enum */ IngameOverlays THIRST = new IngameOverlays(IngameOverlays::renderThirst);
    public static final /* enum */ IngameOverlays MOUNT_HEALTH = new IngameOverlays(IngameOverlays::renderMountHealth);
    public static final /* enum */ IngameOverlays TEMPERATURE = new IngameOverlays(IngameOverlays::renderTemperature);
    private static final ResourceLocation VANILLA_EXP;
    private static final ResourceLocation VANILLA_EXP_LEVEL;
    private static final ResourceLocation VANILLA_JUMP;
    static int[] cachedNutrition;
    static long previousTick;
    public static final ResourceLocation TEXTURE;
    final LayeredDraw.Layer overlay;
    private final String id = this.name().toLowerCase(Locale.ROOT);
    private static final /* synthetic */ IngameOverlays[] $VALUES;

    public static IngameOverlays[] values() {
        return (IngameOverlays[])$VALUES.clone();
    }

    public static IngameOverlays valueOf(String name) {
        return Enum.valueOf(IngameOverlays.class, name);
    }

    private IngameOverlays(LayeredDraw.Layer overlay) {
        this.overlay = overlay;
    }

    public static void registerOverlays(RegisterGuiLayersEvent event) {
        IngameOverlays.above(event, VanillaGuiLayers.PLAYER_HEALTH, TEMPERATURE);
        IngameOverlays.above(event, VanillaGuiLayers.PLAYER_HEALTH, HEALTH);
        IngameOverlays.above(event, VanillaGuiLayers.VEHICLE_HEALTH, MOUNT_HEALTH);
        IngameOverlays.above(event, VanillaGuiLayers.FOOD_LEVEL, THIRST);
        IngameOverlays.above(event, VanillaGuiLayers.FOOD_LEVEL, FOOD);
    }

    private static void above(RegisterGuiLayersEvent event, ResourceLocation vanilla, IngameOverlays overlay) {
        event.registerAbove(vanilla, ResourceLocation.fromNamespaceAndPath((String)"ihearttfc", (String)overlay.id), overlay.overlay);
    }

    public static void checkGuiOverlays(RenderGuiLayerEvent.Pre event) {
        ResourceLocation id = event.getName();
        if (!IHTFCConfig.CLIENT.useIHeartTFC.get().booleanValue() && (id.equals((Object)VANILLA_EXP) || id.equals((Object)VANILLA_EXP_LEVEL))) {
            event.setCanceled(true);
        }
        if (IHTFCConfig.CLIENT.showTemperatureInsteadOfExperience.get().booleanValue() && (id.equals((Object)VANILLA_EXP) || id.equals((Object)VANILLA_EXP_LEVEL))) {
            event.setCanceled(true);
        }
    }

    private static void renderHealth(GuiGraphics graphics, DeltaTracker delta) {
        if (!IHTFCConfig.CLIENT.useIHeartTFC.get().booleanValue()) {
            return;
        }
        Minecraft minecraft = Minecraft.getInstance();
        if (IngameOverlays.setupForSurvival(graphics, minecraft)) {
            Player player = (Player)minecraft.getCameraEntity();
            assert (player != null);
            IngameOverlays.renderHealthBar((LivingEntity)player, Minecraft.getInstance().gui, graphics, graphics.guiWidth(), graphics.guiHeight(), false);
        }
    }

    private static void renderMountHealth(GuiGraphics graphics, DeltaTracker delta) {
        Minecraft minecraft = Minecraft.getInstance();
        if (IngameOverlays.setupForSurvival(graphics, minecraft)) {
            Player player = (Player)minecraft.getCameraEntity();
            assert (player != null);
            Entity entity = player.getVehicle();
            if (entity instanceof LivingEntity) {
                LivingEntity entity2 = (LivingEntity)entity;
                IngameOverlays.renderHealthBar(entity2, Minecraft.getInstance().gui, graphics, graphics.guiWidth(), graphics.guiHeight(), true);
            }
        }
    }

    private static boolean setupForSurvival(GuiGraphics gui, Minecraft minecraft) {
        MultiPlayerGameMode gm = Minecraft.getInstance().gameMode;
        return gm != null && gm.canHurtPlayer() && IngameOverlays.setup(gui, minecraft);
    }

    private static void renderHealthBar(LivingEntity entity, Gui gui, GuiGraphics graphics, int width, int height, boolean mount) {
        int col;
        int row;
        int i;
        Player player;
        boolean vanilla = IHTFCConfig.CLIENT.useSmallHearts.get() == false;
        boolean renderPartialHearts = IHTFCConfig.CLIENT.renderPartialHearts.get();
        int heartsize = 5;
        int offset = 0;
        int colWidth = 4;
        int rowHeight = 5;
        int heartValue = 25;
        int heartsPerRow = 20;
        if (vanilla) {
            heartsize = 9;
            offset = 64;
            colWidth = 8;
            rowHeight = 3;
            heartValue = 100;
            heartsPerRow = 10;
        }
        int mountOffset = mount ? 2 * heartsize : 0;
        PoseStack stack = graphics.pose();
        int yOffsetFromXp = (Boolean)TFCConfig.CLIENT.enableExperienceBar.get() != false ? 5 : -1;
        float absorption = entity.getAbsorptionAmount();
        absorption = Float.isNaN(absorption) ? 0.0f : absorption;
        float percentAbsorbtion = absorption / entity.getMaxHealth();
        float percentHealth = entity.getHealth() / entity.getMaxHealth();
        float surplusPercent = Mth.clamp((float)(percentHealth + absorption / 20.0f - 1.0f), (float)0.0f, (float)1.0f);
        float healthModifier = 1.0f;
        if (!mount && entity instanceof Player) {
            Player player2 = (Player)entity;
            PlayerInfo playerInfo = (PlayerInfo)IPlayerInfo.get((Player)player2);
            healthModifier = IPlayerInfo.get((Player)player2).getHealthModifier();
        }
        float maxHealth = entity.getMaxHealth();
        float maxHealthModified = maxHealth * healthModifier * 50.0f;
        float currentHealth = percentHealth * maxHealth;
        float curHealthModified = currentHealth * healthModifier * 50.0f;
        float currentAbsorption = percentAbsorbtion * maxHealth;
        float curAbsorptionModified = currentAbsorption * healthModifier * 50.0f;
        float currentHealthWithAbsorptionModified = curAbsorptionModified + curHealthModified;
        int centerX = width / 2;
        int y = height - gui.leftHeight;
        boolean isHurt = entity.getHealth() > 0.0f && entity.getHealth() < entity.getMaxHealth();
        boolean playerHasSaturation = entity instanceof Player && (player = (Player)entity).getFoodData().getSaturationLevel() > 0.0f;
        stack.pushPose();
        stack.translate((float)(centerX - 91), (float)y, 0.0f);
        int totalHearts = (int)(maxHealthModified / (float)heartValue);
        int starty = (totalHearts / heartsPerRow - 1) * rowHeight - heartsize / 2 + 5;
        starty = !vanilla ? (starty += 5) : (starty += 2);
        starty = vanilla ? starty : starty - 6;
        int heartsShownInFull = (int)(curHealthModified / (float)heartValue);
        int addedHeight = 10 + starty;
        for (i = 0; i <= totalHearts + 1; ++i) {
            int pctLeftOver;
            float leftOver;
            row = i / heartsPerRow;
            col = i % heartsPerRow;
            if (i < totalHearts) {
                graphics.blit(TEXTURE, col * colWidth, row * rowHeight - starty, offset, 0, heartsize, heartsize);
                if (i < heartsShownInFull) {
                    graphics.blit(TEXTURE, col * colWidth, row * rowHeight - starty, offset + mountOffset, heartsize, heartsize, heartsize);
                } else if (playerHasSaturation && isHurt || entity.hurtTime > 0 || entity.hasEffect(MobEffects.REGENERATION)) {
                    graphics.blit(TEXTURE, col * colWidth, row * rowHeight - starty, offset, 0, heartsize, heartsize);
                    graphics.blit(TEXTURE, col * colWidth, row * rowHeight - starty, offset, heartsize * 2, heartsize, heartsize);
                }
            }
            if (renderPartialHearts && i == totalHearts + 1) {
                leftOver = Math.abs((float)totalHearts * (float)heartValue - maxHealthModified);
                pctLeftOver = (int)(leftOver / (float)heartValue * (float)heartsize);
                graphics.blit(TEXTURE, totalHearts % heartsPerRow * colWidth, totalHearts / heartsPerRow * rowHeight - starty, offset, 0, pctLeftOver, heartsize);
                if (playerHasSaturation && isHurt || entity.hurtTime > 0 || entity.hasEffect(MobEffects.REGENERATION)) {
                    graphics.blit(TEXTURE, totalHearts % heartsPerRow * colWidth, totalHearts / heartsPerRow * rowHeight - starty, offset, heartsize * 2, pctLeftOver, heartsize);
                    graphics.blit(TEXTURE, totalHearts % heartsPerRow * colWidth + pctLeftOver, totalHearts / heartsPerRow * rowHeight - starty, offset + heartsize * 3 + pctLeftOver, 0, 1, heartsize);
                } else if (curHealthModified >= maxHealthModified - 1.0f) {
                    graphics.blit(TEXTURE, totalHearts % heartsPerRow * colWidth + pctLeftOver, totalHearts / heartsPerRow * rowHeight - starty, offset + heartsize * 2 + pctLeftOver, 0, 1, heartsize);
                } else {
                    graphics.blit(TEXTURE, totalHearts % heartsPerRow * colWidth + pctLeftOver, totalHearts / heartsPerRow * rowHeight - starty, offset + heartsize + pctLeftOver, 0, 1, heartsize);
                }
            }
            if (i != heartsShownInFull + 1 || i == totalHearts + 1 && !renderPartialHearts) continue;
            leftOver = Math.abs((float)heartsShownInFull * (float)heartValue - curHealthModified);
            pctLeftOver = (int)(leftOver / (float)heartValue * (float)heartsize);
            graphics.blit(TEXTURE, heartsShownInFull % heartsPerRow * colWidth, heartsShownInFull / heartsPerRow * rowHeight - starty, offset + mountOffset, heartsize, pctLeftOver, heartsize);
        }
        if (curAbsorptionModified > 0.0f) {
            heartsShownInFull = (int)(curAbsorptionModified / (float)heartValue);
            starty = (heartsShownInFull / heartsPerRow - 1) * rowHeight + heartsize + 5 + starty;
            addedHeight = 10 + starty;
            for (i = 0; i < heartsShownInFull + 1; ++i) {
                row = i / heartsPerRow;
                col = i % heartsPerRow;
                graphics.blit(TEXTURE, col * colWidth, row * rowHeight - starty, offset, 0, heartsize, heartsize);
                if (i >= heartsShownInFull) continue;
                graphics.blit(TEXTURE, col * colWidth, row * rowHeight - starty, offset + heartsize, heartsize, heartsize, heartsize);
            }
            float leftOver = Math.abs((float)heartsShownInFull * (float)heartValue - curAbsorptionModified);
            int pctLeftOver = (int)(leftOver / (float)heartValue * (float)heartsize);
            graphics.blit(TEXTURE, heartsShownInFull % heartsPerRow * colWidth, heartsShownInFull / heartsPerRow * rowHeight - starty, offset + heartsize, heartsize, pctLeftOver, heartsize);
        }
        stack.popPose();
        gui.leftHeight += addedHeight;
    }

    public static void renderFood(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        if (!IHTFCConfig.CLIENT.useIHeartTFC.get().booleanValue()) {
            return;
        }
        Gui gui = Minecraft.getInstance().gui;
        boolean displaySaturation = IHTFCConfig.CLIENT.displayAppleskinLikeSaturation.get();
        PoseStack stack = guiGraphics.pose();
        Minecraft minecraft = Minecraft.getInstance();
        if (IngameOverlays.setupForSurvival(guiGraphics, minecraft)) {
            int columns;
            int min;
            int selected;
            int i;
            Player player = (Player)minecraft.getCameraEntity();
            assert (player != null);
            PlayerInfo playerInfo = (PlayerInfo)IPlayerInfo.get((Player)player);
            INutritionData nutritionData = playerInfo.nutrition();
            boolean recalculateNutrition = false;
            if ((long)player.tickCount != previousTick) {
                previousTick = player.tickCount;
                recalculateNutrition = true;
            }
            int x = guiGraphics.guiWidth() / 2;
            int y = guiGraphics.guiHeight() - gui.rightHeight;
            if (recalculateNutrition) {
                cachedNutrition = new int[]{0, 0, 0, 0, 0};
                float totalNutrition = 0.0f;
                for (float nutrition : nutritionData.getNutrients()) {
                    totalNutrition += nutrition;
                }
                ArrayList<Pair<Nutrient, Float>> pcts = new ArrayList<Pair<Nutrient, Float>>();
                pcts.add(new Pair((Object)Nutrient.PROTEIN, (Object)Float.valueOf(nutritionData.getNutrient(Nutrient.PROTEIN) / totalNutrition * 10.0f)));
                pcts.add(new Pair((Object)Nutrient.VEGETABLES, (Object)Float.valueOf(nutritionData.getNutrient(Nutrient.VEGETABLES) / totalNutrition * 10.0f)));
                pcts.add(new Pair((Object)Nutrient.DAIRY, (Object)Float.valueOf(nutritionData.getNutrient(Nutrient.DAIRY) / totalNutrition * 10.0f)));
                pcts.add(new Pair((Object)Nutrient.FRUIT, (Object)Float.valueOf(nutritionData.getNutrient(Nutrient.FRUIT) / totalNutrition * 10.0f)));
                pcts.add(new Pair((Object)Nutrient.GRAIN, (Object)Float.valueOf(nutritionData.getNutrient(Nutrient.GRAIN) / totalNutrition * 10.0f)));
                pcts.sort(Comparator.comparing(p -> Float.valueOf(-((Float)p.getB()).floatValue())));
                for (int iteration = 0; IngameOverlays.sum(pcts) < 10 && iteration < pcts.size(); ++iteration) {
                    pcts.set(iteration, (Pair<Nutrient, Float>)new Pair((Object)((Nutrient)pcts.get(iteration).getA()), (Object)Float.valueOf(((Float)pcts.get(iteration).getB()).floatValue() + 1.0f)));
                }
                for (Pair<Nutrient, Float> pair : pcts) {
                    switch ((Nutrient)pair.getA()) {
                        case PROTEIN: {
                            IngameOverlays.cachedNutrition[0] = (int)((Float)pair.getB()).floatValue();
                            break;
                        }
                        case VEGETABLES: {
                            IngameOverlays.cachedNutrition[1] = (int)((Float)pair.getB()).floatValue();
                            break;
                        }
                        case DAIRY: {
                            IngameOverlays.cachedNutrition[2] = (int)((Float)pair.getB()).floatValue();
                            break;
                        }
                        case FRUIT: {
                            IngameOverlays.cachedNutrition[3] = (int)((Float)pair.getB()).floatValue();
                            break;
                        }
                        case GRAIN: {
                            IngameOverlays.cachedNutrition[4] = (int)((Float)pair.getB()).floatValue();
                        }
                    }
                }
            }
            int fullIcons = (int)((float)player.getFoodData().getFoodLevel() / 20.0f * 10.0f);
            int fullSaturation = (int)(player.getFoodData().getSaturationLevel() / 20.0f * 10.0f);
            int starty = -5;
            stack.pushPose();
            stack.translate((float)(x + 1), (float)(y + 4), 0.0f);
            int[] nutrition = new int[5];
            System.arraycopy(cachedNutrition, 0, nutrition, 0, cachedNutrition.length);
            for (i = 0; i < 10; ++i) {
                selected = -1;
                min = Integer.MAX_VALUE;
                for (int j = 0; j < 5; ++j) {
                    if (nutrition[j] >= min || nutrition[j] <= 0) continue;
                    min = nutrition[j];
                    selected = j;
                }
                selected = Mth.clamp((int)selected, (int)0, (int)4);
                if (i < fullIcons) {
                    IngameOverlays.renderFoodIcon(selected, i, 9, starty, guiGraphics, false);
                }
                if (i == fullIcons) {
                    float leftOver = (float)player.getFoodData().getFoodLevel() / 2.0f - (float)fullIcons;
                    columns = (int)(leftOver * 9.0f);
                    IngameOverlays.renderFoodIcon(selected, i, columns, starty, guiGraphics, false);
                }
                if (i > fullIcons) {
                    IngameOverlays.renderFoodIcon(selected, i, 0, starty, guiGraphics, false);
                }
                int n = selected;
                nutrition[n] = nutrition[n] - 1;
            }
            if (displaySaturation) {
                System.arraycopy(cachedNutrition, 0, nutrition, 0, cachedNutrition.length);
                for (i = 0; i < 10; ++i) {
                    selected = -1;
                    min = Integer.MAX_VALUE;
                    for (int j = 0; j < 5; ++j) {
                        if (nutrition[j] >= min || nutrition[j] <= 0) continue;
                        min = nutrition[j];
                        selected = j;
                    }
                    selected = Mth.clamp((int)selected, (int)0, (int)4);
                    if (i < fullSaturation) {
                        IngameOverlays.renderFoodIcon(selected, i, 9, starty, guiGraphics, true);
                    }
                    if (i == fullSaturation) {
                        float leftOver = player.getFoodData().getSaturationLevel() / 2.0f - (float)fullSaturation;
                        columns = (int)(leftOver * 9.0f);
                        IngameOverlays.renderFoodIcon(selected, i, columns, starty, guiGraphics, true);
                    }
                    if (i > fullSaturation) {
                        IngameOverlays.renderFoodIcon(selected, i, 0, starty, guiGraphics, true);
                    }
                    int n = selected;
                    nutrition[n] = nutrition[n] - 1;
                }
            }
            stack.popPose();
            int addedHeight = 10 + starty;
            gui.rightHeight += addedHeight;
        }
    }

    private static int sum(ArrayList<Pair<Nutrient, Float>> pcts) {
        int total1 = 0;
        for (Pair<Nutrient, Float> pct : pcts) {
            total1 += (int)((Float)pct.getB()).floatValue();
        }
        return total1;
    }

    public static void renderThirst(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        if (!IHTFCConfig.CLIENT.useIHeartTFC.get().booleanValue()) {
            return;
        }
        Gui gui = Minecraft.getInstance().gui;
        PoseStack stack = guiGraphics.pose();
        Minecraft minecraft = Minecraft.getInstance();
        if (IngameOverlays.setupForSurvival(guiGraphics, minecraft)) {
            Player player = (Player)minecraft.getCameraEntity();
            assert (player != null);
            PlayerInfo playerInfo = (PlayerInfo)IPlayerInfo.get((Player)player);
            float thirst = playerInfo.getThirst();
            int x = guiGraphics.guiWidth() / 2;
            int y = guiGraphics.guiHeight() - gui.rightHeight;
            float percentThirst = thirst / 100.0f;
            int fullIcons = (int)(percentThirst * 10.0f);
            int starty = -10;
            stack.pushPose();
            stack.translate((float)(x + 1), (float)(y + 4), 0.0f);
            for (int i = 0; i < 10; ++i) {
                if (i < fullIcons) {
                    IngameOverlays.renderThirstIcon(i, 9.0f, starty, guiGraphics);
                }
                if (i == fullIcons) {
                    float leftOver = thirst / 10.0f - (float)fullIcons;
                    IngameOverlays.renderThirstIcon(i, leftOver, starty, guiGraphics);
                }
                if (i <= fullIcons) continue;
                IngameOverlays.renderThirstIcon(i, 0.0f, starty, guiGraphics);
            }
            stack.popPose();
            gui.rightHeight += -starty + 6;
        }
    }

    public static void renderTemperature(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        FishingHook var7;
        if (!IHTFCConfig.CLIENT.useIHeartTFC.get().booleanValue()) {
            return;
        }
        if (!IHTFCConfig.CLIENT.showTemperatureInsteadOfExperience.get().booleanValue()) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer localPlayer = mc.player;
        if (localPlayer != null && (var7 = localPlayer.fishing) instanceof TFCFishingHook) {
            return;
        }
        Gui gui = Minecraft.getInstance().gui;
        PoseStack stack = guiGraphics.pose();
        Minecraft minecraft = Minecraft.getInstance();
        if (IngameOverlays.setupForSurvival(guiGraphics, minecraft)) {
            Camel camel;
            TFCHorse tfcHorse;
            AbstractHorse abstractHorse;
            Player player = (Player)minecraft.getCameraEntity();
            assert (player != null);
            PlayerInfo playerInfo = (PlayerInfo)IPlayerInfo.get((Player)player);
            Entity vehicle = player.getVehicle();
            if (vehicle instanceof AbstractHorse && (abstractHorse = (AbstractHorse)vehicle).isTamed() && abstractHorse.isSaddled()) {
                return;
            }
            if (vehicle instanceof TFCHorse && (tfcHorse = (TFCHorse)vehicle).isTamed() && tfcHorse.isSaddled()) {
                return;
            }
            if (vehicle instanceof Camel && (camel = (Camel)vehicle).isTamed() && camel.isSaddled()) {
                return;
            }
            int x = guiGraphics.guiWidth() / 2;
            int y = guiGraphics.guiHeight() - gui.rightHeight;
            float currentTemp = ClimateRenderCache.INSTANCE.getTemperature();
            if (!Float.isNaN(currentTemp)) {
                int starty = 6;
                stack.pushPose();
                stack.translate((float)(x + 1), (float)(y + 4), 0.0f);
                float overheat = 0.0f;
                overheat = playerInfo.getThirstContributionFromTemperature();
                if (overheat > 0.0f) {
                    guiGraphics.blit(TEXTURE, -92, starty, 0, 69, 182, 5);
                } else {
                    guiGraphics.blit(TEXTURE, -92, starty, 0, 64, 182, 5);
                }
                float percentTemp = (Mth.clamp((float)currentTemp, (float)-45.0f, (float)45.0f) + 45.0f) / 90.0f;
                int pixels = (int)(percentTemp * 178.0f);
                guiGraphics.blit(TEXTURE, -92 + pixels, starty - 2, 0, 74, 7, 9);
                stack.popPose();
            }
        }
    }

    private static void renderFoodIcon(int nutrient, int col, int pixels, int starty, GuiGraphics graphics, boolean saturation) {
        int voffset;
        boolean useHalfEatenFood = IHTFCConfig.CLIENT.useHalfEatenFood.get();
        int xoffset = 64;
        int yoffset = 27;
        col = 10 - col;
        switch (nutrient) {
            case 1: {
                xoffset += 36;
                break;
            }
            case 2: {
                xoffset += 9;
                break;
            }
            case 3: {
                xoffset += 18;
                break;
            }
            case 4: {
                xoffset += 27;
            }
        }
        int n = voffset = saturation ? 18 : 0;
        if (pixels < 9) {
            int start = 9 - pixels;
            if (!saturation) {
                graphics.blit(TEXTURE, col * 8 + 1, starty, xoffset, 36, 9, 9);
            }
            if (!useHalfEatenFood || saturation) {
                graphics.blit(TEXTURE, col * 8 + 1 + start, starty, xoffset + start, 27 + voffset, pixels, 9);
            } else if (pixels > 1) {
                graphics.blit(TEXTURE, col * 8 + 1, starty, xoffset, 54, 9, 9);
            }
        } else {
            graphics.blit(TEXTURE, col * 8 + 1, starty, xoffset, 27 + voffset, 9, 9);
        }
    }

    private static void renderThirstIcon(int col, float percent, int starty, GuiGraphics graphics) {
        int pixels = (int)(percent * 9.0f);
        boolean emptyDroplets = IHTFCConfig.CLIENT.useEmptyDroplets.get();
        int emptyOffset = emptyDroplets ? 0 : 9;
        int xoffset = 109;
        int yoffset = 27;
        col = 10 - col;
        if (pixels < 9) {
            int start = 9 - pixels;
            if (emptyDroplets) {
                graphics.blit(TEXTURE, col * 8 + 1, starty, xoffset + emptyOffset, 36, 9, 9);
                graphics.blit(TEXTURE, col * 8 + 1, starty + start, xoffset, 27 + start, 9, pixels);
            } else if (percent > 0.95f) {
                graphics.blit(TEXTURE, col * 8 + 1, starty, xoffset, 27, 9, 9);
            } else if (percent > 0.66f) {
                graphics.blit(TEXTURE, col * 8 + 1, starty, xoffset + 9 + 9, 27, 9, 9);
            } else if (percent > 0.33f) {
                graphics.blit(TEXTURE, col * 8 + 1, starty, xoffset + 9 + 18, 27, 9, 9);
            } else {
                graphics.blit(TEXTURE, col * 8 + 1, starty, xoffset + 9 + 27, 27, 9, 9);
            }
        } else {
            graphics.blit(TEXTURE, col * 8 + 1, starty, xoffset, 27, 9, 9);
        }
    }

    private static int sum(int[] percents) {
        int total = 0;
        for (int pct : percents) {
            total += pct;
        }
        return total;
    }

    public static boolean setup(GuiGraphics gui, Minecraft minecraft) {
        return !minecraft.options.hideGui && minecraft.getCameraEntity() instanceof Player;
    }

    private static /* synthetic */ IngameOverlays[] $values() {
        return new IngameOverlays[]{HEALTH, FOOD, THIRST, MOUNT_HEALTH, TEMPERATURE};
    }

    static {
        $VALUES = IngameOverlays.$values();
        VANILLA_EXP = VanillaGuiLayers.EXPERIENCE_BAR;
        VANILLA_EXP_LEVEL = VanillaGuiLayers.EXPERIENCE_LEVEL;
        VANILLA_JUMP = VanillaGuiLayers.JUMP_METER;
        cachedNutrition = new int[]{0, 0, 0, 0, 0};
        previousTick = 0L;
        TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"ihearttfc", (String)"textures/gui/icons/overlay.png");
    }
}

