/*
 * Decompiled with CFR 0.152.
 */
package nl.gjorgdy.solute_extras.modules;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import net.minecraft.class_3965;
import net.minecraft.class_5819;
import nl.gjorgdy.solute_extras.models.Drops;
import nl.gjorgdy.solute_extras.utils.BlockUtils;
import nl.gjorgdy.solute_extras.utils.ToolHandler;

public class Enchantment {
    public static Optional<class_1799> crush(class_5819 random, class_2248 block, int fortune) {
        if (block == class_2246.field_10458) {
            return Optional.ofNullable(class_1802.field_8516.method_7854());
        }
        if (block == class_2246.field_10242) {
            return Optional.ofNullable(class_1802.field_8764.method_7854());
        }
        if (block == class_2246.field_10011) {
            return Optional.ofNullable(class_1802.field_8164.method_7854());
        }
        if (block == class_2246.field_10308) {
            return Optional.ofNullable(class_1802.field_8593.method_7854());
        }
        if (block == class_2246.field_10421) {
            return Optional.ofNullable(class_1802.field_8418.method_7854());
        }
        if (block == class_2246.field_10367) {
            return Optional.ofNullable(class_1802.field_8198.method_7854());
        }
        if (block == class_2246.field_10542) {
            return Optional.ofNullable(class_1802.field_8205.method_7854());
        }
        if (block == class_2246.field_10210) {
            return Optional.ofNullable(class_1802.field_8487.method_7854());
        }
        if (block == class_2246.field_10439) {
            return Optional.ofNullable(class_1802.field_8437.method_7854());
        }
        if (block == class_2246.field_10058) {
            return Optional.ofNullable(class_1802.field_8757.method_7854());
        }
        if (block == class_2246.field_10206) {
            return Optional.ofNullable(class_1802.field_8690.method_7854());
        }
        if (block == class_2246.field_10585) {
            return Optional.ofNullable(class_1802.field_8336.method_7854());
        }
        if (block == class_2246.field_10434) {
            return Optional.ofNullable(class_1802.field_8222.method_7854());
        }
        if (block == class_2246.field_10107) {
            return Optional.ofNullable(class_1802.field_8582.method_7854());
        }
        if (block == class_2246.field_10172) {
            return Optional.ofNullable(class_1802.field_8558.method_7854());
        }
        if (block == class_2246.field_10038) {
            return Optional.ofNullable(class_1802.field_8818.method_7854());
        }
        if (block == class_2246.field_9979) {
            class_1799 stack = class_1802.field_8858.method_7854();
            stack.method_7939(Enchantment.getAmount(fortune, random));
            return Optional.of(stack);
        }
        if (block == class_2246.field_10344) {
            class_1799 stack = class_1802.field_8200.method_7854();
            stack.method_7939(Enchantment.getAmount(fortune, random));
            return Optional.of(stack);
        }
        if (block == class_2246.field_10445) {
            class_1799 stack = class_1802.field_8110.method_7854();
            stack.method_7939(Enchantment.getAmount(fortune, random));
            return Optional.of(stack);
        }
        return Optional.empty();
    }

    private static int getAmount(int fortune, class_5819 random) {
        int amount = random.method_43048(1) + 1;
        return Math.min(amount + fortune, 4);
    }

    public static void drill(class_1937 world, class_1657 player, class_2338 pos, class_2680 blockState, int depth) {
        class_1799 tool = player.method_6047();
        ToolHandler toolHandler = new ToolHandler(tool);
        if (!toolHandler.test(blockState)) {
            return;
        }
        class_239 hitResult = player.method_5745(player.method_55754(), 0.0f, false);
        ArrayList<Drops> dropsInstances = new ArrayList<Drops>();
        if (hitResult.method_17783() == class_239.class_240.field_1332) {
            class_3965 bhr = (class_3965)hitResult;
            float hardnessRef = blockState.method_26204().method_36555();
            class_2382 targetVec = bhr.method_17780().method_62675();
            if (Enchantment.isLookingAt(player.method_5720(), targetVec, 0.55f, 0.55f)) {
                class_2382 dir = targetVec.method_35862(-1);
                for (int i = 0; i < depth; ++i) {
                    class_2338 _pos = pos.method_10081(dir.method_35862(i));
                    dropsInstances.add(Enchantment.tryBreakBlock(world, _pos, player, tool, hardnessRef, toolHandler));
                }
            }
        }
        Enchantment.DropDrops(world, player, pos, dropsInstances);
    }

    public static void lumber(class_1937 world, class_1657 player, class_2338 pos, class_2680 blockState) {
        class_1799 tool = player.method_6047();
        ToolHandler toolHandler = new ToolHandler(tool);
        if (!toolHandler.test(blockState)) {
            return;
        }
        if (!blockState.method_26164(class_3481.field_15475) && !blockState.method_27852(class_2246.field_37546)) {
            return;
        }
        class_2248 log = blockState.method_26204();
        Predicate<class_2338> belongsToTree = log == class_2246.field_37546 || log == class_2246.field_37545 ? _pos -> {
            class_2680 _blockState = world.method_8320(_pos);
            return _blockState.method_27852(class_2246.field_37546) || _blockState.method_27852(class_2246.field_37545);
        } : _pos -> {
            class_2680 _blockState = world.method_8320(_pos);
            return _blockState.method_27852(log);
        };
        AtomicInteger logs = new AtomicInteger();
        Enchantment.ForAxis(true, false, true, pos, _pos -> {
            if (belongsToTree.test((class_2338)_pos)) {
                logs.getAndIncrement();
            }
        });
        if (logs.get() > 1) {
            return;
        }
        List<class_2338> positions = Enchantment.findLogs(new ArrayList<class_2338>(), pos, belongsToTree, 48);
        List<Drops> dropsInstances = positions.stream().map(bp -> BlockUtils.breakBlockReturnDrop((class_3218)world, bp, player, tool)).toList();
        Enchantment.DropDrops(world, player, pos, dropsInstances);
    }

    private static List<class_2338> findLogs(List<class_2338> positions, class_2338 pos, Predicate<class_2338> belongsToTree, int depth) {
        if (depth <= 0) {
            return positions;
        }
        positions.add(pos);
        Consumer<class_2338> consumer = _pos -> {
            if (positions.contains(_pos)) {
                return;
            }
            if (belongsToTree.test((class_2338)_pos)) {
                Enchantment.findLogs(positions, _pos, belongsToTree, depth - 1);
            }
        };
        Enchantment.ForAxis(-1, 1, 0, 1, -1, 1, pos, consumer);
        return positions;
    }

    public static void excavate(class_1937 world, class_1657 player, class_2338 pos, class_2680 blockState) {
        class_1799 tool = player.method_6047();
        ToolHandler toolHandler = new ToolHandler(tool);
        if (!toolHandler.test(blockState)) {
            return;
        }
        ArrayList<Drops> dropsInstances = new ArrayList<Drops>();
        class_239 hitResult = player.method_5745(player.method_55754(), 0.0f, false);
        if (hitResult.method_17783() == class_239.class_240.field_1332) {
            class_3965 bhr = (class_3965)hitResult;
            float hardnessRef = blockState.method_26204().method_36555();
            Enchantment.ForAxis(player, bhr.method_17780(), pos, _pos -> dropsInstances.add(Enchantment.tryBreakBlock(world, _pos, player, tool, hardnessRef, toolHandler)));
        }
        Enchantment.DropDrops(world, player, pos, dropsInstances);
    }

    private static void DropDrops(class_1937 world, class_1657 player, class_2338 pos, List<Drops> dropsInstances) {
        boolean hasEntity;
        Drops drops = Drops.Merge(dropsInstances);
        class_2586 _blockEntity = world.method_8321(pos);
        boolean bl = hasEntity = _blockEntity != null;
        if (!player.method_68878() && !hasEntity) {
            drops.items().forEach(drop -> class_2248.method_9577((class_1937)world, (class_2338)pos, (class_1799)drop));
            BlockUtils.dropExperience((class_3218)world, pos, drops.experience());
        }
    }

    private static Drops tryBreakBlock(class_1937 world, class_2338 pos, class_1657 player, class_1799 tool, float hardnessRef, ToolHandler toolHandler) {
        class_2680 _blockState = world.method_8320(pos);
        float hardness = _blockState.method_26204().method_36555();
        if (Math.abs(hardnessRef - hardness) < 0.5f && toolHandler.test(_blockState)) {
            return BlockUtils.breakBlockReturnDrop((class_3218)world, pos, player, tool);
        }
        return Drops.EMPTY;
    }

    private static void ForAxis(class_1657 player, class_2350 direction, class_2338 center, Consumer<class_2338> consumer) {
        class_2382 vec = direction.method_62675();
        if (Enchantment.isLookingAt(player.method_5720(), vec, 0.6f, 0.35f)) {
            Enchantment.ForAxis(vec.method_10263() == 0, vec.method_10264() == 0, vec.method_10260() == 0, center, consumer);
        }
    }

    private static boolean isLookingAt(class_243 playerRotationVector, class_2382 targetVector, float verticalTolerance, float horizontalTolerance) {
        class_243 playerVec = playerRotationVector.method_1021(-1.0);
        return Math.abs((double)targetVector.method_10263() - playerVec.method_10216()) <= (double)horizontalTolerance && Math.abs((double)targetVector.method_10264() - playerVec.method_10214()) <= (double)verticalTolerance && Math.abs((double)targetVector.method_10260() - playerVec.method_10215()) <= (double)horizontalTolerance;
    }

    private static void ForAxis(boolean xAxis, boolean yAxis, boolean zAxis, class_2338 center, Consumer<class_2338> consumer) {
        Enchantment.ForAxis(xAxis ? -1 : 0, xAxis ? 1 : 0, yAxis ? -1 : 0, yAxis ? 1 : 0, zAxis ? -1 : 0, zAxis ? 1 : 0, center, consumer);
    }

    private static void ForAxis(int xA, int xB, int yA, int yB, int zA, int zB, class_2338 center, Consumer<class_2338> consumer) {
        for (int x = xA; x <= xB; ++x) {
            for (int z = zA; z <= zB; ++z) {
                for (int y = yA; y <= yB; ++y) {
                    consumer.accept(center.method_10069(x, y, z));
                }
            }
        }
    }
}

