/*
 * Decompiled with CFR 0.152.
 */
package net.nicguzzo.wands;

import dev.architectury.event.events.common.PlayerEvent;
import dev.architectury.networking.NetworkManager;
import dev.architectury.platform.Platform;
import dev.architectury.registry.CreativeTabRegistry;
import dev.architectury.registry.menu.MenuRegistry;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import dev.architectury.utils.Env;
import java.util.Objects;
import net.minecraft.class_1657;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3917;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.class_8710;
import net.minecraft.class_9279;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import net.nicguzzo.wands.config.WandsConfig;
import net.nicguzzo.wands.items.MagicBagItem;
import net.nicguzzo.wands.items.PaletteItem;
import net.nicguzzo.wands.items.WandItem;
import net.nicguzzo.wands.menues.MagicBagMenu;
import net.nicguzzo.wands.menues.PaletteMenu;
import net.nicguzzo.wands.menues.WandMenu;
import net.nicguzzo.wands.networking.Networking;
import net.nicguzzo.wands.utils.Compat;
import net.nicguzzo.wands.utils.WandUtils;
import net.nicguzzo.wands.wand.PlayerWand;
import net.nicguzzo.wands.wand.Wand;
import net.nicguzzo.wands.wand.WandMode;
import net.nicguzzo.wands.wand.WandProps;
import net.nicguzzo.wands.wand.modes.RockMode;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WandsMod {
    public static int platform = -1;
    public static final WandsConfig config = WandsConfig.get_instance();
    public static final String MOD_ID = "wands";
    public static final Logger LOGGER = LogManager.getLogger();
    public static boolean has_opac = false;
    public static boolean has_ftbchunks = false;
    public static boolean has_flan = false;
    public static boolean has_goml = false;
    static class_2960 stone_wand = Compat.create_resource("stone_wand");
    static class_2960 iron_wand = Compat.create_resource("iron_wand");
    static class_2960 copper_wand = Compat.create_resource("copper_wand");
    static class_2960 diamond_wand = Compat.create_resource("diamond_wand");
    static class_2960 netherite_wand = Compat.create_resource("netherite_wand");
    static class_2960 creative_wand = Compat.create_resource("creative_wand");
    static class_2960 palette = Compat.create_resource("palette");
    static class_2960 magic_bag_1 = Compat.create_resource("magic_bag_1");
    static class_2960 magic_bag_2 = Compat.create_resource("magic_bag_2");
    static class_2960 magic_bag_3 = Compat.create_resource("magic_bag_3");
    static class_5321<class_1792> stone_wand_key = class_5321.method_29179((class_5321)class_7924.field_41197, (class_2960)stone_wand);
    static class_5321<class_1792> copper_wand_key = class_5321.method_29179((class_5321)class_7924.field_41197, (class_2960)copper_wand);
    static class_5321<class_1792> iron_wand_key = class_5321.method_29179((class_5321)class_7924.field_41197, (class_2960)iron_wand);
    static class_5321<class_1792> diamond_wand_key = class_5321.method_29179((class_5321)class_7924.field_41197, (class_2960)diamond_wand);
    static class_5321<class_1792> netherite_wand_key = class_5321.method_29179((class_5321)class_7924.field_41197, (class_2960)netherite_wand);
    static class_5321<class_1792> creative_wand_key = class_5321.method_29179((class_5321)class_7924.field_41197, (class_2960)creative_wand);
    static class_5321<class_1792> palette_key = class_5321.method_29179((class_5321)class_7924.field_41197, (class_2960)palette);
    static class_5321<class_1792> magic_bag_1_key = class_5321.method_29179((class_5321)class_7924.field_41197, (class_2960)magic_bag_1);
    static class_5321<class_1792> magic_bag_2_key = class_5321.method_29179((class_5321)class_7924.field_41197, (class_2960)magic_bag_2);
    static class_5321<class_1792> magic_bag_3_key = class_5321.method_29179((class_5321)class_7924.field_41197, (class_2960)magic_bag_3);
    public static final DeferredRegister<class_1761> TABS = DeferredRegister.create((String)"wands", (class_5321)class_7924.field_44688);
    public static final RegistrySupplier<class_1761> WANDS_TAB = TABS.register("wands_tab", () -> CreativeTabRegistry.create((class_2561)class_2561.method_43471((String)"itemGroup.wands.wands_tab"), () -> new class_1799((class_1935)DIAMOND_WAND_ITEM.get())));
    public static final DeferredRegister<class_1792> ITEMS = DeferredRegister.create((String)"wands", (class_5321)class_7924.field_41197);
    public static final DeferredRegister<class_3917<?>> MENUES = DeferredRegister.create((String)"wands", (class_5321)class_7924.field_41207);
    public static final RegistrySupplier<class_1792> STONE_WAND_ITEM = ITEMS.register(stone_wand, () -> new WandItem(WandItem.WandTier.STONE_WAND, WandsMod.config.stone_wand_limit, false, false, false, false, new class_1792.class_1793().method_7895(WandsMod.config.stone_wand_durability).arch$tab(WANDS_TAB).method_63686(stone_wand_key)));
    public static final RegistrySupplier<class_1792> COPPER_WAND_ITEM = ITEMS.register(copper_wand, () -> new WandItem(WandItem.WandTier.COPPER_WAND, WandsMod.config.copper_wand_limit, false, false, false, false, new class_1792.class_1793().method_7895(WandsMod.config.copper_wand_durability).arch$tab(WANDS_TAB).method_63686(copper_wand_key)));
    public static final RegistrySupplier<class_1792> IRON_WAND_ITEM = ITEMS.register(iron_wand, () -> new WandItem(WandItem.WandTier.IRON_WAND, WandsMod.config.iron_wand_limit, false, false, false, false, new class_1792.class_1793().method_7895(WandsMod.config.iron_wand_durability).arch$tab(WANDS_TAB).method_63686(iron_wand_key)));
    public static final RegistrySupplier<class_1792> DIAMOND_WAND_ITEM = ITEMS.register(diamond_wand, () -> new WandItem(WandItem.WandTier.DIAMOND_WAND, WandsMod.config.diamond_wand_limit, true, false, false, false, new class_1792.class_1793().method_7895(WandsMod.config.diamond_wand_durability).arch$tab(WANDS_TAB).method_63686(diamond_wand_key)));
    public static final RegistrySupplier<class_1792> NETHERITE_WAND_ITEM = ITEMS.register(netherite_wand, () -> new WandItem(WandItem.WandTier.NETHERITE_WAND, WandsMod.config.netherite_wand_limit, true, true, false, true, new class_1792.class_1793().method_24359().method_7895(WandsMod.config.netherite_wand_durability).arch$tab(WANDS_TAB).method_63686(netherite_wand_key)));
    public static final RegistrySupplier<class_1792> CREATIVE_WAND_ITEM = ITEMS.register(creative_wand, () -> new WandItem(WandItem.WandTier.CREATIVE_WAND, WandsMod.config.creative_wand_limit, true, true, true, true, new class_1792.class_1793().method_24359().method_7889(1).arch$tab(WANDS_TAB).method_63686(creative_wand_key)));
    public static final RegistrySupplier<class_1792> PALETTE_ITEM = ITEMS.register("palette", () -> new PaletteItem(new class_1792.class_1793().method_7889(1).arch$tab(WANDS_TAB).method_63686(palette_key)));
    public static final RegistrySupplier<class_1792> MAGIC_BAG_1 = ITEMS.register("magic_bag_1", () -> new MagicBagItem(MagicBagItem.MagicBagItemTier.MAGIC_BAG_TIER_1, WandsMod.config.magic_bag_1_limit, new class_1792.class_1793().method_7889(1).arch$tab(WANDS_TAB).method_63686(magic_bag_1_key)));
    public static final RegistrySupplier<class_1792> MAGIC_BAG_2 = ITEMS.register("magic_bag_2", () -> new MagicBagItem(MagicBagItem.MagicBagItemTier.MAGIC_BAG_TIER_2, WandsMod.config.magic_bag_2_limit, new class_1792.class_1793().method_7889(1).arch$tab(WANDS_TAB).method_63686(magic_bag_2_key)));
    public static final RegistrySupplier<class_1792> MAGIC_BAG_3 = ITEMS.register("magic_bag_3", () -> new MagicBagItem(MagicBagItem.MagicBagItemTier.MAGIC_BAG_TIER_3, Integer.MAX_VALUE, new class_1792.class_1793().method_7889(1).arch$tab(WANDS_TAB).method_63686(magic_bag_3_key)));
    public static final RegistrySupplier<class_3917<PaletteMenu>> PALETTE_CONTAINER = MENUES.register("palette_menu", () -> MenuRegistry.ofExtended(PaletteMenu::new));
    public static final RegistrySupplier<class_3917<WandMenu>> WAND_CONTAINER = MENUES.register("wand_menu", () -> MenuRegistry.ofExtended(WandMenu::new));
    public static final RegistrySupplier<class_3917<MagicBagMenu>> MAGIC_WAND_CONTANIER = MENUES.register("magic_bag_menu", () -> MenuRegistry.ofExtended(MagicBagMenu::new));
    public static boolean is_forge = false;
    public static boolean is_neoforge = false;
    public static boolean is_fabric = false;

    public static void init() {
        ITEMS.register();
        MENUES.register();
        TABS.register();
        if (Platform.getEnvironment() == Env.SERVER) {
            NetworkManager.registerS2CPayloadType(Networking.ConfPacket.TYPE, Networking.ConfPacket.STREAM_CODEC);
            NetworkManager.registerS2CPayloadType(Networking.SndPacket.TYPE, Networking.SndPacket.STREAM_CODEC);
            NetworkManager.registerS2CPayloadType(Networking.ToastPacket.TYPE, Networking.ToastPacket.STREAM_CODEC);
            NetworkManager.registerS2CPayloadType(Networking.StatePacket.TYPE, Networking.StatePacket.STREAM_CODEC);
            NetworkManager.registerS2CPayloadType(Networking.PlayerDataPacket.TYPE, Networking.PlayerDataPacket.STREAM_CODEC);
        }
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, Networking.KbPacket.TYPE, Networking.KbPacket.STREAM_CODEC, (data, context) -> WandsMod.process_keys(context.getPlayer(), data.key(), data.shift(), data.alt()));
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, Networking.PalettePacket.TYPE, Networking.PalettePacket.STREAM_CODEC, (data, context) -> WandsMod.process_palette(context.getPlayer(), data.mode(), data.rotate(), data.grad_h()));
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, Networking.WandPacket.TYPE, Networking.WandPacket.STREAM_CODEC, (data, context) -> {
            class_1799 wand_stack = context.getPlayer().method_6047();
            class_9279 custom_data = (class_9279)data.item_stack().method_58694(class_9334.field_49628);
            if (custom_data != null) {
                class_2487 tag = custom_data.method_57461();
                class_9279.method_57453((class_9331)class_9334.field_49628, (class_1799)wand_stack, (class_2487)tag);
            }
        });
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, Networking.SyncRockPacket.TYPE, Networking.SyncRockPacket.STREAM_CODEC, (data, context) -> {
            WandMode m;
            class_1657 player = context.getPlayer();
            if (player == null) {
                LOGGER.error("player is null");
                return;
            }
            class_1799 stack = context.getPlayer().method_6047();
            if (!WandUtils.is_wand(stack)) {
                LOGGER.error("player doesn't have a wand in main hand");
                return;
            }
            Wand wand = PlayerWand.get(player);
            if (wand == null) {
                LOGGER.error("wand is null");
                return;
            }
            if (wand.mode == WandProps.Mode.ROCK && (m = wand.get_mode()) instanceof RockMode) {
                ((RockMode)m).set_random_pos(data.rx(), data.ry(), data.rz());
            }
        });
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, Networking.PosPacket.TYPE, Networking.PosPacket.STREAM_CODEC, (data, context) -> {
            class_2338 pos;
            class_2680 block_state;
            class_1657 player = context.getPlayer();
            if (player == null) {
                LOGGER.error("player is null");
                return;
            }
            class_1937 level = Compat.player_level(player);
            class_1799 stack = context.getPlayer().method_6047();
            if (!WandUtils.is_wand(stack)) {
                LOGGER.error("player doesn't have a wand in main hand");
                return;
            }
            Wand wand = PlayerWand.get(player);
            if (wand == null) {
                LOGGER.error("wand is null");
                return;
            }
            int d = data.dir();
            int has_p1_p2 = data.has_p1_p2();
            class_2350 side = class_2350.values()[d];
            class_2338 p1 = has_p1_p2 == 1 ? data.p1() : null;
            class_2338 p2 = has_p1_p2 == 2 ? data.p2() : null;
            if (has_p1_p2 == 3) {
                p1 = data.p1();
                p2 = data.p2();
            }
            if (p1 == null) {
                return;
            }
            if (p2 != null) {
                block_state = level.method_8320(p2);
                pos = p2;
            } else {
                block_state = level.method_8320(p1);
                pos = p1;
            }
            if (block_state.method_26215()) {
                block_state = level.method_8320(p1);
            }
            wand.setP1(p1);
            wand.setP2(p2);
            class_243 hit = new class_243(data.hit().x, data.hit().y, data.hit().z);
            wand.palette.seed = data.seed();
            wand.do_or_preview(player, level, block_state, pos, side, hit, stack, (WandItem)stack.method_7909(), true);
            wand.clear();
        });
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, Networking.GlobalSettingsPacket.TYPE, Networking.GlobalSettingsPacket.STREAM_CODEC, (packet, context) -> {
            Wand wand;
            class_1657 player = context.getPlayer();
            if (player != null && (wand = PlayerWand.get(player)) != null) {
                wand.drop_on_player = packet.drop_pos();
            }
        });
        PlayerEvent.PLAYER_JOIN.register(player -> {
            Wand wand = null;
            wand = PlayerWand.get((class_1657)player);
            if (wand == null) {
                PlayerWand.add_player((class_1657)player);
                wand = PlayerWand.get((class_1657)player);
            }
            if (!Compat.player_level((class_1657)player).method_8608()) {
                if (config != null) {
                    NetworkManager.sendToPlayer((class_3222)player, (class_8710)new Networking.ConfPacket(WandsMod.config.blocks_per_xp, WandsMod.config.destroy_in_survival_drop, WandsMod.config.survival_unenchanted_drops, WandsMod.config.allow_wand_to_break, WandsMod.config.allow_offhand_to_break, WandsMod.config.mend_tools));
                }
                NetworkManager.sendToPlayer((class_3222)player, (class_8710)new Networking.PlayerDataPacket(wand.player_data));
            }
        });
        PlayerEvent.PLAYER_QUIT.register(player -> PlayerWand.remove_player((class_1657)player));
    }

    public static void send_state(class_3222 player, Wand wand) {
        class_1799 wand_stack;
        if (wand != null && player != null && !Compat.player_level((class_1657)player).method_8608() && (wand_stack = player.method_6047()).method_7909() instanceof WandItem) {
            WandProps.Mode mode = WandProps.getMode(wand_stack);
            int slot = 0;
            if (wand.palette.palette_slots.size() != 0) {
                slot = (wand.palette.slot + 1) % wand.palette.palette_slots.size();
            }
            float BLOCKS_PER_XP = WandsMod.config.blocks_per_xp;
            NetworkManager.sendToPlayer((class_3222)player, (class_8710)new Networking.StatePacket(mode.ordinal(), slot, BLOCKS_PER_XP != 0.0f, player.field_7520, player.field_7510));
        }
    }

    public static void process_palette(class_1657 player, boolean mode, boolean rotate, int grad_h) {
        class_1799 item_stack = player.method_6047();
        class_1799 palette = null;
        if (!item_stack.method_7960() && item_stack.method_7909() instanceof PaletteItem) {
            palette = item_stack;
        } else {
            class_1799 offhand_stack = player.method_6079();
            if (!offhand_stack.method_7960() && offhand_stack.method_7909() instanceof PaletteItem) {
                palette = offhand_stack;
            }
        }
        if (palette != null) {
            if (mode) {
                PaletteItem.nextMode(palette);
            }
            if (rotate) {
                PaletteItem.toggleRotate(palette);
            }
            if (grad_h > 0) {
                PaletteItem.setGradientHeight(palette, grad_h);
            }
        }
    }

    public static void process_keys(class_1657 player, int key, boolean shift, boolean alt) {
        Wand wand;
        class_1799 main_stack = player.method_6047();
        class_1799 offhand_stack = player.method_6079();
        boolean is_wand = main_stack.method_7909() instanceof WandItem;
        boolean is_palette = main_stack.method_7909() instanceof PaletteItem || offhand_stack.method_7909() instanceof PaletteItem;
        boolean creative = Compat.is_creative(player);
        if (is_palette && key >= 0 && key < WandKeys.values().length) {
            switch (WandKeys.values()[key].ordinal()) {
                case 17: {
                    if (offhand_stack.method_7909() instanceof PaletteItem) {
                        Compat.open_menu((class_3222)player, offhand_stack, 1);
                        break;
                    }
                    class_1799 mainhand_stack = player.method_6047();
                    if (!(mainhand_stack.method_7909() instanceof PaletteItem)) break;
                    Compat.open_menu((class_3222)player, mainhand_stack, 1);
                    break;
                }
                case 16: {
                    if (offhand_stack.method_7960() || !(offhand_stack.method_7909() instanceof PaletteItem)) break;
                    PaletteItem.nextMode(offhand_stack);
                    player.method_7353((class_2561)Compat.literal("Palette mode: " + String.valueOf((Object)PaletteItem.getMode(offhand_stack))), false);
                }
            }
        }
        if (is_wand) {
            int inc;
            wand = PlayerWand.get(player);
            WandItem wand_item = (WandItem)main_stack.method_7909();
            if (wand == null) {
                return;
            }
            WandProps.Mode mode = WandProps.getMode(main_stack);
            int n = inc = shift ? 10 : 1;
            if (key >= 0 && key < WandKeys.values().length) {
                block4 : switch (WandKeys.values()[key].ordinal()) {
                    case 15: {
                        WandProps.toggleFlag(main_stack, WandProps.Flag.INCSELBLOCK);
                        break;
                    }
                    case 14: {
                        WandProps.toggleFlag(main_stack, WandProps.Flag.DIAGSPREAD);
                        break;
                    }
                    case 13: {
                        WandProps.setStateMode(main_stack, WandProps.StateMode.APPLY);
                        WandProps.toggleFlag(main_stack, WandProps.Flag.STAIRSLAB);
                        break;
                    }
                    case 11: {
                        if (mode != WandProps.Mode.GRID) break;
                        WandProps.incGrid(main_stack, WandProps.Value.GRIDN, inc, wand_item.limit);
                        break;
                    }
                    case 12: {
                        if (mode != WandProps.Mode.GRID) break;
                        WandProps.decVal(main_stack, WandProps.Value.GRIDN, inc);
                        break;
                    }
                    case 9: {
                        switch (mode) {
                            case DIRECTION: {
                                WandProps.incVal(main_stack, WandProps.Value.MULTIPLIER, inc);
                                break;
                            }
                            case ROW_COL: {
                                WandProps.incVal(main_stack, WandProps.Value.ROWCOLLIM, inc);
                                break;
                            }
                            case GRID: {
                                WandProps.incGrid(main_stack, WandProps.Value.GRIDM, inc, wand_item.limit);
                                break;
                            }
                            case AREA: {
                                WandProps.incVal(main_stack, WandProps.Value.AREALIM, inc);
                            }
                        }
                        break;
                    }
                    case 10: {
                        switch (mode) {
                            case DIRECTION: {
                                WandProps.decVal(main_stack, WandProps.Value.MULTIPLIER, inc);
                                break;
                            }
                            case ROW_COL: {
                                WandProps.decVal(main_stack, WandProps.Value.ROWCOLLIM, inc);
                                break;
                            }
                            case GRID: {
                                WandProps.decVal(main_stack, WandProps.Value.GRIDM, inc);
                                break;
                            }
                            case AREA: {
                                WandProps.decVal(main_stack, WandProps.Value.AREALIM, inc);
                            }
                        }
                        break;
                    }
                    case 2: {
                        if (shift) {
                            WandProps.prevAction(main_stack);
                        } else {
                            WandProps.nextAction(main_stack);
                        }
                        player.method_7353((class_2561)Compat.literal("Wand Action: ").method_10852((class_2561)Compat.translatable(WandProps.getAction(main_stack).toString())), false);
                        break;
                    }
                    case 0: {
                        Compat.open_menu((class_3222)player, main_stack, 0);
                        break;
                    }
                    case 1: {
                        if (shift) {
                            WandProps.prevMode(main_stack, wand_item.can_blast);
                            break;
                        }
                        WandProps.nextMode(main_stack, wand_item.can_blast);
                        break;
                    }
                    case 3: {
                        switch (mode) {
                            case CIRCLE: 
                            case FILL: {
                                WandProps.nextPlane(main_stack);
                                player.method_7353((class_2561)Compat.literal("Wand Plane: " + String.valueOf((Object)WandProps.getPlane(main_stack))), false);
                                WandsMod.send_state((class_3222)player, wand);
                                break block4;
                            }
                            case DIRECTION: 
                            case PASTE: {
                                break block4;
                            }
                        }
                        WandProps.nextOrientation(main_stack);
                        player.method_7353((class_2561)Compat.literal("Wand Orientation: ").method_10852((class_2561)Compat.translatable(WandProps.getOrientation(main_stack).toString())), false);
                        break;
                    }
                    case 5: {
                        WandProps.toggleFlag(main_stack, WandProps.Flag.INVERTED);
                        player.method_7353((class_2561)Compat.literal("Wand inverted: " + WandProps.getFlag(main_stack, WandProps.Flag.INVERTED)), false);
                        break;
                    }
                    case 6: {
                        switch (wand.mode) {
                            case FILL: {
                                WandProps.toggleFlag(main_stack, WandProps.Flag.RFILLED);
                                player.method_7353((class_2561)Compat.literal("Wand fill rect: " + WandProps.getFlag(main_stack, WandProps.Flag.RFILLED)), false);
                                break;
                            }
                            case CIRCLE: {
                                WandProps.toggleFlag(main_stack, WandProps.Flag.CFILLED);
                                player.method_7353((class_2561)Compat.literal("Wand circle fill: " + WandProps.getFlag(main_stack, WandProps.Flag.CFILLED)), false);
                            }
                        }
                        break;
                    }
                    case 7: {
                        if (mode == WandProps.Mode.ROCK) break;
                        WandProps.nextRotation(main_stack);
                        WandProps.setStateMode(main_stack, WandProps.StateMode.APPLY);
                        break;
                    }
                    case 4: {
                        if (!creative || Compat.player_level(player).method_8608() || wand == null) break;
                        int n2 = 1;
                        if (alt) {
                            n2 = 10;
                        }
                        if (shift) {
                            wand.redo(n2);
                            break;
                        }
                        wand.undo(n2);
                        break;
                    }
                    case 18: {
                        wand.clear();
                        if (player == null) break;
                        player.method_7353((class_2561)Compat.literal("wand cleared"), false);
                    }
                }
            }
        }
        if (!main_stack.method_7960() && main_stack.method_7909() instanceof PaletteItem && key >= 0 && key < WandKeys.values().length && Objects.requireNonNull(WandKeys.values()[key]) == WandKeys.PALETTE_MODE) {
            PaletteItem.nextMode(main_stack);
            player.method_7353((class_2561)Compat.literal("Palette mode: " + String.valueOf((Object)PaletteItem.getMode(main_stack))), false);
        }
        if (is_wand && key < 0) {
            wand = null;
            if (!Compat.player_level(player).method_8608() && (wand = PlayerWand.get(player)) == null) {
                PlayerWand.add_player(player);
                wand = PlayerWand.get(player);
            }
            if (wand != null) {
                wand.is_alt_pressed = alt;
                wand.is_shift_pressed = shift;
            }
        }
    }

    public static void log(String s, boolean b) {
        if (b) {
            LOGGER.info(s);
        }
    }

    public static enum WandKeys {
        MENU,
        MODE,
        ACTION,
        ORIENTATION,
        UNDO,
        INVERT,
        FILL,
        ROTATE,
        CONF,
        M_INC,
        M_DEC,
        N_INC,
        N_DEC,
        TOGGLE_STAIRSLAB,
        DIAGONAL_SPREAD,
        INC_SEL_BLK,
        PALETTE_MODE,
        PALETTE_MENU,
        CLEAR;

    }
}

