/*
 * Decompiled with CFR 0.152.
 */
package net.nicguzzo.wands.utils;

import java.util.Optional;
import net.minecraft.class_10735;
import net.minecraft.class_11352;
import net.minecraft.class_11362;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2480;
import net.minecraft.class_2487;
import net.minecraft.class_2541;
import net.minecraft.class_2680;
import net.minecraft.class_3481;
import net.minecraft.class_7225;
import net.minecraft.class_8942;
import net.minecraft.class_9288;
import net.minecraft.class_9334;
import net.nicguzzo.wands.items.MagicBagItem;
import net.nicguzzo.wands.items.WandItem;
import net.nicguzzo.wands.mixin.AxeItemAccessor;
import net.nicguzzo.wands.mixin.HoeItemAccessor;
import net.nicguzzo.wands.mixin.ShovelItemAccessor;

public class WandUtils {
    public static boolean is_tillable(class_2680 state) {
        return HoeItemAccessor.getTillables().get(state.method_26204()) != null;
    }

    public static boolean is_strippable(class_2680 state) {
        return AxeItemAccessor.getStrippables().get(state.method_26204()) != null;
    }

    public static boolean is_flattenable(class_2680 state) {
        return ShovelItemAccessor.getFlattenables().get(state.method_26204()) != null;
    }

    public static boolean is_wand(class_1799 stack) {
        return stack != null && !stack.method_7960() && stack.method_7909() instanceof WandItem;
    }

    public static boolean is_shulker(class_1799 item_stack) {
        return class_2248.method_9503((class_1792)item_stack.method_7909()) instanceof class_2480;
    }

    public static boolean is_magicbag(class_1799 item_stack) {
        return item_stack.method_7909() instanceof MagicBagItem;
    }

    public static int count_in_shulker(class_1799 shulker, class_1792 item, class_7225.class_7874 provider) {
        class_9288 contents;
        int n = 0;
        if (item != null && (contents = (class_9288)shulker.method_58694(class_9334.field_49622)) != null) {
            Iterable shulker_items = contents.method_59714();
            for (class_1799 s : shulker_items) {
                if (WandUtils.is_magicbag(s)) {
                    int total = MagicBagItem.getTotal(s);
                    class_1799 stack2 = MagicBagItem.getItem(s, provider);
                    if (stack2.method_7960() || !stack2.method_31574(item) || total <= 0) continue;
                    n += total;
                    continue;
                }
                if (s.method_7960() || !s.method_31574(item)) continue;
                n += s.method_7947();
            }
        }
        return n;
    }

    public static boolean is_plant(class_2680 state) {
        return state.method_26204() instanceof class_10735 || state.method_26204() instanceof class_2541;
    }

    public static double unitCoord(double a) {
        double b = a - (double)((int)a);
        if (b < 0.0) {
            b = 1.0 + b;
        }
        return b;
    }

    public static float calc_xp(int level, float prog) {
        float xp = WandUtils.calc_xp_level(level);
        if (prog > 0.0f) {
            xp += prog * (WandUtils.calc_xp_level(level + 1) - xp);
        }
        return xp;
    }

    public static float calc_xp_level(int level) {
        int level2 = level * level;
        float xp_points = level >= 32 ? 4.5f * (float)level2 - 162.5f * (float)level + 2220.0f : (level >= 17 ? 2.5f * (float)level2 - 40.5f * (float)level + 360.0f : (float)(level2 + 6 * level));
        return xp_points;
    }

    public static int calc_xp_to_next_level(int level) {
        int xp = level >= 32 ? 9 * level - 158 : (level >= 17 ? 5 * level - 38 : 2 * level + 7);
        return xp;
    }

    public static boolean pickaxe_minable(class_2680 state) {
        return state.method_26164(class_3481.field_33715);
    }

    public static double mapRange(double a1, double a2, double b1, double b2, double s) {
        return b1 + (s - a1) * (b2 - b1) / (a2 - a1);
    }

    public static int mapRange(int a1, int a2, int b1, int b2, int s) {
        int den = a2 - a1;
        if (den == 0) {
            return b1;
        }
        return b1 + (s - a1) * (b2 - b1) / den;
    }

    public static class_2487 ItemStack_save(class_1799 item, class_7225.class_7874 provider) {
        class_8942.class_8943 reporter = new class_8942.class_8943();
        class_11362 tvo = class_11362.method_71459((class_8942)reporter, (class_7225.class_7874)provider);
        tvo.method_71460(class_1799.field_55709, (Object)item);
        return tvo.method_71475();
    }

    public static Optional<class_1799> ItemStack_read(class_2487 item, class_7225.class_7874 provider) {
        class_8942.class_8943 reporter = new class_8942.class_8943();
        class_11352 tvi = (class_11352)class_11352.method_71417((class_8942)reporter, (class_7225.class_7874)provider, (class_2487)item);
        return tvi.method_71418(class_1799.field_55709);
    }
}

