/*
 * Decompiled with CFR 0.152.
 */
package net.nicguzzo.wands.wand;

import dev.architectury.platform.Platform;
import dev.architectury.utils.Env;
import java.util.Map;
import java.util.Optional;
import java.util.Vector;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2488;
import net.minecraft.class_2499;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_5455;
import net.minecraft.class_5819;
import net.minecraft.class_7225;
import net.nicguzzo.wands.items.PaletteItem;
import net.nicguzzo.wands.utils.Compat;
import net.nicguzzo.wands.utils.WandUtils;
import net.nicguzzo.wands.wand.BlockAccounting;
import net.nicguzzo.wands.wand.Wand;
import net.nicguzzo.wands.wand.WandProps;

public class Palette {
    public static long version = 0L;
    public static long last_version = -1L;
    public class_1799 item = null;
    public boolean has_palette = false;
    public int slot = 0;
    public class_5819 random = class_5819.method_43047();
    public volatile long seed = System.currentTimeMillis();
    public Vector<PaletteSlot> palette_slots = new Vector();
    public Vector<Vector<PaletteSlot>> palette_grid = new Vector();

    public Palette() {
        for (int i = 0; i < 6; ++i) {
            this.palette_grid.add(new Vector());
        }
    }

    void update_palette(Map<class_1792, BlockAccounting> block_accounting, class_1937 level) {
        if (Platform.getEnvironment() == Env.CLIENT) {
            if (version == last_version) {
                return;
            }
            version = last_version;
        }
        this.slot = 0;
        if (this.item != null && this.item.method_7909() instanceof PaletteItem) {
            PaletteItem.PaletteMode palette_mode = PaletteItem.getMode(this.item);
            this.palette_slots.clear();
            for (int i = 0; i < 6; ++i) {
                this.palette_grid.get(i).clear();
            }
            class_2487 tag = Compat.getTags(this.item);
            Optional o_palette_inv = tag.method_10554("Palette");
            if (o_palette_inv.isEmpty()) {
                return;
            }
            class_2499 palette_inv = (class_2499)o_palette_inv.get();
            int s = palette_inv.size();
            block4: for (int i = 0; i < s; ++i) {
                class_2248 blk;
                class_2487 stackTag = (class_2487)palette_inv.method_10534(i);
                class_1799 stack = class_1799.field_8037;
                if (level != null && stackTag.method_10562("Block").isPresent()) {
                    class_5455 provider = level.method_30349();
                    stack = WandUtils.ItemStack_read((class_2487)stackTag.method_10562("Block").get(), (class_7225.class_7874)provider).orElse(class_1799.field_8037);
                }
                int inv_slot = stackTag.method_10550("Slot").orElse(0);
                if (stack.method_7960() || (blk = class_2248.method_9503((class_1792)stack.method_7909())) == class_2246.field_10124) continue;
                PaletteSlot psl = new PaletteSlot(i, blk.method_9564(), stack);
                if (block_accounting.get(stack.method_7909()) == null) {
                    block_accounting.put(stack.method_7909(), new BlockAccounting());
                }
                this.palette_slots.add(psl);
                switch (palette_mode) {
                    case GRADIENT: {
                        int j = inv_slot / 9;
                        if (j >= this.palette_grid.size()) continue block4;
                        this.palette_grid.get(j).add(psl);
                    }
                }
            }
        }
    }

    public class_2680 get_state(Wand wand, int min, int max, int y) {
        class_2680 st = wand.block_state;
        if (!wand.preview) {
            // empty if block
        }
        PaletteItem.PaletteMode palette_mode = PaletteItem.getMode(this.item);
        int gradient_height = PaletteItem.getGradientHeight(this.item);
        switch (palette_mode) {
            case ROUND_ROBIN: {
                if (this.palette_slots.isEmpty()) break;
                int bound = this.palette_slots.size();
                PaletteSlot ps = this.palette_slots.get(this.slot);
                st = ps.state;
                if (wand.mode == WandProps.Mode.DIRECTION && wand.level.method_8608()) break;
                this.slot = (this.slot + 1) % bound;
                break;
            }
            case RANDOM: {
                if (this.palette_slots.isEmpty()) break;
                int bound = this.palette_slots.size();
                this.slot = this.random.method_43048(bound);
                PaletteSlot ps = this.palette_slots.get(this.slot);
                st = ps.state;
                class_2248 blk = st.method_26204();
                if (!(blk instanceof class_2488)) break;
                int sn = this.random.method_43048(7);
                st = (class_2680)st.method_11657((class_2769)class_2488.field_11518, (Comparable)Integer.valueOf(sn + 1));
                break;
            }
            case GRADIENT: {
                Vector<PaletteSlot> row;
                int bound;
                if (this.palette_grid.isEmpty()) break;
                int bottom_y = wand.pos.method_10264();
                int mapped_y = WandUtils.mapRange(bottom_y, bottom_y + gradient_height - 1, 5, 0, y);
                if (mapped_y < 0) {
                    mapped_y = 0;
                }
                if (mapped_y > 5) {
                    mapped_y = 5;
                }
                if (mapped_y >= this.palette_grid.size() || (bound = (row = this.palette_grid.get(mapped_y)).size()) <= 0) break;
                this.slot = this.random.method_43048(bound);
                PaletteSlot ps = row.get(this.slot);
                st = ps.state;
            }
        }
        st = wand.state_for_placement(st, null);
        if (PaletteItem.getRotate(this.item)) {
            st = st.method_26204().method_9564().method_26186(class_2470.method_16548((class_5819)this.random));
        }
        return st;
    }

    public boolean state_in_slot(class_2680 bs) {
        boolean cond = false;
        if (this.has_palette) {
            for (PaletteSlot slot : this.palette_slots) {
                if (!bs.equals((Object)slot.state)) continue;
                cond = true;
                break;
            }
        }
        return cond;
    }

    public static class PaletteSlot {
        public class_1799 stack;
        public class_2680 state;
        public int slot;

        PaletteSlot(int s, class_2680 b, class_1799 stk) {
            this.slot = s;
            this.state = b;
            this.stack = stk;
        }
    }
}

