/*
 * Decompiled with CFR 0.152.
 */
package net.nicguzzo.wands.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModelPart;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.nicguzzo.wands.WandsMod;
import net.nicguzzo.wands.config.WandsConfig;
import net.nicguzzo.wands.items.WandItem;
import net.nicguzzo.wands.utils.Colorf;
import net.nicguzzo.wands.utils.Compat;
import net.nicguzzo.wands.wand.CopyBuffer;
import net.nicguzzo.wands.wand.Wand;
import net.nicguzzo.wands.wand.WandMode;
import net.nicguzzo.wands.wand.WandProps;
import org.joml.Matrix4f;

public class ClientRender {
    public static final float p_o = -0.005f;
    private static long t0 = 0L;
    private static long t1 = 0L;
    private static long t00 = 0L;
    private static boolean prnt;
    public static BlockPos last_pos;
    static Direction last_side;
    static WandProps.Mode last_mode;
    static Rotation last_rot;
    static boolean last_alt;
    static boolean targeting_air;
    static int last_buffer_size;
    static WandProps.Orientation last_orientation;
    public static Wand wand;
    static VoxelShape preview_shape;
    static Colorf white;
    static AABB def_aabb;
    private static final int grid_n = 16;
    private static int grid_i;
    private static final float[] grid_vx;
    private static final float[] grid_vy;
    private static final float[] grid_vz;
    static boolean force;
    static float x1;
    static float y1;
    static float z1;
    static float x2;
    static float y2;
    static float z2;
    static float opacity;
    static boolean fancy;
    static boolean fat_lines;
    static boolean drawlines;
    static boolean block_outlines;
    static boolean fill_outlines;
    static boolean copy_outlines;
    static boolean paste_outlines;
    static float fat_lines_width;
    static Minecraft client;
    private static final ResourceLocation GRID_TEXTURE;
    private static final ResourceLocation LINE_TEXTURE;
    private static GpuTextureView water_texture;
    private static GpuTextureView lava_texture;
    public static RandomSource random;
    static Direction[] dirs;
    static Vec3 player_normal;
    public static boolean update_colors;
    static Colorf block_col;
    static Colorf bo_col;
    static Colorf bbox_col;
    static Colorf destroy_col;
    static Colorf tool_use_col;
    static Colorf start_col;
    static Colorf end_col;
    static Colorf line_col;
    static Colorf paste_bb_col;
    public static boolean has_target;
    static BlockPos.MutableBlockPos bp;
    static boolean water;
    static int mirroraxis;

    public static void render(PoseStack matrixStack, MultiBufferSource.BufferSource bufferSource) {
        if (wand == null) {
            return;
        }
        client = Minecraft.getInstance();
        if (ClientRender.client.level == null) {
            return;
        }
        LocalPlayer player = ClientRender.client.player;
        if (player == null) {
            return;
        }
        if ((ClientRender.wand.destroy || ClientRender.wand.replace) && WandsMod.config.disable_destroy_replace) {
            return;
        }
        if (ClientRender.client.options.getCameraType() != CameraType.FIRST_PERSON) {
            return;
        }
        if (update_colors) {
            update_colors = false;
            WandsConfig.get_instance().parse_colors();
            ClientRender.update_colors();
        }
        drawlines = WandsMod.config.lines;
        block_outlines = WandsMod.config.block_outlines;
        fill_outlines = WandsMod.config.fill_outlines;
        copy_outlines = WandsMod.config.copy_outlines;
        paste_outlines = WandsMod.config.paste_outlines;
        opacity = WandsMod.config.preview_opacity;
        fancy = WandsConfig.get_instance().fancy_preview;
        fat_lines = WandsConfig.get_instance().fat_lines;
        if (WandsConfig.get_instance().fat_lines_width > 0.0f && (double)WandsConfig.get_instance().fat_lines_width < 0.5) {
            fat_lines_width = WandsConfig.get_instance().fat_lines_width;
        }
        ItemStack stack = player.getMainHandItem();
        prnt = false;
        force = false;
        if (!stack.isEmpty() && stack.getItem() instanceof WandItem) {
            t1 = System.currentTimeMillis();
            if (t1 - t0 > 1000L) {
                t0 = System.currentTimeMillis();
                prnt = true;
            }
            if (t1 - t00 > 100L) {
                t00 = System.currentTimeMillis();
                force = true;
            }
            HitResult hitResult = ClientRender.client.hitResult;
            ClientRender.wand.target_air = WandProps.getFlag(stack, WandProps.Flag.TARGET_AIR);
            ClientRender.wand.lastHitResult = hitResult;
            ClientRender.wand.lastPlayerDirection = player.getDirection();
            WandProps.Mode mode = WandProps.getMode(stack);
            mirroraxis = WandProps.getVal(player.getMainHandItem(), WandProps.Value.MIRRORAXIS);
            if (hitResult != null && hitResult.getType() == HitResult.Type.BLOCK && !ClientRender.wand.is_alt_pressed) {
                WandMode wmode;
                has_target = true;
                targeting_air = false;
                Vec3 eye = player.getEyePosition();
                player_normal = eye.subtract(hitResult.getLocation());
                if (wand != null && (wmode = wand.get_mode()) != null) {
                    wmode.redraw(wand);
                }
                BlockHitResult block_hit = (BlockHitResult)hitResult;
                Rotation rot = WandProps.getRotation(stack);
                WandProps.Orientation orientation = WandProps.getOrientation(stack);
                Direction side = block_hit.getDirection();
                BlockPos pos = block_hit.getBlockPos();
                BlockState block_state = ClientRender.client.level.getBlockState(pos);
                if (force) {
                    ClientRender.wand.force_render = false;
                    if ((mode == WandProps.Mode.FILL || mode == WandProps.Mode.LINE || mode == WandProps.Mode.CIRCLE || mode == WandProps.Mode.SPHERE || mode == WandProps.Mode.COPY || mode == WandProps.Mode.PASTE) && WandProps.getFlag(stack, WandProps.Flag.INCSELBLOCK)) {
                        pos = pos.relative(side, 1);
                    }
                    last_pos = pos;
                    last_side = side;
                    last_mode = mode;
                    last_orientation = orientation;
                    last_rot = rot;
                    last_alt = ClientRender.wand.is_alt_pressed;
                    last_buffer_size = ClientRender.wand.block_buffer.get_length();
                    wand.do_or_preview((Player)player, Compat.player_level((Player)player), block_state, pos, side, block_hit.getLocation(), stack, (WandItem)stack.getItem(), prnt);
                }
                preview_shape = null;
                if (last_pos != null) {
                    preview_shape = block_state.getShape((BlockGetter)ClientRender.client.level, last_pos);
                }
                ClientRender.preview_mode(ClientRender.wand.mode, matrixStack, bufferSource);
            } else {
                WandMode wmode = wand.get_mode();
                if (wmode != null) {
                    wmode.redraw(wand);
                }
                has_target = false;
                if (ClientRender.wand.is_alt_pressed && (!ClientRender.wand.copy_paste_buffer.isEmpty() || ClientRender.wand.block_buffer.get_length() > 0)) {
                    if (ClientRender.wand.mode != WandProps.Mode.LINE && ClientRender.wand.mode != WandProps.Mode.CIRCLE && mode != WandProps.Mode.SPHERE) {
                        wand.setP1(last_pos);
                    }
                    ClientRender.preview_mode(ClientRender.wand.mode, matrixStack, bufferSource);
                } else if (ClientRender.wand.target_air && mode.can_target_air()) {
                    boolean palette;
                    targeting_air = true;
                    if (hitResult == null) {
                        return;
                    }
                    Vec3 hit = hitResult.getLocation();
                    BlockPos pos = wand.get_pos_from_air(hit);
                    ItemStack offhand = player.getOffhandItem();
                    BlockState block_state = null;
                    Block offhand_block = Block.byItem((Item)offhand.getItem());
                    if (offhand_block != Blocks.AIR) {
                        block_state = offhand_block.defaultBlockState();
                    }
                    boolean bl = palette = ClientRender.wand.palette.has_palette && !ClientRender.wand.palette.palette_slots.isEmpty();
                    if (block_state != null || palette || mode == WandProps.Mode.PASTE) {
                        if (palette) {
                            block_state = Blocks.STONE.defaultBlockState();
                        }
                        if (mode == WandProps.Mode.TUNNEL || mode == WandProps.Mode.ROW_COL || mode == WandProps.Mode.ROCK || mode == WandProps.Mode.GRID || mode == WandProps.Mode.PASTE) {
                            wand.setP1(pos);
                        }
                        if (wand.getP1() != null) {
                            last_pos = wand.getP1();
                            has_target = true;
                        } else {
                            last_pos = pos;
                        }
                        Direction side = player.getDirection().getOpposite();
                        wand.do_or_preview((Player)player, Compat.player_level((Player)player), block_state, pos, side, hit, stack, (WandItem)stack.getItem(), prnt);
                        ClientRender.preview_mode(ClientRender.wand.mode, matrixStack, bufferSource);
                    }
                } else if (mode != WandProps.Mode.ROCK) {
                    ClientRender.wand.block_buffer.reset();
                }
                if (water) {
                    water = false;
                }
            }
        }
    }

    private static void preview_mode(WandProps.Mode mode, PoseStack matrixStack, MultiBufferSource.BufferSource bufferSource) {
        Camera camera = ClientRender.client.gameRenderer.getMainCamera();
        Vec3 _c = camera.getPosition();
        matrixStack.pushPose();
        matrixStack.translate(-((float)_c.x), -((float)_c.y), -((float)_c.z));
        float p1_x = 0.0f;
        float p1_y = 0.0f;
        float p1_z = 0.0f;
        BlockPos p1 = wand.getP1();
        if (p1 != null) {
            p1_x = p1.getX();
            p1_y = p1.getY();
            p1_z = p1.getZ();
        }
        if (camera.isInitialized() && last_pos != null) {
            float last_pos_x = last_pos.getX();
            float last_pos_y = last_pos.getY();
            float last_pos_z = last_pos.getZ();
            float off2 = 0.05f;
            float off3 = off2 / 2.0f;
            switch (mode) {
                case DIRECTION: {
                    ClientRender.preview_direction_mode(bufferSource, matrixStack.last().pose(), last_pos_x, last_pos_y, last_pos_z);
                }
                case ROW_COL: 
                case FILL: 
                case AREA: 
                case GRID: 
                case LINE: 
                case CIRCLE: 
                case SPHERE: 
                case VEIN: 
                case TUNNEL: 
                case ROCK: 
                case COPY: 
                case PASTE: {
                    ClientRender.preview_selected(mode, bufferSource, matrixStack, last_pos_x, last_pos_y, last_pos_z, off3);
                    if (!ClientRender.wand.valid && (mode != WandProps.Mode.ROCK && mode != WandProps.Mode.FILL && mode != WandProps.Mode.COPY && mode != WandProps.Mode.TUNNEL || wand.getP1() == null)) break;
                    if (drawlines && fill_outlines && (mode == WandProps.Mode.ROW_COL || mode == WandProps.Mode.FILL || mode == WandProps.Mode.COPY || mode == WandProps.Mode.TUNNEL)) {
                        ClientRender.preview_bbox(bufferSource, matrixStack);
                    }
                    ClientRender.preview_block_buffer(bufferSource, matrixStack);
                    if (!drawlines || p1 == null || mode != WandProps.Mode.FILL && mode != WandProps.Mode.LINE && mode != WandProps.Mode.CIRCLE && mode != WandProps.Mode.SPHERE) break;
                    ClientRender.preview_line_circle(matrixStack.last().pose(), mode, bufferSource, p1_x, p1_y, p1_z, last_pos_x, last_pos_y, last_pos_z, off3, off2);
                }
            }
            if (mode == WandProps.Mode.PASTE && !ClientRender.wand.copy_paste_buffer.isEmpty()) {
                ClientRender.preview_paste(bufferSource, matrixStack);
            }
        }
        matrixStack.popPose();
    }

    public static void render_mode_outline(Matrix4f matrix, MultiBufferSource.BufferSource bufferSource) {
        Colorf mode_outline_color = bo_col;
        if (ClientRender.wand.destroy || ClientRender.wand.has_empty_bucket) {
            mode_outline_color = destroy_col;
        }
        if (ClientRender.wand.use && (ClientRender.wand.has_hoe || ClientRender.wand.has_axe || ClientRender.wand.has_shovel)) {
            mode_outline_color = tool_use_col;
        }
        if (drawlines && block_outlines) {
            VertexConsumer consumer = fat_lines ? bufferSource.getBuffer(RenderType.debugQuads()) : bufferSource.getBuffer(RenderType.lines());
            for (int idx = 0; idx < ClientRender.wand.block_buffer.get_length() && idx < WandsConfig.max_limit; ++idx) {
                float x = ClientRender.wand.block_buffer.buffer_x[idx];
                float y = ClientRender.wand.block_buffer.buffer_y[idx];
                float z = ClientRender.wand.block_buffer.buffer_z[idx];
                if (ClientRender.wand.block_buffer.state[idx] == null) continue;
                preview_shape = ClientRender.wand.block_buffer.state[idx].getShape((BlockGetter)ClientRender.client.level, last_pos);
                List list = preview_shape.toAabbs();
                for (AABB aabb : list) {
                    if (fat_lines) {
                        ClientRender.preview_block_fat(matrix, consumer, x + (float)aabb.minX, y + (float)aabb.minY, z + (float)aabb.minZ, x + (float)aabb.maxX, y + (float)aabb.maxY, z + (float)aabb.maxZ, mode_outline_color, ClientRender.wand.destroy);
                        continue;
                    }
                    ClientRender.preview_block(matrix, consumer, x + (float)aabb.minX, y + (float)aabb.minY, z + (float)aabb.minZ, x + (float)aabb.maxX, y + (float)aabb.maxY, z + (float)aabb.maxZ, mode_outline_color);
                }
            }
            bufferSource.endLastBatch();
        }
    }

    static void preview_block(Matrix4f matrix, VertexConsumer consumer, float fx1, float fy1, float fz1, float fx2, float fy2, float fz2, Colorf c) {
        fy2 -= -0.005f;
        fz2 -= -0.005f;
        consumer.addVertex(matrix, fx1 += -0.005f, fy1 += -0.005f, fz1 += -0.005f).setColor(c.r, c.g, c.b, c.a).setNormal(0.0f, 0.0f, 0.0f);
        consumer.addVertex(matrix, fx2 -= -0.005f, fy1, fz1).setColor(c.r, c.g, c.b, c.a).setNormal(0.0f, 0.0f, 0.0f);
        consumer.addVertex(matrix, fx1, fy1, fz1).setColor(c.r, c.g, c.b, c.a).setNormal(0.0f, 0.0f, 0.0f);
        consumer.addVertex(matrix, fx1, fy1, fz2).setColor(c.r, c.g, c.b, c.a).setNormal(0.0f, 0.0f, 0.0f);
        consumer.addVertex(matrix, fx1, fy1, fz2).setColor(c.r, c.g, c.b, c.a).setNormal(0.0f, 0.0f, 0.0f);
        consumer.addVertex(matrix, fx2, fy1, fz2).setColor(c.r, c.g, c.b, c.a).setNormal(0.0f, 0.0f, 0.0f);
        consumer.addVertex(matrix, fx2, fy1, fz1).setColor(c.r, c.g, c.b, c.a).setNormal(0.0f, 0.0f, 0.0f);
        consumer.addVertex(matrix, fx2, fy1, fz2).setColor(c.r, c.g, c.b, c.a).setNormal(0.0f, 0.0f, 0.0f);
        consumer.addVertex(matrix, fx1, fy2, fz1).setColor(c.r, c.g, c.b, c.a).setNormal(0.0f, 0.0f, 0.0f);
        consumer.addVertex(matrix, fx2, fy2, fz1).setColor(c.r, c.g, c.b, c.a).setNormal(0.0f, 0.0f, 0.0f);
        consumer.addVertex(matrix, fx1, fy2, fz1).setColor(c.r, c.g, c.b, c.a).setNormal(0.0f, 0.0f, 0.0f);
        consumer.addVertex(matrix, fx1, fy2, fz2).setColor(c.r, c.g, c.b, c.a).setNormal(0.0f, 0.0f, 0.0f);
        consumer.addVertex(matrix, fx1, fy2, fz2).setColor(c.r, c.g, c.b, c.a).setNormal(0.0f, 0.0f, 0.0f);
        consumer.addVertex(matrix, fx2, fy2, fz2).setColor(c.r, c.g, c.b, c.a).setNormal(0.0f, 0.0f, 0.0f);
        consumer.addVertex(matrix, fx2, fy2, fz1).setColor(c.r, c.g, c.b, c.a).setNormal(0.0f, 0.0f, 0.0f);
        consumer.addVertex(matrix, fx2, fy2, fz2).setColor(c.r, c.g, c.b, c.a).setNormal(0.0f, 0.0f, 0.0f);
        consumer.addVertex(matrix, fx1, fy1, fz1).setColor(c.r, c.g, c.b, c.a).setNormal(0.0f, 0.0f, 0.0f);
        consumer.addVertex(matrix, fx1, fy2, fz1).setColor(c.r, c.g, c.b, c.a).setNormal(0.0f, 0.0f, 0.0f);
        consumer.addVertex(matrix, fx2, fy1, fz1).setColor(c.r, c.g, c.b, c.a).setNormal(0.0f, 0.0f, 0.0f);
        consumer.addVertex(matrix, fx2, fy2, fz1).setColor(c.r, c.g, c.b, c.a).setNormal(0.0f, 0.0f, 0.0f);
        consumer.addVertex(matrix, fx1, fy1, fz2).setColor(c.r, c.g, c.b, c.a).setNormal(0.0f, 0.0f, 0.0f);
        consumer.addVertex(matrix, fx1, fy2, fz2).setColor(c.r, c.g, c.b, c.a).setNormal(0.0f, 0.0f, 0.0f);
        consumer.addVertex(matrix, fx2, fy1, fz2).setColor(c.r, c.g, c.b, c.a).setNormal(0.0f, 0.0f, 0.0f);
        consumer.addVertex(matrix, fx2, fy2, fz2).setColor(c.r, c.g, c.b, c.a).setNormal(0.0f, 0.0f, 0.0f);
    }

    static void preview_block_fat(Matrix4f matrix, VertexConsumer consumer, float fx1, float fy1, float fz1, float fx2, float fy2, float fz2, Colorf c, boolean cross) {
        float off = 0.01f;
        fz2 += off;
        float w = fat_lines_width;
        ClientRender.quad_line(matrix, consumer, 0.0f, w, 0.0f, fx1 -= off, fy1, fz1 -= off, fx2 += off, fy1 -= off, fz1, c);
        ClientRender.quad_line(matrix, consumer, 0.0f, -w, 0.0f, fx2, fy2 += off, fz1, fx1, fy2, fz1, c);
        ClientRender.quad_line(matrix, consumer, w, 0.0f, 0.0f, fx1, fy2 - w, fz1, fx1, fy1 + w, fz1, c);
        ClientRender.quad_line(matrix, consumer, -w, 0.0f, 0.0f, fx2, fy1 + w, fz1, fx2, fy2 - w, fz1, c);
        if (cross) {
            ClientRender.quad_line(matrix, consumer, -w, 0.0f, 0.0f, fx1 + w, fy1, fz1, fx2, fy2, fz1, c);
            ClientRender.quad_line(matrix, consumer, w, 0.0f, 0.0f, fx1, fy2, fz1, fx2 - w, fy1, fz1, c);
        }
        ClientRender.quad_line(matrix, consumer, 0.0f, w, 0.0f, fx2, fy1, fz2, fx1, fy1, fz2, c);
        ClientRender.quad_line(matrix, consumer, 0.0f, -w, 0.0f, fx1, fy2, fz2, fx2, fy2, fz2, c);
        ClientRender.quad_line(matrix, consumer, w, 0.0f, 0.0f, fx1, fy1 + w, fz2, fx1, fy2 - w, fz2, c);
        ClientRender.quad_line(matrix, consumer, -w, 0.0f, 0.0f, fx2, fy2 - w, fz2, fx2, fy1 + w, fz2, c);
        if (cross) {
            ClientRender.quad_line(matrix, consumer, w, 0.0f, 0.0f, fx1, fy1, fz2, fx2 - w, fy2, fz2, c);
            ClientRender.quad_line(matrix, consumer, -w, 0.0f, 0.0f, fx1 + w, fy2, fz2, fx2, fy1, fz2, c);
        }
        ClientRender.quad_line(matrix, consumer, w, 0.0f, 0.0f, fx1, fy2, fz2, fx1, fy2, fz1, c);
        ClientRender.quad_line(matrix, consumer, -w, 0.0f, 0.0f, fx2, fy2, fz1, fx2, fy2, fz2, c);
        ClientRender.quad_line(matrix, consumer, 0.0f, 0.0f, w, fx1 + w, fy2, fz1, fx2 - w, fy2, fz1, c);
        ClientRender.quad_line(matrix, consumer, 0.0f, 0.0f, -w, fx2 - w, fy2, fz2, fx1 + w, fy2, fz2, c);
        if (cross) {
            ClientRender.quad_line(matrix, consumer, -w, 0.0f, 0.0f, fx1 + w, fy2, fz1, fx2, fy2, fz2, c);
            ClientRender.quad_line(matrix, consumer, w, 0.0f, 0.0f, fx1, fy2, fz2, fx2 - w, fy2, fz1, c);
        }
        ClientRender.quad_line(matrix, consumer, w, 0.0f, 0.0f, fx1, fy1, fz1, fx1, fy1, fz2, c);
        ClientRender.quad_line(matrix, consumer, -w, 0.0f, 0.0f, fx2, fy1, fz2, fx2, fy1, fz1, c);
        ClientRender.quad_line(matrix, consumer, 0.0f, 0.0f, w, fx2 - w, fy1, fz1, fx1 + w, fy1, fz1, c);
        ClientRender.quad_line(matrix, consumer, 0.0f, 0.0f, -w, fx1 + w, fy1, fz2, fx2 - w, fy1, fz2, c);
        if (cross) {
            ClientRender.quad_line(matrix, consumer, w, 0.0f, 0.0f, fx1, fy1, fz1, fx2 - w, fy1, fz2, c);
            ClientRender.quad_line(matrix, consumer, -w, 0.0f, 0.0f, fx1 + w, fy1, fz2, fx2, fy1, fz1, c);
        }
        ClientRender.quad_line(matrix, consumer, 0.0f, w, 0.0f, fx2, fy1, fz1, fx2, fy1, fz2, c);
        ClientRender.quad_line(matrix, consumer, 0.0f, -w, 0.0f, fx2, fy2, fz2, fx2, fy2, fz1, c);
        ClientRender.quad_line(matrix, consumer, 0.0f, 0.0f, w, fx2, fy2 - w, fz1, fx2, fy1 + w, fz1, c);
        ClientRender.quad_line(matrix, consumer, 0.0f, 0.0f, -w, fx2, fy1 + w, fz2, fx2, fy2 - w, fz2, c);
        if (cross) {
            ClientRender.quad_line(matrix, consumer, 0.0f, 0.0f, w, fx1, fy1, fz1, fx1, fy2, fz2 - w, c);
            ClientRender.quad_line(matrix, consumer, 0.0f, 0.0f, w, fx1, fy1, fz2 - w, fx1, fy2, fz1, c);
        }
        ClientRender.quad_line(matrix, consumer, 0.0f, w, 0.0f, fx1, fy1, fz2, fx1, fy1, fz1, c);
        ClientRender.quad_line(matrix, consumer, 0.0f, -w, 0.0f, fx1, fy2, fz1, fx1, fy2, fz2, c);
        ClientRender.quad_line(matrix, consumer, 0.0f, 0.0f, w, fx1, fy1 + w, fz1, fx1, fy2 - w, fz1, c);
        ClientRender.quad_line(matrix, consumer, 0.0f, 0.0f, -w, fx1, fy2 - w, fz2, fx1, fy1 + w, fz2, c);
        if (cross) {
            ClientRender.quad_line(matrix, consumer, 0.0f, 0.0f, -w, fx2, fy1, fz1 + w, fx2, fy2, fz2, c);
            ClientRender.quad_line(matrix, consumer, 0.0f, 0.0f, -w, fx2, fy1, fz2, fx2, fy2, fz1 + w, c);
        }
    }

    private static void quad_line(Matrix4f matrix, VertexConsumer consumer, float wx, float wy, float wz, float lx1, float ly1, float lz1, float lx2, float ly2, float lz2, Colorf c) {
        consumer.addVertex(matrix, lx1, ly1, lz1).setColor(c.r, c.g, c.b, c.a);
        consumer.addVertex(matrix, lx1 + wx, ly1 + wy, lz1 + wz).setColor(c.r, c.g, c.b, c.a);
        consumer.addVertex(matrix, lx2 + wx, ly2 + wy, lz2 + wz).setColor(c.r, c.g, c.b, c.a);
        consumer.addVertex(matrix, lx2, ly2, lz2).setColor(c.r, c.g, c.b, c.a);
    }

    private static void player_facing_line(VertexConsumer consumer, float lx1, float ly1, float lz1, float lx2, float ly2, float lz2, Colorf c) {
        float w = 0.05f;
        float p2y = ly2 - ly1;
        float p1z = -lz1;
        float p2z = lz2 - lz1;
        float p1y = -ly1;
        float nx = p2y * p1z - p2z * p1y;
        float p1x = -lx1;
        float p2x = lx2 - lx1;
        float ny = p2z * p1x - p2x * p1z;
        float nz = p2x * p1y - p2y * p1x;
        float l = (float)Math.sqrt(nx * nx + ny * ny + nz * nz);
        if (l != 0.0f) {
            nx = nx / l * w;
            ny = ny / l * w;
            nz = nz / l * w;
        }
        consumer.addVertex(lx1 - nx, ly1 - ny, lz1 - nz).setColor(c.r, c.g, c.b, c.a);
        consumer.addVertex(lx1 + nx, ly1 + ny, lz1 + nz).setColor(c.r, c.g, c.b, c.a);
        consumer.addVertex(lx2 + nx, ly2 + ny, lz2 + nz).setColor(c.r, c.g, c.b, c.a);
        consumer.addVertex(lx2 - nx, ly2 - ny, lz2 - nz).setColor(c.r, c.g, c.b, c.a);
    }

    private static void set_grid_v(int i, float x, float y, float z) {
        if (i < 16) {
            ClientRender.grid_vx[i] = x;
            ClientRender.grid_vy[i] = y;
            ClientRender.grid_vz[i] = z;
        }
    }

    private static void add_grid_line(float x1, float y1, float z1, float x2, float y2, float z2) {
        ClientRender.set_grid_v(grid_i, x1, y1, z1);
        ClientRender.set_grid_v(++grid_i, x2, y2, z2);
        ++grid_i;
    }

    private static void draw_lines(VertexConsumer consumer, int from, int to, float r, float g, float b, float a) {
        for (int i = from; i < to && i < 16; ++i) {
            consumer.addVertex(grid_vx[i], grid_vy[i], grid_vz[i]).setColor(r, g, b, a).setNormal((float)ClientRender.player_normal.x, (float)ClientRender.player_normal.y, (float)ClientRender.player_normal.z);
        }
    }

    private static void grid(VertexConsumer consumer, Direction side, float x, float y, float z, AABB aabb) {
        float w = 1.0f;
        float h = 1.0f;
        float w2 = w * 0.33333334f;
        float w3 = w * 0.6666667f;
        float h2 = h * 0.33333334f;
        float h3 = h * 0.6666667f;
        float o = 0.02f;
        switch (side) {
            case UP: 
            case DOWN: {
                w = (float)aabb.getXsize();
                h = (float)aabb.getZsize();
                x += (float)aabb.minX;
                z += (float)aabb.minZ;
                y = side == Direction.UP ? (y += (float)aabb.maxY + o) : (y += (float)aabb.minY - o);
                w2 = w * 0.33333334f;
                w3 = w * 0.6666667f;
                h2 = h * 0.33333334f;
                h3 = h * 0.6666667f;
                grid_i = 0;
                ClientRender.add_grid_line(x, y, z, x + w, y, z);
                ClientRender.add_grid_line(x, y, z, x, y, z + h);
                ClientRender.add_grid_line(x + w, y, z, x + w, y, z + h);
                ClientRender.add_grid_line(x, y, z + h, x + w, y, z + h);
                ClientRender.add_grid_line(x, y, z + h2, x + w, y, z + h2);
                ClientRender.add_grid_line(x, y, z + h3, x + w, y, z + h3);
                ClientRender.add_grid_line(x + w2, y, z, x + w2, y, z + h);
                ClientRender.add_grid_line(x + w3, y, z, x + w3, y, z + h);
                ClientRender.draw_lines(consumer, 0, 16, 1.0f, 1.0f, 1.0f, 1.0f);
                grid_i = 0;
                ClientRender.add_grid_line(x + w * 0.4f, y, z + h * 0.2f, x + w * 0.5f, y, z + h * 0.05f);
                ClientRender.add_grid_line(x + w * 0.6f, y, z + h * 0.2f, x + w * 0.5f, y, z + h * 0.05f);
                ClientRender.add_grid_line(x + w * 0.4f, y, z + h * 0.8f, x + w * 0.5f, y, z + h * 0.95f);
                ClientRender.add_grid_line(x + w * 0.6f, y, z + h * 0.8f, x + w * 0.5f, y, z + h * 0.95f);
                ClientRender.add_grid_line(x + w * 0.2f, y, z + h * 0.4f, x + w * 0.05f, y, z + h * 0.5f);
                ClientRender.add_grid_line(x + w * 0.2f, y, z + h * 0.6f, x + w * 0.05f, y, z + h * 0.5f);
                ClientRender.add_grid_line(x + w * 0.8f, y, z + h * 0.4f, x + w * 0.95f, y, z + h * 0.5f);
                ClientRender.add_grid_line(x + w * 0.8f, y, z + h * 0.6f, x + w * 0.95f, y, z + h * 0.5f);
                ClientRender.draw_lines(consumer, 0, 16, 0.7f, 0.0f, 0.0f, 1.0f);
                grid_i = 0;
                ClientRender.add_grid_line(x + w * 0.4f, y, z + h * 0.5f, x + w * 0.5f, y, z + h * 0.4f);
                ClientRender.add_grid_line(x + w * 0.4f, y, z + h * 0.5f, x + w * 0.5f, y, z + h * 0.6f);
                ClientRender.add_grid_line(x + w * 0.6f, y, z + h * 0.5f, x + w * 0.5f, y, z + h * 0.6f);
                ClientRender.add_grid_line(x + w * 0.5f, y, z + h * 0.4f, x + w * 0.6f, y, z + h * 0.5f);
                ClientRender.draw_lines(consumer, 0, 8, 0.0f, 0.7f, 0.0f, 1.0f);
                grid_i = 0;
                ClientRender.add_grid_line(x + w * 0.1f, y, z + h * 0.1f, x + w * 0.2f, y, z + h * 0.14f);
                ClientRender.add_grid_line(x + w * 0.1f, y, z + h * 0.1f, x + w * 0.14f, y, z + h * 0.2f);
                ClientRender.add_grid_line(x + w * 0.9f, y, z + h * 0.9f, x + w * 0.8f, y, z + h * 0.86f);
                ClientRender.add_grid_line(x + w * 0.9f, y, z + h * 0.9f, x + w * 0.86f, y, z + h * 0.8f);
                ClientRender.add_grid_line(x + w * 0.9f, y, z + h * 0.1f, x + w * 0.8f, y, z + h * 0.14f);
                ClientRender.add_grid_line(x + w * 0.9f, y, z + h * 0.1f, x + w * 0.86f, y, z + h * 0.2f);
                ClientRender.add_grid_line(x + w * 0.1f, y, z + h * 0.9f, x + w * 0.2f, y, z + h * 0.86f);
                ClientRender.add_grid_line(x + w * 0.1f, y, z + h * 0.9f, x + w * 0.14f, y, z + h * 0.8f);
                ClientRender.draw_lines(consumer, 0, 16, 0.0f, 0.0f, 0.7f, 1.0f);
                break;
            }
            case NORTH: 
            case SOUTH: {
                w = (float)aabb.getXsize();
                h = (float)aabb.getYsize();
                x += (float)aabb.minX;
                y += (float)aabb.minY;
                z = side == Direction.SOUTH ? (z += (float)aabb.maxZ + o) : (z += (float)aabb.minZ - o);
                w2 = w * 0.33333334f;
                w3 = w * 0.6666667f;
                h2 = h * 0.33333334f;
                h3 = h * 0.6666667f;
                grid_i = 0;
                ClientRender.add_grid_line(x, y, z, x + w, y, z);
                ClientRender.add_grid_line(x, y, z, x, y + h, z);
                ClientRender.add_grid_line(x + w, y, z, x + w, y + h, z);
                ClientRender.add_grid_line(x, y + h, z, x + w, y + h, z);
                ClientRender.add_grid_line(x, y + h2, z, x + w, y + h2, z);
                ClientRender.add_grid_line(x, y + h3, z, x + w, y + h3, z);
                ClientRender.add_grid_line(x + w2, y, z, x + w2, y + h, z);
                ClientRender.add_grid_line(x + w3, y, z, x + w3, y + h, z);
                ClientRender.draw_lines(consumer, 0, 16, 1.0f, 1.0f, 1.0f, 1.0f);
                grid_i = 0;
                ClientRender.add_grid_line(x + w * 0.4f, y + h * 0.2f, z, x + w * 0.5f, y + h * 0.05f, z);
                ClientRender.add_grid_line(x + w * 0.6f, y + h * 0.2f, z, x + w * 0.5f, y + h * 0.05f, z);
                ClientRender.add_grid_line(x + w * 0.4f, y + h * 0.8f, z, x + w * 0.5f, y + h * 0.95f, z);
                ClientRender.add_grid_line(x + w * 0.6f, y + h * 0.8f, z, x + w * 0.5f, y + h * 0.95f, z);
                ClientRender.add_grid_line(x + w * 0.2f, y + h * 0.4f, z, x + w * 0.05f, y + h * 0.5f, z);
                ClientRender.add_grid_line(x + w * 0.2f, y + h * 0.6f, z, x + w * 0.05f, y + h * 0.5f, z);
                ClientRender.add_grid_line(x + w * 0.8f, y + h * 0.4f, z, x + w * 0.95f, y + h * 0.5f, z);
                ClientRender.add_grid_line(x + w * 0.8f, y + h * 0.6f, z, x + w * 0.95f, y + h * 0.5f, z);
                ClientRender.draw_lines(consumer, 0, 16, 0.7f, 0.0f, 0.0f, 1.0f);
                grid_i = 0;
                ClientRender.add_grid_line(x + w * 0.4f, y + h * 0.5f, z, x + w * 0.5f, y + h * 0.4f, z);
                ClientRender.add_grid_line(x + w * 0.4f, y + h * 0.5f, z, x + w * 0.5f, y + h * 0.6f, z);
                ClientRender.add_grid_line(x + w * 0.6f, y + h * 0.5f, z, x + w * 0.5f, y + h * 0.6f, z);
                ClientRender.add_grid_line(x + w * 0.5f, y + h * 0.4f, z, x + w * 0.6f, y + h * 0.5f, z);
                ClientRender.draw_lines(consumer, 0, 8, 0.0f, 0.7f, 0.0f, 1.0f);
                grid_i = 0;
                ClientRender.add_grid_line(x + w * 0.1f, y + h * 0.1f, z, x + w * 0.2f, y + h * 0.14f, z);
                ClientRender.add_grid_line(x + w * 0.1f, y + h * 0.1f, z, x + w * 0.14f, y + h * 0.2f, z);
                ClientRender.add_grid_line(x + w * 0.9f, y + h * 0.9f, z, x + w * 0.8f, y + h * 0.86f, z);
                ClientRender.add_grid_line(x + w * 0.9f, y + h * 0.9f, z, x + w * 0.86f, y + h * 0.8f, z);
                ClientRender.add_grid_line(x + w * 0.9f, y + h * 0.1f, z, x + w * 0.8f, y + h * 0.14f, z);
                ClientRender.add_grid_line(x + w * 0.9f, y + h * 0.1f, z, x + w * 0.86f, y + h * 0.2f, z);
                ClientRender.add_grid_line(x + w * 0.1f, y + h * 0.9f, z, x + w * 0.2f, y + h * 0.86f, z);
                ClientRender.add_grid_line(x + w * 0.1f, y + h * 0.9f, z, x + w * 0.14f, y + h * 0.8f, z);
                ClientRender.draw_lines(consumer, 0, 16, 0.0f, 0.0f, 0.7f, 1.0f);
                break;
            }
            case EAST: 
            case WEST: {
                y += (float)aabb.minY;
                z += (float)aabb.minZ;
                x = side == Direction.EAST ? (x += (float)aabb.maxX + o) : (x += (float)aabb.minX - o);
                w = (float)aabb.getYsize();
                h = (float)aabb.getZsize();
                w2 = w * 0.33333334f;
                w3 = w * 0.6666667f;
                h2 = h * 0.33333334f;
                h3 = h * 0.6666667f;
                grid_i = 0;
                ClientRender.add_grid_line(x, y, z, x, y + w, z);
                ClientRender.add_grid_line(x, y, z, x, y, z + h);
                ClientRender.add_grid_line(x, y + w, z, x, y + w, z + h);
                ClientRender.add_grid_line(x, y, z + h, x, y + w, z + h);
                ClientRender.add_grid_line(x, y, z + h2, x, y + w, z + h2);
                ClientRender.add_grid_line(x, y, z + h3, x, y + w, z + h3);
                ClientRender.add_grid_line(x, y + w2, z, x, y + w2, z + h);
                ClientRender.add_grid_line(x, y + w3, z, x, y + w3, z + h);
                ClientRender.draw_lines(consumer, 0, 16, 1.0f, 1.0f, 1.0f, 1.0f);
                grid_i = 0;
                ClientRender.add_grid_line(x, y + w * 0.4f, z + h * 0.2f, x, y + w * 0.5f, z + h * 0.05f);
                ClientRender.add_grid_line(x, y + w * 0.6f, z + h * 0.2f, x, y + w * 0.5f, z + h * 0.05f);
                ClientRender.add_grid_line(x, y + w * 0.4f, z + h * 0.8f, x, y + w * 0.5f, z + h * 0.95f);
                ClientRender.add_grid_line(x, y + w * 0.6f, z + h * 0.8f, x, y + w * 0.5f, z + h * 0.95f);
                ClientRender.add_grid_line(x, y + w * 0.2f, z + h * 0.4f, x, y + w * 0.05f, z + h * 0.5f);
                ClientRender.add_grid_line(x, y + w * 0.2f, z + h * 0.6f, x, y + w * 0.05f, z + h * 0.5f);
                ClientRender.add_grid_line(x, y + w * 0.8f, z + h * 0.4f, x, y + w * 0.95f, z + h * 0.5f);
                ClientRender.add_grid_line(x, y + w * 0.8f, z + h * 0.6f, x, y + w * 0.95f, z + h * 0.5f);
                ClientRender.draw_lines(consumer, 0, 16, 0.7f, 0.0f, 0.0f, 1.0f);
                grid_i = 0;
                ClientRender.add_grid_line(x, y + w * 0.4f, z + h * 0.5f, x, y + w * 0.5f, z + h * 0.4f);
                ClientRender.add_grid_line(x, y + w * 0.4f, z + h * 0.5f, x, y + w * 0.5f, z + h * 0.6f);
                ClientRender.add_grid_line(x, y + w * 0.6f, z + h * 0.5f, x, y + w * 0.5f, z + h * 0.6f);
                ClientRender.add_grid_line(x, y + w * 0.5f, z + h * 0.4f, x, y + w * 0.6f, z + h * 0.5f);
                ClientRender.draw_lines(consumer, 0, 8, 0.0f, 0.7f, 0.0f, 1.0f);
                grid_i = 0;
                ClientRender.add_grid_line(x, y + w * 0.1f, z + h * 0.1f, x, y + w * 0.2f, z + h * 0.14f);
                ClientRender.add_grid_line(x, y + w * 0.1f, z + h * 0.1f, x, y + w * 0.14f, z + h * 0.2f);
                ClientRender.add_grid_line(x, y + w * 0.9f, z + h * 0.9f, x, y + w * 0.8f, z + h * 0.86f);
                ClientRender.add_grid_line(x, y + w * 0.9f, z + h * 0.9f, x, y + w * 0.86f, z + h * 0.8f);
                ClientRender.add_grid_line(x, y + w * 0.9f, z + h * 0.1f, x, y + w * 0.8f, z + h * 0.14f);
                ClientRender.add_grid_line(x, y + w * 0.9f, z + h * 0.1f, x, y + w * 0.86f, z + h * 0.2f);
                ClientRender.add_grid_line(x, y + w * 0.1f, z + h * 0.9f, x, y + w * 0.2f, z + h * 0.86f);
                ClientRender.add_grid_line(x, y + w * 0.1f, z + h * 0.9f, x, y + w * 0.14f, z + h * 0.8f);
                ClientRender.draw_lines(consumer, 0, 16, 0.0f, 0.0f, 0.7f, 1.0f);
            }
        }
    }

    static void render_fluid(VertexConsumer consumer, float x, float y, float z, int color, float u1, float v1, float u0, float v0) {
        float h = 0.875f;
        float o = 0.1f;
        bp.set((double)x, (double)y, (double)z);
        int bf = LevelRenderer.getLightColor((BlockAndTintGetter)ClientRender.wand.level, (BlockPos)bp);
        consumer.addVertex(x + o, y + h - o, z + o).setUv(u1, v1).setColor(color).setNormal(0.0f, 1.0f, 0.0f).setLight(bf);
        consumer.addVertex(x + o, y + h - o, z + 1.0f - o).setUv(u1, v0).setColor(color).setNormal(0.0f, 1.0f, 0.0f).setLight(bf);
        consumer.addVertex(x + 1.0f - o, y + h - o, z + 1.0f - o).setUv(u0, v0).setColor(color).setNormal(0.0f, 1.0f, 0.0f).setLight(bf);
        consumer.addVertex(x + 1.0f - o, y + h - o, z + o).setUv(u0, v1).setColor(color).setNormal(0.0f, 1.0f, 0.0f).setLight(bf);
        consumer.addVertex(x + o, y + o, z + o).setUv(u1, v1).setColor(color).setNormal(0.0f, 1.0f, 0.0f).setLight(bf);
        consumer.addVertex(x + 1.0f - o, y + o, z + o).setUv(u0, v1).setColor(color).setNormal(0.0f, 1.0f, 0.0f).setLight(bf);
        consumer.addVertex(x + 1.0f - o, y + o, z + 1.0f - o).setUv(u0, v0).setColor(color).setNormal(0.0f, 1.0f, 0.0f).setLight(bf);
        consumer.addVertex(x + o, y + o, z + 1.0f - o).setUv(u1, v0).setColor(color).setNormal(0.0f, 1.0f, 0.0f).setLight(bf);
        consumer.addVertex(x + o, y + o, z + o).setUv(u1, v1).setColor(color).setNormal(0.0f, 1.0f, 0.0f).setLight(bf);
        consumer.addVertex(x + o, y + h - o, z + o).setUv(u1, v0).setColor(color).setNormal(0.0f, 1.0f, 0.0f).setLight(bf);
        consumer.addVertex(x + 1.0f - o, y + h - o, z + o).setUv(u0, v0).setColor(color).setNormal(0.0f, 1.0f, 0.0f).setLight(bf);
        consumer.addVertex(x + 1.0f - o, y + o, z + o).setUv(u0, v1).setColor(color).setNormal(0.0f, 1.0f, 0.0f).setLight(bf);
        consumer.addVertex(x + o, y + o, z + 1.0f - o).setUv(u1, v1).setColor(color).setNormal(0.0f, 1.0f, 0.0f).setLight(bf);
        consumer.addVertex(x + 1.0f - o, y + o, z + 1.0f - o).setUv(u0, v1).setColor(color).setNormal(0.0f, 1.0f, 0.0f).setLight(bf);
        consumer.addVertex(x + 1.0f - o, y + h - o, z + 1.0f - o).setUv(u0, v0).setColor(color).setNormal(0.0f, 1.0f, 0.0f).setLight(bf);
        consumer.addVertex(x + o, y + h - o, z + 1.0f - o).setUv(u1, v0).setColor(color).setNormal(0.0f, 1.0f, 0.0f).setLight(bf);
        consumer.addVertex(x + o, y + o, z + o).setUv(u0, v1).setColor(color).setNormal(0.0f, 1.0f, 0.0f).setLight(bf);
        consumer.addVertex(x + o, y + o, z + 1.0f - o).setUv(u1, v1).setColor(color).setNormal(0.0f, 1.0f, 0.0f).setLight(bf);
        consumer.addVertex(x + o, y + h - o, z + 1.0f - o).setUv(u1, v0).setColor(color).setNormal(0.0f, 1.0f, 0.0f).setLight(bf);
        consumer.addVertex(x + o, y + h - o, z + o).setUv(u0, v0).setColor(color).setNormal(0.0f, 1.0f, 0.0f).setLight(bf);
        consumer.addVertex(x + 1.0f - o, y + o, z + o).setUv(u0, v1).setColor(color).setNormal(0.0f, 1.0f, 0.0f).setLight(bf);
        consumer.addVertex(x + 1.0f - o, y + h - o, z + o).setUv(u0, v0).setColor(color).setNormal(0.0f, 1.0f, 0.0f).setLight(bf);
        consumer.addVertex(x + 1.0f - o, y + h - o, z + 1.0f - o).setUv(u1, v0).setColor(color).setNormal(0.0f, 1.0f, 0.0f).setLight(bf);
        consumer.addVertex(x + 1.0f - o, y + o, z + 1.0f - o).setUv(u1, v1).setColor(color).setNormal(0.0f, 1.0f, 0.0f).setLight(bf);
    }

    static void render_shape(PoseStack matrixStack, VertexConsumer consumer, BlockState state, double x, double y, double z) {
        BlockRenderDispatcher blockRenderer = Minecraft.getInstance().getBlockRenderer();
        try {
            BlockStateModel bakedModel = blockRenderer.getBlockModel(state);
            List parts_list = bakedModel.collectParts(random);
            if (!parts_list.isEmpty()) {
                matrixStack.pushPose();
                if (ClientRender.wand.mode != WandProps.Mode.COPY) {
                    Vec3i n = ClientRender.wand.side.getUnitVec3i();
                    if (ClientRender.wand.replace) {
                        matrixStack.translate(x + 0.5 * (1.0 - (double)n.getX()) + (double)n.getX(), y + 0.5 * (1.0 - (double)n.getY()) + (double)n.getY(), z + 0.5 * (1.0 - (double)n.getZ()) + (double)n.getZ());
                        matrixStack.scale(0.5f, 0.5f, 0.5f);
                        matrixStack.translate(-0.5f, -0.5f, -0.5f);
                    } else {
                        matrixStack.translate(x + 0.5, y + 0.5, z + 0.5);
                        matrixStack.scale(0.9f, 0.9f, 0.9f);
                        matrixStack.translate(-0.5f, -0.5f, -0.5f);
                    }
                } else {
                    matrixStack.translate(x, y, z);
                }
                for (BlockModelPart part : parts_list) {
                    for (Direction dir : dirs) {
                        List bake_list = part.getQuads(dir);
                        for (BakedQuad quad : bake_list) {
                            TextureManager textureManager = Minecraft.getInstance().getTextureManager();
                            AbstractTexture abstractTexture = textureManager.getTexture(quad.sprite().atlasLocation());
                            RenderSystem.setShaderTexture((int)0, (GpuTextureView)abstractTexture.getTextureView());
                            int kk = client.getBlockColors().getColor(state, null, null, 0);
                            float ff = (float)(kk >> 16 & 0xFF) / 255.0f;
                            float gg = (float)(kk >> 8 & 0xFF) / 255.0f;
                            float hh = (float)(kk & 0xFF) / 255.0f;
                            float k = 1.0f;
                            float l = 1.0f;
                            float m = 1.0f;
                            if (quad.isTinted()) {
                                k = Mth.clamp((float)ff, (float)0.0f, (float)1.0f);
                                l = Mth.clamp((float)gg, (float)0.0f, (float)1.0f);
                                m = Mth.clamp((float)hh, (float)0.0f, (float)1.0f);
                            }
                            consumer.putBulkData(matrixStack.last(), quad, k, l, m, opacity, 0xF000F0, OverlayTexture.NO_OVERLAY);
                        }
                    }
                }
                matrixStack.popPose();
            }
        }
        catch (Exception e) {
            WandsMod.log("render_shape error " + e.toString(), prnt);
        }
    }

    public static void update_colors() {
        bo_col.fromColor(WandsConfig.c_block_outline);
        bbox_col.fromColor(WandsConfig.c_bounding_box);
        destroy_col.fromColor(WandsConfig.c_destroy);
        tool_use_col.fromColor(WandsConfig.c_tool_use);
        start_col.fromColor(WandsConfig.c_start);
        end_col.fromColor(WandsConfig.c_end);
        paste_bb_col.fromColor(WandsConfig.c_paste_bb);
        block_col.fromColor(WandsConfig.c_block);
        line_col.fromColor(WandsConfig.c_line);
    }

    static void preview_direction_mode(MultiBufferSource.BufferSource bufferSource, Matrix4f matrix, float pos_x, float pos_y, float pos_z) {
        List list;
        if (ClientRender.wand.valid && preview_shape != null && !preview_shape.isEmpty() && !(list = preview_shape.toAabbs()).isEmpty() && ClientRender.wand.grid_voxel_index >= 0 && ClientRender.wand.grid_voxel_index < list.size()) {
            int vi;
            VertexConsumer consumer;
            if (fancy) {
                consumer = bufferSource.getBuffer(RenderType.entityTranslucent((ResourceLocation)GRID_TEXTURE));
                vi = 0;
                int light = 0xF000F0;
                int overlay = OverlayTexture.NO_OVERLAY;
                for (AABB aabb : list) {
                    if (vi == ClientRender.wand.grid_voxel_index) {
                        switch (ClientRender.wand.side) {
                            case UP: {
                                x1 = pos_x + (float)aabb.minX;
                                y1 = pos_y + (float)aabb.maxY + 0.02f;
                                z1 = pos_z + (float)aabb.minZ;
                                x2 = pos_x + (float)aabb.maxX;
                                z2 = pos_z + (float)aabb.maxZ;
                                consumer.addVertex(matrix, x1, y1, z1).setUv(0.0f, 0.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f).setLight(light).setOverlay(overlay).setNormal(0.0f, 1.0f, 0.0f);
                                consumer.addVertex(matrix, x1, y1, z2).setUv(0.0f, 1.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f).setLight(light).setOverlay(overlay).setNormal(0.0f, 1.0f, 0.0f);
                                consumer.addVertex(matrix, x2, y1, z2).setUv(1.0f, 1.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f).setLight(light).setOverlay(overlay).setNormal(0.0f, 1.0f, 0.0f);
                                consumer.addVertex(matrix, x2, y1, z1).setUv(1.0f, 0.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f).setLight(light).setOverlay(overlay).setNormal(0.0f, 1.0f, 0.0f);
                                break;
                            }
                            case DOWN: {
                                x1 = pos_x + (float)aabb.minX;
                                y1 = pos_y + (float)aabb.minY - 0.02f;
                                z1 = pos_z + (float)aabb.minZ;
                                x2 = pos_x + (float)aabb.maxX;
                                z2 = pos_z + (float)aabb.maxZ;
                                consumer.addVertex(matrix, x1, y1, z1).setUv(0.0f, 0.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f).setLight(light).setOverlay(overlay).setNormal(0.0f, -1.0f, 0.0f);
                                consumer.addVertex(matrix, x2, y1, z1).setUv(1.0f, 0.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f).setLight(light).setOverlay(overlay).setNormal(0.0f, -1.0f, 0.0f);
                                consumer.addVertex(matrix, x2, y1, z2).setUv(1.0f, 1.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f).setLight(light).setOverlay(overlay).setNormal(0.0f, -1.0f, 0.0f);
                                consumer.addVertex(matrix, x1, y1, z2).setUv(0.0f, 1.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f).setLight(light).setOverlay(overlay).setNormal(0.0f, -1.0f, 0.0f);
                                break;
                            }
                            case SOUTH: {
                                x1 = pos_x + (float)aabb.minX;
                                y1 = pos_y + (float)aabb.minY;
                                z1 = pos_z + (float)aabb.maxZ + 0.02f;
                                x2 = pos_x + (float)aabb.maxX;
                                y2 = pos_y + (float)aabb.maxY;
                                consumer.addVertex(matrix, x1, y1, z1).setUv(0.0f, 0.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f).setLight(light).setOverlay(overlay).setNormal(0.0f, 0.0f, 1.0f);
                                consumer.addVertex(matrix, x2, y1, z1).setUv(1.0f, 0.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f).setLight(light).setOverlay(overlay).setNormal(0.0f, 0.0f, 1.0f);
                                consumer.addVertex(matrix, x2, y2, z1).setUv(1.0f, 1.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f).setLight(light).setOverlay(overlay).setNormal(0.0f, 0.0f, 1.0f);
                                consumer.addVertex(matrix, x1, y2, z1).setUv(0.0f, 1.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f).setLight(light).setOverlay(overlay).setNormal(0.0f, 0.0f, 1.0f);
                                break;
                            }
                            case NORTH: {
                                x1 = pos_x + (float)aabb.minX;
                                y1 = pos_y + (float)aabb.minY;
                                z1 = pos_z + (float)aabb.minZ - 0.02f;
                                x2 = pos_x + (float)aabb.maxX;
                                y2 = pos_y + (float)aabb.maxY;
                                consumer.addVertex(matrix, x1, y1, z1).setUv(0.0f, 0.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f).setLight(light).setOverlay(overlay).setNormal(0.0f, 0.0f, -1.0f);
                                consumer.addVertex(matrix, x1, y2, z1).setUv(0.0f, 1.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f).setLight(light).setOverlay(overlay).setNormal(0.0f, 0.0f, -1.0f);
                                consumer.addVertex(matrix, x2, y2, z1).setUv(1.0f, 1.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f).setLight(light).setOverlay(overlay).setNormal(0.0f, 0.0f, -1.0f);
                                consumer.addVertex(matrix, x2, y1, z1).setUv(1.0f, 0.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f).setLight(light).setOverlay(overlay).setNormal(0.0f, 0.0f, -1.0f);
                                break;
                            }
                            case EAST: {
                                x1 = pos_x + (float)aabb.maxX + 0.02f;
                                y1 = pos_y + (float)aabb.minY;
                                z1 = pos_z + (float)aabb.minZ;
                                y2 = pos_y + (float)aabb.maxY;
                                z2 = pos_z + (float)aabb.maxZ;
                                consumer.addVertex(matrix, x1, y1, z1).setUv(0.0f, 0.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f).setLight(light).setOverlay(overlay).setNormal(1.0f, 0.0f, 0.0f);
                                consumer.addVertex(matrix, x1, y2, z1).setUv(1.0f, 0.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f).setLight(light).setOverlay(overlay).setNormal(1.0f, 0.0f, 0.0f);
                                consumer.addVertex(matrix, x1, y2, z2).setUv(1.0f, 1.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f).setLight(light).setOverlay(overlay).setNormal(1.0f, 0.0f, 0.0f);
                                consumer.addVertex(matrix, x1, y1, z2).setUv(0.0f, 1.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f).setLight(light).setOverlay(overlay).setNormal(1.0f, 0.0f, 0.0f);
                                break;
                            }
                            case WEST: {
                                x1 = pos_x + (float)aabb.minX - 0.02f;
                                y1 = pos_y + (float)aabb.minY;
                                z1 = pos_z + (float)aabb.minZ;
                                y2 = pos_y + (float)aabb.maxY;
                                z2 = pos_z + (float)aabb.maxZ;
                                consumer.addVertex(matrix, x1, y1, z1).setUv(0.0f, 0.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f).setLight(light).setOverlay(overlay).setNormal(-1.0f, 0.0f, 0.0f);
                                consumer.addVertex(matrix, x1, y1, z2).setUv(0.0f, 1.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f).setLight(light).setOverlay(overlay).setNormal(-1.0f, 0.0f, 0.0f);
                                consumer.addVertex(matrix, x1, y2, z2).setUv(1.0f, 1.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f).setLight(light).setOverlay(overlay).setNormal(-1.0f, 0.0f, 0.0f);
                                consumer.addVertex(matrix, x1, y2, z1).setUv(1.0f, 0.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f).setLight(light).setOverlay(overlay).setNormal(-1.0f, 0.0f, 0.0f);
                            }
                        }
                    }
                    ++vi;
                }
                bufferSource.endLastBatch();
            }
            if (!fancy || !fat_lines) {
                consumer = bufferSource.getBuffer(RenderType.lines());
                vi = 0;
                for (AABB aabb : list) {
                    if (vi == ClientRender.wand.grid_voxel_index) {
                        ClientRender.grid(consumer, ClientRender.wand.side, pos_x, pos_y, pos_z, aabb);
                    }
                    ++vi;
                }
                bufferSource.endLastBatch();
            }
        }
    }

    static void preview_block_buffer(MultiBufferSource.BufferSource bufferSource, PoseStack matrixStack) {
        if (ClientRender.wand.has_empty_bucket || ClientRender.wand.valid && (has_target || ClientRender.wand.is_alt_pressed) && ClientRender.wand.block_buffer != null) {
            random.setSeed(0L);
            int block_buffer_length = ClientRender.wand.block_buffer.get_length();
            if (block_buffer_length > 0 && fancy && !ClientRender.wand.destroy && !ClientRender.wand.use && !ClientRender.wand.has_empty_bucket) {
                BlockState st;
                if (ClientRender.wand.has_water_bucket) {
                    st = Blocks.WATER.defaultBlockState();
                } else if (ClientRender.wand.has_lava_bucket) {
                    st = Blocks.LAVA.defaultBlockState();
                }
                if (ClientRender.wand.has_water_bucket || ClientRender.wand.has_lava_bucket) {
                    int i;
                    TextureAtlasSprite sprite;
                    VertexConsumer consumer = bufferSource.getBuffer(RenderType.solid());
                    if (ClientRender.wand.has_water_bucket) {
                        am = Minecraft.getInstance().getAtlasManager();
                        atlas = am.getAtlasOrThrow(ModelBakery.WATER_FLOW.atlasLocation());
                        sprite = atlas.getSprite(ModelBakery.WATER_FLOW.texture());
                        i = BiomeColors.getAverageWaterColor((BlockAndTintGetter)ClientRender.wand.level, (BlockPos)ClientRender.wand.pos);
                        if (water_texture == null) {
                            textureManager = Minecraft.getInstance().getTextureManager();
                            water_texture = textureManager.getTexture(sprite.atlasLocation()).getTextureView();
                        }
                        RenderSystem.setShaderTexture((int)0, (GpuTextureView)water_texture);
                    } else {
                        am = Minecraft.getInstance().getAtlasManager();
                        atlas = am.getAtlasOrThrow(ModelBakery.LAVA_FLOW.atlasLocation());
                        sprite = atlas.getSprite(ModelBakery.LAVA_FLOW.texture());
                        i = 0xFFFFFF;
                        if (lava_texture == null) {
                            textureManager = Minecraft.getInstance().getTextureManager();
                            lava_texture = textureManager.getTexture(sprite.atlasLocation()).getTextureView();
                        }
                        RenderSystem.setShaderTexture((int)0, (GpuTextureView)lava_texture);
                    }
                    float u0 = sprite.getU0();
                    float v0 = sprite.getV0();
                    float u1 = sprite.getU1();
                    float v1 = sprite.getV1();
                    for (int idx = 0; idx < block_buffer_length && idx < WandsConfig.max_limit; ++idx) {
                        bp.set(ClientRender.wand.block_buffer.buffer_x[idx], ClientRender.wand.block_buffer.buffer_y[idx], ClientRender.wand.block_buffer.buffer_z[idx]);
                        ClientRender.render_fluid(consumer, ClientRender.wand.block_buffer.buffer_x[idx], ClientRender.wand.block_buffer.buffer_y[idx], ClientRender.wand.block_buffer.buffer_z[idx], i, u0, v0, u1, v1);
                    }
                    bufferSource.endLastBatch();
                } else {
                    VertexConsumer consumer = bufferSource.getBuffer(RenderType.translucentMovingBlock());
                    for (int idx = 0; idx < block_buffer_length && idx < WandsConfig.max_limit; ++idx) {
                        if (ClientRender.wand.block_buffer.state[idx] == null) continue;
                        st = ClientRender.wand.block_buffer.state[idx];
                        ClientRender.render_shape(matrixStack, consumer, st, ClientRender.wand.block_buffer.buffer_x[idx], ClientRender.wand.block_buffer.buffer_y[idx], ClientRender.wand.block_buffer.buffer_z[idx]);
                        if (ClientRender.wand.block_buffer.state[idx].hasProperty((Property)DoublePlantBlock.HALF)) {
                            ClientRender.render_shape(matrixStack, consumer, (BlockState)ClientRender.wand.block_buffer.state[idx].setValue((Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.UPPER), ClientRender.wand.block_buffer.buffer_x[idx], ClientRender.wand.block_buffer.buffer_y[idx] + 1, ClientRender.wand.block_buffer.buffer_z[idx]);
                            continue;
                        }
                        if (!(ClientRender.wand.block_buffer.state[idx].getBlock() instanceof DoorBlock)) continue;
                        ClientRender.render_shape(matrixStack, consumer, (BlockState)ClientRender.wand.block_buffer.state[idx].setValue((Property)DoorBlock.HALF, (Comparable)DoubleBlockHalf.UPPER), ClientRender.wand.block_buffer.buffer_x[idx], ClientRender.wand.block_buffer.buffer_y[idx] + 1, ClientRender.wand.block_buffer.buffer_z[idx]);
                    }
                    bufferSource.endLastBatch();
                }
            }
            if (block_buffer_length > 0) {
                ClientRender.render_mode_outline(matrixStack.last().pose(), bufferSource);
            }
        }
    }

    static void preview_bbox(MultiBufferSource.BufferSource bufferSource, PoseStack matrixStack) {
        float off2 = 0.05f;
        Matrix4f matrix = matrixStack.last().pose();
        float bb1_x = ClientRender.wand.bb1_x;
        float bb1_y = ClientRender.wand.bb1_y;
        float bb1_z = ClientRender.wand.bb1_z;
        float bb2_x = ClientRender.wand.bb2_x;
        float bb2_y = ClientRender.wand.bb2_y;
        float bb2_z = ClientRender.wand.bb2_z;
        if (fat_lines) {
            VertexConsumer consumer = bufferSource.getBuffer(RenderType.debugQuads());
            ClientRender.preview_block_fat(matrix, consumer, bb1_x - off2, bb1_y - off2, bb1_z - off2, bb2_x + off2, bb2_y + off2, bb2_z + off2, bbox_col, false);
        } else {
            VertexConsumer consumer = bufferSource.getBuffer(RenderType.lines());
            ClientRender.preview_block(matrix, consumer, bb1_x - off2, bb1_y - off2, bb1_z - off2, bb2_x + off2, bb2_y + off2, bb2_z + off2, bbox_col);
        }
        bufferSource.endLastBatch();
    }

    static void preview_paste(MultiBufferSource.BufferSource bufferSource, PoseStack matrixStack) {
        BlockPos p;
        int mx = 1;
        int mz = 1;
        Matrix4f matrix = matrixStack.last().pose();
        switch (mirroraxis) {
            case 1: {
                mx = -1;
                break;
            }
            case 2: {
                mz = -1;
            }
        }
        BlockPos b_pos = ClientRender.wand.pos;
        if (!ClientRender.wand.destroy && fancy) {
            random.setSeed(0L);
            VertexConsumer consumer = bufferSource.getBuffer(RenderType.translucentMovingBlock());
            for (CopyBuffer b : ClientRender.wand.copy_paste_buffer) {
                BlockState st = b.state;
                st = ClientRender.wand.palette.has_palette ? wand.get_state(b.pos.getY(), null) : wand.rotate_mirror(st, mirroraxis);
                p = b.pos.rotate(last_rot);
                int px = b_pos.getX() + p.getX() * mx;
                int py = b_pos.getY() + p.getY();
                int pz = b_pos.getZ() + p.getZ() * mz;
                ClientRender.render_shape(matrixStack, consumer, st, px, py, pz);
            }
            bufferSource.endLastBatch();
        }
        if (drawlines && paste_outlines) {
            Colorf col = ClientRender.wand.destroy ? destroy_col : paste_bb_col;
            x1 = 2.1474836E9f;
            y1 = 2.1474836E9f;
            z1 = 2.1474836E9f;
            x2 = -2.1474836E9f;
            y2 = -2.1474836E9f;
            z2 = -2.1474836E9f;
            VertexConsumer consumer = fat_lines ? bufferSource.getBuffer(RenderType.debugQuads()) : bufferSource.getBuffer(RenderType.lines());
            for (CopyBuffer b : ClientRender.wand.copy_paste_buffer) {
                p = b.pos.rotate(last_rot);
                float x = b_pos.getX() + p.getX() * mx;
                float y = b_pos.getY() + p.getY();
                float z = b_pos.getZ() + p.getZ() * mz;
                if (fat_lines) {
                    ClientRender.preview_block_fat(matrix, consumer, x, y, z, x + 1.0f, y + 1.0f, z + 1.0f, col, true);
                } else {
                    ClientRender.preview_block(matrix, consumer, x, y, z, x + 1.0f, y + 1.0f, z + 1.0f, col);
                }
                if (x < x1) {
                    x1 = x;
                }
                if (y < y1) {
                    y1 = y;
                }
                if (z < z1) {
                    z1 = z;
                }
                if (x + 1.0f > x2) {
                    x2 = x + 1.0f;
                }
                if (y + 1.0f > y2) {
                    y2 = y + 1.0f;
                }
                if (!(z + 1.0f > z2)) continue;
                z2 = z + 1.0f;
            }
            if (fat_lines) {
                ClientRender.preview_block_fat(matrix, consumer, x1, y1, z1, x2, y2, z2, col, false);
            } else {
                ClientRender.preview_block(matrix, consumer, x1, y1, z1, x2, y2, z2, col);
            }
            bufferSource.endLastBatch();
        }
    }

    static void preview_selected(WandProps.Mode mode, MultiBufferSource.BufferSource bufferSource, PoseStack matrixStack, float pos_x, float pos_y, float pos_z, float off) {
        Matrix4f matrix = matrixStack.last().pose();
        if (drawlines && wand.getP1() == null && (mode == WandProps.Mode.FILL || mode == WandProps.Mode.LINE || mode == WandProps.Mode.CIRCLE || mode == WandProps.Mode.SPHERE || mode == WandProps.Mode.COPY || mode == WandProps.Mode.PASTE || mode == WandProps.Mode.ROW_COL || mode == WandProps.Mode.ROCK)) {
            VertexConsumer consumer;
            if (fancy && ClientRender.wand.offhand_state != null) {
                random.setSeed(0L);
                consumer = bufferSource.getBuffer(RenderType.translucentMovingBlock());
                ClientRender.render_shape(matrixStack, consumer, ClientRender.wand.offhand_state, pos_x, pos_y, pos_z);
                bufferSource.endLastBatch();
            }
            if (fat_lines) {
                consumer = bufferSource.getBuffer(RenderType.debugQuads());
                ClientRender.preview_block_fat(matrix, consumer, pos_x - off, pos_y - off, pos_z - off, pos_x + 1.0f + off, pos_y + 1.0f + off, pos_z + 1.0f + off, start_col, false);
                bufferSource.endLastBatch();
            } else {
                consumer = bufferSource.getBuffer(RenderType.lines());
                ClientRender.preview_block(matrix, consumer, pos_x - off, pos_y - off, pos_z - off, pos_x + 1.0f + off, pos_y + 1.0f + off, pos_z + 1.0f + off, start_col);
                bufferSource.endLastBatch();
            }
        }
    }

    static void preview_line_circle(Matrix4f matrix, WandProps.Mode mode, MultiBufferSource.BufferSource bufferSource, float p1_x, float p1_y, float p1_z, float p2_x, float p2_y, float p2_z, float off, float off2) {
        if (fat_lines) {
            boolean even = WandProps.getFlag(ClientRender.wand.wand_stack, WandProps.Flag.EVEN);
            VertexConsumer consumer = bufferSource.getBuffer(RenderType.debugQuads());
            ClientRender.preview_block_fat(matrix, consumer, p1_x - off, p1_y - off, p1_z - off, p1_x + 1.0f + off, p1_y + 1.0f + off, p1_z + 1.0f + off, start_col, false);
            bufferSource.endLastBatch();
            if (has_target) {
                consumer = bufferSource.getBuffer(RenderType.debugQuads());
                off = mode == WandProps.Mode.CIRCLE && even ? -0.5f : 0.0f;
                ClientRender.preview_block_fat(matrix, consumer, p2_x - off + off, p2_y - off, p2_z - off + off, p2_x + 1.0f + off + off, p2_y + 1.0f + off, p2_z + 1.0f + off + off, end_col, false);
                bufferSource.endLastBatch();
                if (mode != WandProps.Mode.FILL) {
                    consumer = bufferSource.getBuffer(RenderType.debugQuads());
                    off = mode == WandProps.Mode.CIRCLE && even ? 0.0f : 0.5f;
                    ClientRender.player_facing_line(consumer, p1_x + off, p1_y + off + 0.5f, p1_z + off, p2_x + off, p2_y + off + 0.5f, p2_z + off, line_col);
                    bufferSource.endLastBatch();
                }
            }
        } else {
            VertexConsumer consumer = bufferSource.getBuffer(RenderType.lines());
            consumer.addVertex(p2_x + 0.5f, p2_y + 0.5f, p2_z + 0.5f).setColor(ClientRender.line_col.r, ClientRender.line_col.g, ClientRender.line_col.b, ClientRender.line_col.a);
            consumer.addVertex((float)ClientRender.wand.x1 + 0.5f, (float)ClientRender.wand.y1 + 0.5f, (float)ClientRender.wand.z1 + 0.5f).setColor(ClientRender.line_col.r, ClientRender.line_col.g, ClientRender.line_col.b, ClientRender.line_col.a);
            ClientRender.preview_block(matrix, consumer, p1_x, p1_y, p1_z, p1_x + 1.0f, p1_y + 1.0f, p1_z + 1.0f, start_col);
            ClientRender.preview_block(matrix, consumer, p2_x - off2, p2_y - off2, p2_z - off2, p2_x + 1.0f + off2, p2_y + 1.0f + off2, p2_z + 1.0f + off2, end_col);
            bufferSource.endLastBatch();
        }
    }

    static {
        last_pos = null;
        last_side = null;
        last_rot = Rotation.NONE;
        last_alt = false;
        targeting_air = false;
        last_buffer_size = -1;
        last_orientation = null;
        wand = new Wand();
        preview_shape = null;
        white = new Colorf(1.0f, 1.0f, 1.0f, 1.0f);
        def_aabb = new AABB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        grid_i = 0;
        grid_vx = new float[16];
        grid_vy = new float[16];
        grid_vz = new float[16];
        force = false;
        x1 = 0.0f;
        y1 = 0.0f;
        z1 = 0.0f;
        x2 = 0.0f;
        y2 = 0.0f;
        z2 = 0.0f;
        opacity = 0.8f;
        fancy = true;
        fat_lines = true;
        drawlines = true;
        block_outlines = false;
        fill_outlines = false;
        copy_outlines = false;
        paste_outlines = false;
        fat_lines_width = 0.05f;
        GRID_TEXTURE = Compat.create_resource("textures/blocks/grid.png");
        LINE_TEXTURE = Compat.create_resource("textures/blocks/line.png");
        water_texture = null;
        lava_texture = null;
        random = RandomSource.create();
        dirs = new Direction[]{Direction.DOWN, Direction.UP, Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST, null};
        update_colors = true;
        block_col = new Colorf(1.0f, 1.0f, 1.0f, 1.0f);
        bo_col = new Colorf(1.0f, 1.0f, 1.0f, 1.0f);
        bbox_col = new Colorf(0.0f, 0.0f, 1.0f, 1.0f);
        destroy_col = new Colorf(1.0f, 0.0f, 0.0f, 1.0f);
        tool_use_col = new Colorf(0.0f, 1.0f, 1.0f, 1.0f);
        start_col = new Colorf(1.0f, 1.0f, 0.0f, 1.0f);
        end_col = new Colorf(1.0f, 1.0f, 0.0f, 1.0f);
        line_col = new Colorf(1.0f, 0.0f, 1.0f, 1.0f);
        paste_bb_col = new Colorf(0.0f, 0.0f, 0.0f, 1.0f);
        has_target = false;
        bp = new BlockPos.MutableBlockPos();
        water = false;
        mirroraxis = 0;
    }

    public static enum Colors {
        BLOCK_OUTLINE,
        BOUNDING_BOX,
        DESTROY,
        TOOL_USE,
        START,
        END,
        LINE,
        PASTE_BB,
        BlOCK;

    }

    static class V3f {
        public float x;
        public float y;
        public float z;

        V3f() {
        }
    }
}

