/*
 * Decompiled with CFR 0.152.
 */
package net.nicguzzo.wands.client.screens;

import com.mojang.blaze3d.textures.GpuTexture;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.nicguzzo.wands.items.MagicBagItem;
import net.nicguzzo.wands.menues.MagicBagMenu;
import net.nicguzzo.wands.utils.Compat;

public class MagicBagScreen
extends AbstractContainerScreen<MagicBagMenu> {
    private static final ResourceLocation TEXTURE = Compat.create_resource("textures/gui/magicbag.png");
    ItemStack bag_stack = null;
    Item bag_item = null;
    MagicBagItem.MagicBagItemTier tier = MagicBagItem.MagicBagItemTier.MAGIC_BAG_TIER_1;
    GpuTexture magicbag_Texture;

    public MagicBagScreen(MagicBagMenu abstractContainerMenu, Inventory inventory, Component component) {
        super((AbstractContainerMenu)abstractContainerMenu, inventory, component);
        TextureManager textureManager = Minecraft.getInstance().getTextureManager();
        this.magicbag_Texture = textureManager.getTexture(TEXTURE).getTexture();
    }

    public void init() {
        super.init();
        this.bag_stack = ((MagicBagMenu)this.menu).bag;
        if (this.bag_stack != null && this.bag_stack.getItem() instanceof MagicBagItem) {
            this.bag_item = this.bag_stack.getItem();
            this.tier = ((MagicBagItem)this.bag_item).tier;
        }
    }

    protected void renderBg(GuiGraphics gui, float f, int i, int j) {
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        gui.blit(RenderPipelines.GUI_TEXTURED, TEXTURE, x, y, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 256, 256);
        gui.blit(RenderPipelines.GUI_TEXTURED, TEXTURE, x + 100, y + 33, 240.0f, (float)(16 * this.tier.ordinal()), 16, 16, 256, 256);
    }

    public void render(GuiGraphics gui, int mouseX, int mouseY, float delta) {
        super.render(gui, mouseX, mouseY, delta);
        Minecraft client = Minecraft.getInstance();
        int text_color = -1;
        ItemStack item = MagicBagItem.getItem(this.bag_stack, (HolderLookup.Provider)client.level.registryAccess());
        if (!item.isEmpty()) {
            MutableComponent text = Component.translatable((String)item.getItem().getDescriptionId());
            int w = this.font.width((FormattedText)text);
            gui.drawString(client.font, text.getString(), this.width / 2 - w / 2, this.height / 2 - 20, text_color, false);
        }
        MutableComponent text2 = Compat.literal("" + MagicBagItem.getTotal(this.bag_stack));
        int w2 = this.font.width((FormattedText)text2);
        gui.drawString(client.font, (Component)text2, this.width / 2 - w2 / 2, this.height / 2 - 32, text_color, false);
        MutableComponent text3 = Compat.literal("shift click to load/unload");
        int w3 = this.font.width((FormattedText)text3);
        gui.drawString(client.font, (Component)text3, this.width / 2 - w3 / 2, this.height / 2 - 65, text_color, false);
        this.renderTooltip(gui, mouseX, mouseY);
    }
}

