/*
 * Decompiled with CFR 0.152.
 */
package net.nicguzzo.wands.client.screens;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTextureView;
import dev.architectury.networking.NetworkManager;
import java.util.Vector;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.nicguzzo.wands.WandsMod;
import net.nicguzzo.wands.client.WandsModClient;
import net.nicguzzo.wands.client.gui.Btn;
import net.nicguzzo.wands.client.gui.Select;
import net.nicguzzo.wands.client.gui.Spinner;
import net.nicguzzo.wands.client.gui.Wdgt;
import net.nicguzzo.wands.client.render.ClientRender;
import net.nicguzzo.wands.client.screens.WandConfigScreen;
import net.nicguzzo.wands.items.WandItem;
import net.nicguzzo.wands.menues.WandMenu;
import net.nicguzzo.wands.networking.Networking;
import net.nicguzzo.wands.utils.Compat;
import net.nicguzzo.wands.wand.WandProps;

public class WandScreen
extends AbstractContainerScreen<WandMenu> {
    ItemStack wand_stack = null;
    WandItem wand_item = null;
    GpuTextureView wand_bg_Texture;
    GpuTextureView wand_inv_Texture;
    static final int img_w = 256;
    static final int img_h = 256;
    Component rock_msg = Compat.literal("rotate for new rock");
    private static final ResourceLocation BG_TEX = Compat.create_resource("textures/gui/wand.png");
    private static final ResourceLocation INV_TEX = Compat.create_resource("textures/gui/inventory.png");
    private static final ResourceLocation SLOT_HIGHLIGHT_BACK_SPRITE = ResourceLocation.withDefaultNamespace((String)"container/slot_highlight_back");
    Vector<Wdgt> wdgets = new Vector();
    Select modes_grp;
    Select action_grp;
    Select orientation_grp;
    Select plane_grp;
    Select axis_grp;
    Select inv_grp_btn;
    Select cfill_grp_btn;
    Select rfill_grp_btn;
    Select even_grp_btn;
    Select rot_grp;
    Select state_grp;
    Select slab_grp_btn;
    Select diag_grp_btn;
    Select inc_sel_grp_btn;
    Select target_air_grp_btn;
    Select mirror_axis;
    Btn conf_btn;
    Spinner mult_spn;
    Spinner rock_rad_spn;
    Spinner rock_noise_spn;
    Spinner grid_m_spn;
    Spinner grid_n_spn;
    Spinner grid_mskp_spn;
    Spinner grid_nskp_spn;
    Spinner grid_moff_spn;
    Spinner grid_noff_spn;
    Spinner blast_radius_spn;
    Spinner row_col_spn;
    Spinner arealim_spn;
    Spinner skip_spn;
    Spinner tunnel_w;
    Spinner tunnel_h;
    Spinner tunnel_d;
    Spinner tunnel_ox;
    Spinner tunnel_oy;
    Spinner target_air_dist_spn;
    Select match_state_sel;
    Select drop_pos_sel;
    Btn show_inv_btn;
    boolean show_inv = false;
    int left;
    int right;
    int bottom;
    int top;
    int xoff;
    int yoff;

    public WandScreen(WandMenu handler, Inventory inventory, Component title) {
        super((AbstractContainerMenu)handler, inventory, title);
        TextureManager textureManager = Minecraft.getInstance().getTextureManager();
        this.wand_bg_Texture = textureManager.getTexture(BG_TEX).getTextureView();
        this.wand_inv_Texture = textureManager.getTexture(INV_TEX).getTextureView();
    }

    private Spinner valSpinner(final WandProps.Value val, int x, int y, int w, int h, Component label) {
        int v = WandProps.getVal(this.wand_stack, val);
        return new Spinner(v, val.def, val.max, x, y, w, h, label){

            @Override
            public void onInc(int mx, int my, int value) {
                WandProps.setVal(WandScreen.this.wand_stack, val, value);
                WandsModClient.send_wand(WandScreen.this.wand_stack);
            }

            @Override
            public void onDec(int mx, int my, int value) {
                WandProps.setVal(WandScreen.this.wand_stack, val, value);
                WandsModClient.send_wand(WandScreen.this.wand_stack);
            }
        };
    }

    public void init() {
        int finalp;
        Btn b;
        int i;
        super.init();
        this.wand_stack = ((WandMenu)this.menu).wand;
        if (this.wand_stack == null) {
            return;
        }
        if (this.wand_stack == null || !(this.wand_stack.getItem() instanceof WandItem)) {
            return;
        }
        this.wand_item = (WandItem)this.wand_stack.getItem();
        if (this.wand_item == null) {
            return;
        }
        int btn_h = 10;
        int btn_w = 60;
        int btn_margin = 2;
        int h2 = btn_h + btn_margin;
        int h = WandProps.modes.length * h2;
        this.xoff = WandsMod.config.wand_screen_x_offset;
        this.yoff = WandsMod.config.wand_screen_x_offset;
        this.left = this.width / 2 - 128 - this.xoff;
        this.right = this.width / 2 + 128 - this.xoff;
        this.bottom = this.height / 2 - h / 2 - 12 - this.yoff;
        this.top = this.height / 2 + h / 2 - this.yoff;
        this.rock_rad_spn = this.valSpinner(WandProps.Value.ROCK_RADIUS, this.left + 200, this.bottom + 25, 30, 14, (Component)Compat.translatable("screen.wands.rock_rad"));
        this.rock_rad_spn.label_side = true;
        this.wdgets.add(this.rock_rad_spn);
        this.rock_noise_spn = this.valSpinner(WandProps.Value.ROCK_RADIUS, this.left + 200, this.bottom + 40, 30, 14, (Component)Compat.translatable("screen.wands.rock_noise"));
        this.rock_noise_spn.label_side = true;
        this.wdgets.add(this.rock_noise_spn);
        this.mult_spn = this.valSpinner(WandProps.Value.MULTIPLIER, this.left + 200, this.bottom + 25, 25, 14, (Component)Compat.translatable("screen.wands.multiplier"));
        this.mult_spn.label_side = true;
        this.wdgets.add(this.mult_spn);
        this.row_col_spn = this.valSpinner(WandProps.Value.ROWCOLLIM, this.left + 170, this.bottom + 70, 50, 14, (Component)Compat.translatable("screen.wands.limit"));
        this.row_col_spn.label_side = true;
        this.wdgets.add(this.row_col_spn);
        this.blast_radius_spn = this.valSpinner(WandProps.Value.BLASTRAD, this.left + 210, this.bottom + 25, 25, 14, (Component)Compat.translatable("screen.wands.blast_radius"));
        this.blast_radius_spn.label_side = true;
        this.blast_radius_spn.inc_val = 2;
        this.blast_radius_spn.shift_inc_val = 4;
        this.wdgets.add(this.blast_radius_spn);
        this.grid_m_spn = new Spinner(WandProps.getVal(this.wand_stack, WandProps.Value.GRIDM), 1, this.wand_item.limit, this.left + 180, this.bottom + 25, 25, 14, (Component)Compat.translatable("screen.wands.grid_mxn")){

            @Override
            public void onInc(int mx, int my, int value) {
                WandProps.incGrid(WandScreen.this.wand_stack, WandProps.Value.GRIDM, 1, WandScreen.this.wand_item.limit);
                WandsModClient.send_wand(WandScreen.this.wand_stack);
            }

            @Override
            public void onDec(int mx, int my, int value) {
                WandProps.decVal(WandScreen.this.wand_stack, WandProps.Value.GRIDM, 1);
                WandsModClient.send_wand(WandScreen.this.wand_stack);
            }
        };
        this.grid_m_spn.label_side = true;
        this.wdgets.add(this.grid_m_spn);
        this.grid_n_spn = new Spinner(WandProps.getVal(this.wand_stack, WandProps.Value.GRIDN), 1, this.wand_item.limit, this.left + 215, this.bottom + 25, 25, 14, (Component)Compat.literal("x")){

            @Override
            public void onInc(int mx, int my, int value) {
                WandProps.incGrid(WandScreen.this.wand_stack, WandProps.Value.GRIDN, 1, WandScreen.this.wand_item.limit);
                WandsModClient.send_wand(WandScreen.this.wand_stack);
            }

            @Override
            public void onDec(int mx, int my, int value) {
                WandProps.decVal(WandScreen.this.wand_stack, WandProps.Value.GRIDN, 1);
                WandsModClient.send_wand(WandScreen.this.wand_stack);
            }
        };
        this.grid_n_spn.label_side = true;
        this.wdgets.add(this.grid_n_spn);
        this.grid_mskp_spn = this.valSpinner(WandProps.Value.GRIDMS, this.left + 180, this.bottom + 40, 25, 14, (Component)Compat.translatable("screen.wands.grid_mxn_skip"));
        this.grid_mskp_spn.label_side = true;
        this.wdgets.add(this.grid_mskp_spn);
        this.grid_nskp_spn = this.valSpinner(WandProps.Value.GRIDNS, this.left + 215, this.bottom + 40, 25, 14, (Component)Compat.literal(","));
        this.grid_nskp_spn.label_side = true;
        this.wdgets.add(this.grid_nskp_spn);
        this.grid_moff_spn = this.valSpinner(WandProps.Value.GRIDMOFF, this.left + 180, this.bottom + 55, 25, 14, (Component)Compat.translatable("screen.wands.grid_offset"));
        this.grid_moff_spn.label_side = true;
        this.wdgets.add(this.grid_moff_spn);
        this.grid_noff_spn = this.valSpinner(WandProps.Value.GRIDNOFF, this.left + 215, this.bottom + 55, 25, 14, (Component)Compat.literal(","));
        this.grid_noff_spn.label_side = true;
        this.wdgets.add(this.grid_noff_spn);
        this.arealim_spn = this.valSpinner(WandProps.Value.AREALIM, this.left + 170, this.bottom + 50, 50, 14, (Component)Compat.translatable("screen.wands.limit"));
        this.arealim_spn.label_side = true;
        this.wdgets.add(this.arealim_spn);
        this.tunnel_w = this.valSpinner(WandProps.Value.TUNNEL_W, this.left + 190, this.bottom + 25, 50, 14, (Component)Compat.translatable("screen.wands.tunnel_w"));
        this.tunnel_w.label_side = true;
        this.wdgets.add(this.tunnel_w);
        this.tunnel_h = this.valSpinner(WandProps.Value.TUNNEL_H, this.left + 190, this.bottom + 40, 50, 14, (Component)Compat.translatable("screen.wands.tunnel_h"));
        this.tunnel_h.label_side = true;
        this.wdgets.add(this.tunnel_h);
        this.tunnel_d = this.valSpinner(WandProps.Value.TUNNEL_DEPTH, this.left + 190, this.bottom + 55, 50, 14, (Component)Compat.translatable("screen.wands.tunnel_depth"));
        this.tunnel_d.label_side = true;
        this.wdgets.add(this.tunnel_d);
        this.tunnel_ox = this.valSpinner(WandProps.Value.TUNNEL_OX, this.left + 190, this.bottom + 70, 50, 14, (Component)Compat.translatable("screen.wands.tunnel_ox"));
        this.tunnel_ox.label_side = true;
        this.wdgets.add(this.tunnel_ox);
        this.tunnel_oy = this.valSpinner(WandProps.Value.TUNNEL_OY, this.left + 190, this.bottom + 85, 50, 14, (Component)Compat.translatable("screen.wands.tunnel_oy"));
        this.tunnel_oy.label_side = true;
        this.wdgets.add(this.tunnel_oy);
        this.modes_grp = new Select(this.left + 80, this.bottom - 20, btn_w, btn_h, (Component)Compat.translatable("screen.wands.mode"));
        int l = WandProps.modes.length - 1;
        if (this.wand_item.can_blast) {
            ++l;
        }
        for (i = 0; i < l; ++i) {
            final int finalI = i;
            b = new Btn((Component)Compat.translatable(WandProps.modes[i].toString())){

                @Override
                public void onClick(int mx, int my) {
                    WandProps.setMode(WandScreen.this.wand_stack, WandProps.modes[finalI]);
                    WandsModClient.send_wand(WandScreen.this.wand_stack);
                }
            };
            this.modes_grp.add(b);
        }
        this.wdgets.add(this.modes_grp);
        this.action_grp = new Select(this.left + 10, this.bottom - 20, btn_w, btn_h, (Component)Compat.translatable("screen.wands.action"));
        for (i = 0; i < WandProps.actions.length; ++i) {
            finalp = i;
            b = new Btn((Component)Compat.translatable(WandProps.actions[i].toString())){

                @Override
                public void onClick(int mx, int my) {
                    WandProps.setAction(WandScreen.this.wand_stack, WandProps.actions[finalp]);
                    WandsModClient.send_wand(WandScreen.this.wand_stack);
                }
            };
            if ((WandProps.actions[i] == WandProps.Action.DESTROY || WandProps.actions[i] == WandProps.Action.REPLACE) && WandsMod.config.disable_destroy_replace) {
                b.disabled = true;
            }
            this.action_grp.add(b);
        }
        this.wdgets.add(this.action_grp);
        this.orientation_grp = new Select(this.left + 170, this.bottom + 30, btn_w, btn_h, (Component)Compat.translatable("screen.wands.orientation"));
        for (i = 0; i < WandProps.orientations.length; ++i) {
            final int finalo = i;
            b = new Btn((Component)Compat.translatable(WandProps.orientations[i].toString())){

                @Override
                public void onClick(int mx, int my) {
                    WandProps.setOrientation(WandScreen.this.wand_stack, WandProps.orientations[finalo]);
                    WandsModClient.send_wand(WandScreen.this.wand_stack);
                }
            };
            this.orientation_grp.add(b);
        }
        this.wdgets.add(this.orientation_grp);
        this.plane_grp = new Select(this.left + 170, this.bottom + 30, btn_w, btn_h, (Component)Compat.translatable("screen.wands.plane"));
        for (i = 0; i < WandProps.planes.length; ++i) {
            finalp = i;
            b = new Btn((Component)Compat.literal(WandProps.planes[i].toString())){

                @Override
                public void onClick(int mx, int my) {
                    WandProps.setPlane(WandScreen.this.wand_stack, WandProps.planes[finalp]);
                    WandsModClient.send_wand(WandScreen.this.wand_stack);
                }
            };
            this.plane_grp.add(b);
        }
        this.wdgets.add(this.plane_grp);
        this.axis_grp = new Select(this.left + 10, this.bottom + 114, btn_w, btn_h, (Component)Compat.translatable("screen.wands.axis"));
        for (i = 0; i < WandProps.axes.length; ++i) {
            final int finala = i;
            b = new Btn((Component)Compat.literal(WandProps.axes[i].toString())){

                @Override
                public void onClick(int mx, int my) {
                    WandProps.setAxis(WandScreen.this.wand_stack, WandProps.axes[finala]);
                    WandsModClient.send_wand(WandScreen.this.wand_stack);
                }
            };
            this.axis_grp.add(b);
        }
        this.wdgets.add(this.axis_grp);
        this.drop_pos_sel = new Select(this.left + 80, this.bottom + 175, btn_w + 20, btn_h, null);
        this.drop_pos_sel.add(new Btn((Component)Compat.translatable("screen.wands.drop_pos.player"), (mx, my) -> {
            ClientRender.wand.drop_on_player = true;
            NetworkManager.sendToServer((CustomPacketPayload)new Networking.GlobalSettingsPacket(true));
        }));
        this.drop_pos_sel.add(new Btn((Component)Compat.translatable("screen.wands.drop_pos.block"), (mx, my) -> {
            ClientRender.wand.drop_on_player = false;
            NetworkManager.sendToServer((CustomPacketPayload)new Networking.GlobalSettingsPacket(false));
        }));
        this.wdgets.add(this.drop_pos_sel);
        this.mirror_axis = new Select(this.left + 170, this.bottom + 30, btn_w, btn_h, (Component)Compat.translatable("screen.wands.mirror"));
        for (i = 0; i < WandProps.mirrorAxes.length; ++i) {
            final int mo = i;
            b = new Btn((Component)Compat.literal(WandProps.mirrorAxes[i].toString())){

                @Override
                public void onClick(int mx, int my) {
                    WandProps.setVal(WandScreen.this.wand_stack, WandProps.Value.MIRRORAXIS, mo);
                    WandsModClient.send_wand(WandScreen.this.wand_stack);
                }
            };
            this.mirror_axis.add(b);
        }
        this.wdgets.add(this.mirror_axis);
        this.state_grp = new Select(this.left + 80, this.bottom + 140, btn_w + 20, btn_h, null);
        Btn b1 = new Btn((Component)Compat.translatable("screen.wands.use_same_state")){

            @Override
            public void onClick(int mx, int my) {
                WandProps.setStateMode(WandScreen.this.wand_stack, WandProps.StateMode.CLONE);
                WandsModClient.send_wand(WandScreen.this.wand_stack);
            }
        };
        this.state_grp.add(b1);
        Btn b2 = new Btn((Component)Compat.translatable("screen.wands.apply_rot")){

            @Override
            public void onClick(int mx, int my) {
                WandProps.setStateMode(WandScreen.this.wand_stack, WandProps.StateMode.APPLY);
                WandsModClient.send_wand(WandScreen.this.wand_stack);
            }
        };
        this.state_grp.add(b2);
        Btn b3 = new Btn((Component)Compat.translatable("screen.wands.target")){

            @Override
            public void onClick(int mx, int my) {
                WandProps.setStateMode(WandScreen.this.wand_stack, WandProps.StateMode.TARGET);
                WandsModClient.send_wand(WandScreen.this.wand_stack);
            }
        };
        this.state_grp.add(b3);
        this.wdgets.add(this.state_grp);
        this.rot_grp = new Select(this.left + 10, this.bottom + 60, btn_w, btn_h, (Component)Compat.translatable("screen.wands.rotation"));
        for (int i2 = 0; i2 < WandProps.rotations.length; ++i2) {
            final int finalr = i2;
            String rot = "";
            switch (WandProps.rotations[i2]) {
                case NONE: {
                    rot = "0\u00b0";
                    break;
                }
                case CLOCKWISE_90: {
                    rot = "90\u00b0";
                    break;
                }
                case CLOCKWISE_180: {
                    rot = "180\u00b0";
                    break;
                }
                case COUNTERCLOCKWISE_90: {
                    rot = "270\u00b0";
                }
            }
            Btn b4 = new Btn((Component)Compat.literal(rot)){

                @Override
                public void onClick(int mx, int my) {
                    WandProps.setRotation(WandScreen.this.wand_stack, WandProps.rotations[finalr]);
                    WandsModClient.send_wand(WandScreen.this.wand_stack);
                }
            };
            this.rot_grp.add(b4);
        }
        this.wdgets.add(this.rot_grp);
        this.show_inv_btn = new Btn(this.right - 80, this.bottom, 30, 12, (Component)Compat.translatable("screen.wands.tools")){

            @Override
            public void onClick(int mx, int my) {
                WandScreen.this.show_inv = !WandScreen.this.show_inv;
            }
        };
        this.wdgets.add(this.show_inv_btn);
        this.match_state_sel = new Select(this.left + 170, this.bottom + 110, 70, 12, null);
        Btn match_state_btn = new Btn((Component)Compat.translatable("screen.wands.match_state")){

            @Override
            public void onClick(int mx, int my) {
                WandProps.toggleFlag(WandScreen.this.wand_stack, WandProps.Flag.MATCHSTATE);
                WandsModClient.send_wand(WandScreen.this.wand_stack);
            }
        };
        this.match_state_sel.add(match_state_btn);
        this.wdgets.add(this.match_state_sel);
        this.inc_sel_grp_btn = new Select(this.left + 170, this.bottom + 122, 70, 12, null);
        Btn inc_sel_btn = new Btn((Component)Compat.translatable("screen.wands.inc_sel")){

            @Override
            public void onClick(int mx, int my) {
                WandProps.toggleFlag(WandScreen.this.wand_stack, WandProps.Flag.INCSELBLOCK);
                WandsModClient.send_wand(WandScreen.this.wand_stack);
            }
        };
        this.inc_sel_grp_btn.add(inc_sel_btn);
        this.wdgets.add(this.inc_sel_grp_btn);
        this.slab_grp_btn = new Select(this.left + 170, this.bottom + 134, 70, 12, null);
        Btn slab_btn = new Btn((Component)Compat.translatable("screen.wands.slab")){

            @Override
            public void onClick(int mx, int my) {
                WandProps.toggleFlag(WandScreen.this.wand_stack, WandProps.Flag.STAIRSLAB);
                WandsModClient.send_wand(WandScreen.this.wand_stack);
            }
        };
        this.slab_grp_btn.add(slab_btn);
        this.wdgets.add(this.slab_grp_btn);
        this.inv_grp_btn = new Select(this.left + 170, this.bottom + 146, 70, 12, null);
        Btn inv_btn = new Btn((Component)Compat.translatable("screen.wands.invert")){

            @Override
            public void onClick(int mx, int my) {
                WandProps.toggleFlag(WandScreen.this.wand_stack, WandProps.Flag.INVERTED);
                WandsModClient.send_wand(WandScreen.this.wand_stack);
            }
        };
        this.inv_grp_btn.add(inv_btn);
        this.wdgets.add(this.inv_grp_btn);
        this.target_air_grp_btn = new Select(this.left + 170, this.bottom + 158, 70, 12, null);
        Btn target_air_btn = new Btn((Component)Compat.translatable("screen.wands.target_air")){

            @Override
            public void onClick(int mx, int my) {
                WandProps.toggleFlag(WandScreen.this.wand_stack, WandProps.Flag.TARGET_AIR);
                WandsModClient.send_wand(WandScreen.this.wand_stack);
            }
        };
        this.target_air_grp_btn.add(target_air_btn);
        this.wdgets.add(this.target_air_grp_btn);
        this.target_air_dist_spn = this.valSpinner(WandProps.Value.AIR_TARGET_DISTANCE, this.left + 170, this.bottom + 200, 70, 12, (Component)Compat.translatable("screen.wands.target_air_distance"));
        this.target_air_dist_spn.label_side = true;
        this.wdgets.add(this.target_air_dist_spn);
        this.skip_spn = this.valSpinner(WandProps.Value.SKIPBLOCK, this.left + 215, this.bottom + 180, 25, 14, (Component)Compat.translatable("screen.wands.skip_block"));
        this.skip_spn.label_side = true;
        this.wdgets.add(this.skip_spn);
        this.diag_grp_btn = new Select(this.left + 150, this.bottom + 30, 100, 12, null);
        Btn diag_btn = new Btn((Component)Compat.translatable("screen.wands.diagonal_spread")){

            @Override
            public void onClick(int mx, int my) {
                WandProps.toggleFlag(WandScreen.this.wand_stack, WandProps.Flag.DIAGSPREAD);
                WandsModClient.send_wand(WandScreen.this.wand_stack);
            }
        };
        this.diag_grp_btn.add(diag_btn);
        this.wdgets.add(this.diag_grp_btn);
        this.cfill_grp_btn = new Select(this.left + 170, this.bottom + 80, 60, 12, null);
        Btn fill_btn = new Btn((Component)Compat.translatable("screen.wands.filled_circle")){

            @Override
            public void onClick(int mx, int my) {
                WandProps.toggleFlag(WandScreen.this.wand_stack, WandProps.Flag.CFILLED);
                WandsModClient.send_wand(WandScreen.this.wand_stack);
            }
        };
        this.cfill_grp_btn.add(fill_btn);
        this.wdgets.add(this.cfill_grp_btn);
        this.rfill_grp_btn = new Select(this.left + 170, this.bottom + 30, 60, 12, null);
        Btn fill_btn2 = new Btn((Component)Compat.literal("fill rect")){

            @Override
            public void onClick(int mx, int my) {
                WandProps.toggleFlag(WandScreen.this.wand_stack, WandProps.Flag.RFILLED);
                WandsModClient.send_wand(WandScreen.this.wand_stack);
            }
        };
        this.rfill_grp_btn.add(fill_btn2);
        this.wdgets.add(this.rfill_grp_btn);
        this.even_grp_btn = new Select(this.left + 170, this.bottom + 95, 60, 12, null);
        Btn even_btn = new Btn((Component)Compat.translatable("screen.wands.even_circle")){

            @Override
            public void onClick(int mx, int my) {
                WandProps.toggleFlag(WandScreen.this.wand_stack, WandProps.Flag.EVEN);
                WandsModClient.send_wand(WandScreen.this.wand_stack);
            }
        };
        this.even_grp_btn.add(even_btn);
        this.wdgets.add(this.even_grp_btn);
        if (WandsMod.platform != 2) {
            WandScreen parent = this;
            this.conf_btn = new Btn(this, this.left + 10, this.bottom + 180, 27, 12, (Component)Compat.translatable("screen.wands.conf"), (Screen)parent){
                final /* synthetic */ Screen val$parent;
                {
                    this.val$parent = screen;
                    super(x, y, w, h, text);
                }

                @Override
                public void onClick(int mx, int my) {
                    Minecraft.getInstance().setScreen(WandConfigScreen.create(this.val$parent));
                }
            };
            this.wdgets.add(this.conf_btn);
        }
    }

    void update_selections() {
        if (this.wand_item != null && this.wand_stack != null) {
            this.mirror_axis.selected = WandProps.getVal(this.wand_stack, WandProps.Value.MIRRORAXIS);
            this.mirror_axis.visible = this.modes_grp.selected == WandProps.Mode.PASTE.ordinal();
            this.modes_grp.selected = WandProps.getMode(this.wand_stack).ordinal();
            this.rock_rad_spn.visible = this.modes_grp.selected == WandProps.Mode.ROCK.ordinal();
            this.rock_noise_spn.visible = this.modes_grp.selected == WandProps.Mode.ROCK.ordinal();
            this.mult_spn.visible = this.modes_grp.selected == WandProps.Mode.DIRECTION.ordinal();
            this.action_grp.selected = WandProps.getAction(this.wand_stack).ordinal();
            this.orientation_grp.selected = WandProps.getOrientation(this.wand_stack).ordinal();
            this.orientation_grp.visible = this.modes_grp.selected == WandProps.Mode.ROW_COL.ordinal();
            this.row_col_spn.visible = this.modes_grp.selected == WandProps.Mode.ROW_COL.ordinal();
            this.arealim_spn.visible = this.modes_grp.selected == WandProps.Mode.AREA.ordinal() || this.modes_grp.selected == WandProps.Mode.VEIN.ordinal();
            this.plane_grp.selected = WandProps.getPlane(this.wand_stack).ordinal();
            this.plane_grp.visible = this.modes_grp.selected == WandProps.Mode.CIRCLE.ordinal();
            this.axis_grp.selected = WandProps.getAxis(this.wand_stack).ordinal();
            this.state_grp.selected = WandProps.getStateMode(this.wand_stack).ordinal();
            this.rot_grp.selected = WandProps.getRotation(this.wand_stack).ordinal();
            this.inv_grp_btn.selected = WandProps.getFlag(this.wand_stack, WandProps.Flag.INVERTED) ? 0 : -1;
            this.inc_sel_grp_btn.selected = WandProps.getFlag(this.wand_stack, WandProps.Flag.INCSELBLOCK) ? 0 : -1;
            this.cfill_grp_btn.selected = WandProps.getFlag(this.wand_stack, WandProps.Flag.CFILLED) ? 0 : -1;
            this.cfill_grp_btn.visible = this.modes_grp.selected == WandProps.Mode.CIRCLE.ordinal();
            this.rfill_grp_btn.selected = WandProps.getFlag(this.wand_stack, WandProps.Flag.RFILLED) ? 0 : -1;
            this.rfill_grp_btn.visible = this.modes_grp.selected == WandProps.Mode.FILL.ordinal();
            this.even_grp_btn.selected = WandProps.getFlag(this.wand_stack, WandProps.Flag.EVEN) ? 0 : -1;
            this.even_grp_btn.visible = this.modes_grp.selected == WandProps.Mode.CIRCLE.ordinal();
            this.grid_n_spn.visible = this.modes_grp.selected == WandProps.Mode.GRID.ordinal();
            this.grid_m_spn.visible = this.modes_grp.selected == WandProps.Mode.GRID.ordinal();
            this.grid_moff_spn.visible = this.modes_grp.selected == WandProps.Mode.GRID.ordinal();
            this.grid_noff_spn.visible = this.modes_grp.selected == WandProps.Mode.GRID.ordinal();
            this.grid_mskp_spn.visible = this.modes_grp.selected == WandProps.Mode.GRID.ordinal();
            this.grid_nskp_spn.visible = this.modes_grp.selected == WandProps.Mode.GRID.ordinal();
            this.blast_radius_spn.visible = this.modes_grp.selected == WandProps.Mode.BLAST.ordinal();
            this.slab_grp_btn.selected = WandProps.getFlag(this.wand_stack, WandProps.Flag.STAIRSLAB) ? 0 : -1;
            this.diag_grp_btn.visible = this.modes_grp.selected == WandProps.Mode.AREA.ordinal();
            this.diag_grp_btn.selected = !WandProps.getFlag(this.wand_stack, WandProps.Flag.DIAGSPREAD) ? 0 : -1;
            this.match_state_sel.selected = WandProps.getFlag(this.wand_stack, WandProps.Flag.MATCHSTATE) ? 0 : -1;
            this.target_air_grp_btn.selected = WandProps.getFlag(this.wand_stack, WandProps.Flag.TARGET_AIR) ? 0 : -1;
            this.drop_pos_sel.selected = ClientRender.wand.drop_on_player ? 0 : 1;
            this.tunnel_w.visible = this.modes_grp.selected == WandProps.Mode.TUNNEL.ordinal();
            this.tunnel_h.visible = this.modes_grp.selected == WandProps.Mode.TUNNEL.ordinal();
            this.tunnel_d.visible = this.modes_grp.selected == WandProps.Mode.TUNNEL.ordinal();
            this.tunnel_ox.visible = this.modes_grp.selected == WandProps.Mode.TUNNEL.ordinal();
            this.tunnel_oy.visible = this.modes_grp.selected == WandProps.Mode.TUNNEL.ordinal();
        }
    }

    public void render(GuiGraphics gui, int mouseX, int mouseY, float delta) {
        RenderSystem.setShaderTexture((int)0, (GpuTextureView)this.wand_bg_Texture);
        int x = (this.width - 256) / 2 - this.xoff;
        int y = (this.height - 256) / 2 - this.yoff;
        if (this.show_inv) {
            RenderSystem.setShaderTexture((int)0, (GpuTextureView)this.wand_inv_Texture);
            x = (this.width - this.imageWidth) / 2;
            y = (this.height - this.imageHeight) / 2;
            gui.blit(RenderPipelines.GUI_TEXTURED, INV_TEX, x, y, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 256, 256);
            super.render(gui, mouseX, mouseY, delta);
            if (ClientRender.wand != null && ClientRender.wand.player_data != null && ClientRender.wand.player_data.getIntArray("Tools").isPresent()) {
                for (int tool : (int[])ClientRender.wand.player_data.getIntArray("Tools").get()) {
                    Slot slot = (Slot)((WandMenu)this.menu).slots.get(tool);
                    gui.blitSprite(RenderPipelines.GUI_TEXTURED, SLOT_HIGHLIGHT_BACK_SPRITE, slot.x + this.leftPos - 4, slot.y + this.topPos - 4, 24, 24);
                }
            }
            gui.drawString(this.font, "click on any slot to recover all stored items from previous version", this.leftPos + 5, this.topPos + 15, -1);
            gui.drawString(this.font, "click on a player inventory slot", this.leftPos + 3, this.topPos + 50, -1);
            gui.drawString(this.font, "to mark it to be used by the wand", this.leftPos + 3, this.topPos + 62, -1);
            this.show_inv_btn.render(gui, this.font, mouseX, mouseY);
        } else {
            gui.blit(RenderPipelines.GUI_TEXTURED, BG_TEX, x, y, 0.0f, 0.0f, 256, 256, 256, 256);
            this.update_selections();
            for (Wdgt wdget : this.wdgets) {
                if (!wdget.visible) continue;
                wdget.render(gui, this.font, mouseX, mouseY);
            }
            x = (this.width - 256) / 2 + 48 - this.xoff;
            y = (this.height - 256) / 2 + 22 - this.yoff;
            for (int i = 0; i < 9; ++i) {
                Slot s = (Slot)((WandMenu)this.menu).slots.get(36 + i);
                int xx = x + i * 18;
                gui.renderFakeItem(s.getItem(), xx, y);
                gui.renderItemDecorations(this.font, s.getItem(), xx, y);
                if (mouseX <= xx || mouseX >= xx + 16 || mouseY <= y || mouseY >= y + 16) continue;
                this.hoveredSlot = s;
            }
            if (this.modes_grp.selected == WandProps.Mode.ROCK.ordinal()) {
                gui.drawString(this.font, this.rock_msg, this.leftPos + 103, this.topPos + 62, 0xFF0000);
            }
        }
        this.renderTooltip(gui, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics gui, float f, int i, int j) {
    }

    public boolean mouseClicked(MouseButtonEvent mouseButtonEvent, boolean bl) {
        if (!this.show_inv) {
            for (Wdgt wdget : this.wdgets) {
                wdget.click((int)mouseButtonEvent.x(), (int)mouseButtonEvent.y());
            }
        } else {
            super.mouseClicked(mouseButtonEvent, bl);
            this.show_inv_btn.click((int)mouseButtonEvent.x(), (int)mouseButtonEvent.y());
        }
        return true;
    }

    public boolean keyPressed(KeyEvent keyEvent) {
        int i = keyEvent.scancode();
        if (WandsModClient.wand_menu_km.matches(keyEvent) || i == 256) {
            if (this.show_inv) {
                this.show_inv = false;
            } else {
                this.onClose();
            }
            return true;
        }
        return super.keyPressed(keyEvent);
    }
}

