/*
 * Decompiled with CFR 0.152.
 */
package net.nicguzzo.wands.items;

import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.nicguzzo.wands.utils.Compat;
import net.nicguzzo.wands.utils.WandUtils;

public class PaletteItem
extends Item {
    public static Component mode_val_random = Compat.translatable("item.wands.random");
    public static Component mode_val_gradient = Compat.translatable("item.wands.gradient");
    public static Component mode_val_rr = Compat.translatable("item.wands.round_robin");

    public PaletteItem(Item.Properties properties) {
        super(properties);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext tooltipContext, List<Component> list, TooltipFlag tooltipFlag) {
        CompoundTag tag = Compat.getTags(stack);
        Optional inventory = tag.getList("Palette");
        if (inventory.isPresent()) {
            int s = ((ListTag)inventory.get()).size();
            for (int i = 0; i < s; ++i) {
                Optional<ItemStack> is2;
                ItemStack stack2 = ItemStack.EMPTY;
                ClientLevel level = Minecraft.getInstance().level;
                Optional block_ct = tag.getCompound("Block");
                if (level != null && block_ct.isPresent() && (is2 = WandUtils.ItemStack_read((CompoundTag)block_ct.get(), (HolderLookup.Provider)level.registryAccess())).isPresent()) {
                    stack2 = is2.get();
                }
                if (stack2.isEmpty()) continue;
                list.add((Component)Component.translatable((String)stack2.getItem().getDescriptionId()).withStyle(ChatFormatting.GREEN));
            }
        }
        PaletteMode mode = PaletteItem.getMode(stack);
        MutableComponent mode_val = null;
        switch (mode.ordinal()) {
            case 0: {
                mode_val = Compat.literal("mode: " + mode_val_random.getString());
                break;
            }
            case 1: {
                mode_val = Compat.literal("mode: " + mode_val_rr.getString());
                break;
            }
            case 2: {
                mode_val = Compat.literal("mode: " + mode_val_gradient.getString());
            }
        }
        if (mode_val != null) {
            list.add((Component)mode_val);
        }
        list.add((Component)Compat.literal("rotate: " + (tag.getBoolean("rotate").orElse(false) != false ? "on" : "off")));
    }

    public static PaletteMode getMode(ItemStack stack) {
        CompoundTag tag;
        int mode;
        if (stack != null && !stack.isEmpty() && (mode = (tag = Compat.getTags(stack)).getInt("mode").orElse(0).intValue()) < PaletteMode.values().length) {
            return PaletteMode.values()[mode];
        }
        return PaletteMode.RANDOM;
    }

    public static boolean getRotate(ItemStack stack) {
        if (stack != null && !stack.isEmpty()) {
            CompoundTag tag = Compat.getTags(stack);
            return tag.getBoolean("rotate").orElse(false);
        }
        return false;
    }

    public static int getGradientHeight(ItemStack stack) {
        int v = 0;
        if (stack != null && !stack.isEmpty()) {
            CompoundTag tag = Compat.getTags(stack);
            v = tag.getInt("gradient_height").orElse(6);
        }
        if (v == 0) {
            return 6;
        }
        return v;
    }

    public static void setGradientHeight(ItemStack stack, int height) {
        if (stack != null && !stack.isEmpty()) {
            CompoundTag tag = Compat.getTags(stack);
            if (height > 0) {
                tag.putInt("gradient_height", height);
            } else {
                tag.putInt("gradient_height", 1);
            }
            CustomData.set((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)stack, (CompoundTag)tag);
        }
    }

    public static void toggleRotate(ItemStack stack) {
        if (stack != null && !stack.isEmpty()) {
            CompoundTag tag;
            boolean rotate = (tag = Compat.getTags(stack)).getBoolean("rotate").orElse(false);
            tag.putBoolean("rotate", !rotate);
            CustomData.set((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)stack, (CompoundTag)tag);
        }
    }

    public static void nextMode(ItemStack stack) {
        if (stack != null && !stack.isEmpty()) {
            CompoundTag tag = Compat.getTags(stack);
            int mode = (tag.getInt("mode").orElse(0) + 1) % PaletteMode.values().length;
            tag.putInt("mode", mode);
            CustomData.set((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)stack, (CompoundTag)tag);
        }
    }

    public InteractionResult use(Level world, Player player, InteractionHand interactionHand) {
        ItemStack paletteItemStack = player.getItemInHand(interactionHand);
        ItemStack wand = player.getItemInHand(InteractionHand.MAIN_HAND);
        boolean is_wand = WandUtils.is_wand(wand);
        if (is_wand) {
            return InteractionResult.FAIL;
        }
        if (!world.isClientSide()) {
            Compat.open_menu((ServerPlayer)player, paletteItemStack, 1);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public static SimpleContainer getInventory(ItemStack stack, Level level) {
        SimpleContainer inventory = new SimpleContainer(54);
        if (level == null) {
            return inventory;
        }
        CompoundTag tag = Compat.getTags(stack);
        Optional inventory_tag = tag.getList("Palette");
        if (inventory_tag.isPresent()) {
            RegistryAccess provider = level.registryAccess();
            for (int i = 0; i < ((ListTag)inventory_tag.get()).size(); ++i) {
                Optional<ItemStack> is;
                CompoundTag slot_tag = (CompoundTag)((ListTag)inventory_tag.get()).get(i);
                if (!slot_tag.contains("Slot") || !slot_tag.contains("Block") || !slot_tag.getInt("Slot").isPresent()) continue;
                int slot = (Integer)slot_tag.getInt("Slot").get();
                Tag item_tag = slot_tag.get("Block");
                if (item_tag == null || !(is = WandUtils.ItemStack_read((CompoundTag)item_tag.asCompound().get(), (HolderLookup.Provider)provider)).isPresent()) continue;
                inventory.setItem(slot, is.get());
            }
        }
        return inventory;
    }

    public static void setInventory(ItemStack stack, SimpleContainer inventory, Level level) {
        if (level != null) {
            CompoundTag tag = Compat.getTags(stack);
            ListTag inventory_tag = tag.getList("Palette").orElse(new ListTag());
            inventory_tag.clear();
            for (int i = 0; i < inventory.getContainerSize(); ++i) {
                if (inventory.getItem(i).isEmpty()) continue;
                CompoundTag item_tag = WandUtils.ItemStack_save(inventory.getItem(i), (HolderLookup.Provider)level.registryAccess());
                CompoundTag slot_tag = new CompoundTag();
                slot_tag.putInt("Slot", i);
                slot_tag.put("Block", (Tag)item_tag);
                inventory_tag.add((Object)slot_tag);
            }
            tag.put("Palette", (Tag)inventory_tag);
            CustomData.set((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)stack, (CompoundTag)tag);
        }
    }

    public static enum PaletteMode {
        RANDOM,
        ROUND_ROBIN,
        GRADIENT;

    }
}

