/*
 * Decompiled with CFR 0.152.
 */
package net.nicguzzo.wands.items;

import dev.architectury.networking.NetworkManager;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.nicguzzo.wands.client.render.ClientRender;
import net.nicguzzo.wands.networking.Networking;
import net.nicguzzo.wands.utils.Compat;
import net.nicguzzo.wands.wand.Wand;
import net.nicguzzo.wands.wand.WandProps;
import org.jetbrains.annotations.NotNull;

public class WandItem
extends Item {
    public WandTier tier;
    public int limit;
    public boolean can_blast;
    public boolean unbreakable;
    public boolean removes_water;
    public boolean removes_lava;

    public WandItem(WandTier tier, int limit, boolean removes_water, boolean removes_lava, boolean unbreakable, boolean can_blast, Item.Properties properties) {
        super(properties);
        this.tier = tier;
        this.limit = limit;
        this.removes_lava = removes_lava;
        this.removes_water = removes_water;
        this.unbreakable = unbreakable;
        this.can_blast = can_blast;
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        Level world = context.getLevel();
        if (!world.isClientSide()) {
            return InteractionResult.FAIL;
        }
        Player player = context.getPlayer();
        if (player == null) {
            return InteractionResult.FAIL;
        }
        ItemStack stack = player.getMainHandItem();
        if (stack.isEmpty() || !(stack.getItem() instanceof WandItem)) {
            return InteractionResult.FAIL;
        }
        WandProps.Mode mode = WandProps.getMode(stack);
        BlockPos pos = context.getClickedPos();
        BlockState block_state = world.getBlockState(pos);
        Direction side = context.getClickedFace();
        boolean inc_sel = WandProps.getFlag(stack, WandProps.Flag.INCSELBLOCK);
        if (ClientRender.wand.getP1() == null) {
            ClientRender.wand.setP1(pos);
        } else if (ClientRender.wand.getP2() == null && mode.n_clicks() == 2) {
            ClientRender.wand.setP2(pos);
            if (inc_sel && !block_state.isAir()) {
                ClientRender.wand.setP2(ClientRender.wand.getP2().relative(side, 1));
            }
        }
        if (ClientRender.wand.getP1() != null && mode.n_clicks() == 1 || ClientRender.wand.getP1() != null && ClientRender.wand.getP2() != null && mode.n_clicks() == 2) {
            this.send_placement(side, ClientRender.wand.getP1(), ClientRender.wand.getP2(), context.getClickLocation(), ClientRender.wand.palette.seed);
            ClientRender.wand.palette.seed = System.currentTimeMillis();
            ClientRender.wand.copy();
            ClientRender.wand.clear();
        }
        return InteractionResult.SUCCESS;
    }

    public InteractionResult use(Level world, Player player, InteractionHand interactionHand) {
        if (!world.isClientSide()) {
            return InteractionResult.FAIL;
        }
        ItemStack stack = player.getMainHandItem();
        if (stack.isEmpty() || !(stack.getItem() instanceof WandItem)) {
            return InteractionResult.FAIL;
        }
        Wand wand = ClientRender.wand;
        WandProps.Mode mode = WandProps.getMode(stack);
        if (wand.target_air && mode.can_target_air()) {
            if (wand.getP1() == null) {
                wand.setP1(ClientRender.last_pos);
                wand.setP2(null);
                ClientRender.has_target = true;
            } else {
                if (mode.n_clicks() == 2) {
                    wand.setP2(wand.get_pos_from_air(wand.hit));
                } else {
                    wand.setP2(null);
                }
                this.send_placement(ClientRender.wand.player.getDirection().getOpposite(), wand.getP1(), wand.getP2(), wand.hit, wand.palette.seed);
                wand.palette.seed = System.currentTimeMillis();
                ClientRender.wand.copy();
                ClientRender.wand.clear();
            }
        }
        return InteractionResult.PASS;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void send_placement(Direction side, BlockPos p1, BlockPos p2, Vec3 hit, long seed) {
        BlockPos _p1 = new BlockPos(0, 0, 0);
        BlockPos _p2 = new BlockPos(0, 0, 0);
        int has_p1_p2 = 0;
        if (p1 != null && p2 != null) {
            has_p1_p2 = 3;
            _p1 = p1;
            _p2 = p2;
        } else if (p1 != null) {
            has_p1_p2 = 1;
            _p1 = p1;
        } else if (p2 != null) {
            has_p1_p2 = 2;
            _p2 = p2;
        }
        NetworkManager.sendToServer((CustomPacketPayload)new Networking.PosPacket(side.ordinal(), has_p1_p2, _p1, _p2, new Networking.Vec3d(hit.x, hit.y, hit.z), seed));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext tooltipContext, List<Component> list, TooltipFlag tooltipFlag) {
        CompoundTag tag = Compat.getTags(stack);
        list.add((Component)Compat.literal("mode: ").append((Component)Compat.translatable(WandProps.getMode(stack).toString())));
        list.add((Component)Compat.literal("limit: " + this.limit));
        list.add((Component)Compat.literal("orientation: ").append((Component)Compat.translatable(WandProps.orientations[tag.getInt("orientation").orElse(0)].toString())));
        int a = tag.getInt("axis").orElse(0);
        if (a < WandProps.axes.length) {
            list.add((Component)Compat.literal("axis: " + WandProps.axes[a].toString()));
        } else {
            list.add((Component)Compat.literal("axis: none"));
        }
        list.add((Component)Compat.literal("plane: " + WandProps.Plane.values()[tag.getInt("plane").orElse(0)].toString()));
        list.add((Component)Compat.literal("fill circle: " + String.valueOf(tag.getBoolean("cfill"))));
        list.add((Component)Compat.literal("rotation: " + String.valueOf(tag.getInt("rotation"))));
    }

    public static enum WandTier {
        STONE_WAND,
        COPPER_WAND,
        IRON_WAND,
        DIAMOND_WAND,
        NETHERITE_WAND,
        CREATIVE_WAND;

    }
}

