/*
 * Decompiled with CFR 0.152.
 */
package net.nicguzzo.wands.menues;

import java.util.Iterator;
import java.util.stream.Collectors;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedItemContents;
import net.minecraft.world.inventory.StackedContentsCompatible;
import net.minecraft.world.item.ItemStack;
import net.nicguzzo.wands.items.MagicBagItem;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BagContainer
implements Container,
StackedContentsCompatible {
    private final int size;
    private final NonNullList<ItemStack> items;
    private HolderLookup.Provider ra;
    public ItemStack bag;
    public static final Logger LOGGER = LogManager.getLogger();

    public BagContainer(int i, ItemStack bag, HolderLookup.Provider ra) {
        this.size = i;
        this.ra = ra;
        this.items = NonNullList.withSize((int)i, (Object)ItemStack.EMPTY);
        this.bag = bag;
        this.clearContent();
        ItemStack bag_item = MagicBagItem.getItem(bag, ra);
        if (!bag_item.isEmpty()) {
            this.items.set(0, (Object)MagicBagItem.getItem(bag, ra));
        }
    }

    public ItemStack getItem(int i) {
        return i >= 0 && i < this.items.size() ? (ItemStack)this.items.get(i) : ItemStack.EMPTY;
    }

    public ItemStack removeItem(int i, int j) {
        return ItemStack.EMPTY;
    }

    public boolean canPlaceItem(int i, ItemStack itemStack) {
        return itemStack.isStackable();
    }

    public ItemStack removeItemNoUpdate(int i) {
        return ItemStack.EMPTY;
    }

    public void setItem(int i, ItemStack itemStack) {
        ItemStack bag_item = MagicBagItem.getItem(this.bag, this.ra);
        if (bag_item.isEmpty()) {
            MagicBagItem.setItem(this.bag, itemStack, this.ra);
            ItemStack item2 = itemStack.copy();
            item2.setCount(1);
            this.items.set(i, (Object)item2);
        }
    }

    public int getContainerSize() {
        return this.size;
    }

    public boolean isEmpty() {
        ItemStack itemStack;
        Iterator var1 = this.items.iterator();
        do {
            if (var1.hasNext()) continue;
            return true;
        } while ((itemStack = (ItemStack)var1.next()).isEmpty());
        return false;
    }

    public void setChanged() {
    }

    public boolean stillValid(Player player) {
        return true;
    }

    public void clearContent() {
        this.items.clear();
        this.setChanged();
    }

    public String toString() {
        return this.items.stream().filter(itemStack -> !itemStack.isEmpty()).collect(Collectors.toList()).toString();
    }

    public void fillStackedContents(StackedItemContents stackedItemContents) {
        for (ItemStack itemStack : this.items) {
            stackedItemContents.accountStack(itemStack);
        }
    }
}

