/*
 * Decompiled with CFR 0.152.
 */
package net.nicguzzo.wands.menues;

import java.util.Objects;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.nicguzzo.wands.WandsMod;
import net.nicguzzo.wands.items.MagicBagItem;
import net.nicguzzo.wands.menues.BagContainer;
import net.nicguzzo.wands.menues.BagSlot;
import net.nicguzzo.wands.utils.Compat;

public class MagicBagMenu
extends AbstractContainerMenu {
    public ItemStack bag;
    public final Inventory playerInventory;
    private final BagContainer bagcontainer;

    public MagicBagMenu(int syncId, Inventory playerInventory, FriendlyByteBuf packetByteBuf) {
        this(syncId, playerInventory, Objects.requireNonNull(packetByteBuf.readNbt()).read(ItemStack.MAP_CODEC).orElse(ItemStack.EMPTY));
    }

    public MagicBagMenu(int syncId, Inventory playerInventory, ItemStack bag) {
        super((MenuType)WandsMod.MAGIC_WAND_CONTANIER.get(), syncId);
        int o;
        this.playerInventory = playerInventory;
        this.bag = bag;
        this.bagcontainer = new BagContainer(1, bag, (HolderLookup.Provider)playerInventory.player.level().registryAccess());
        int k = 0;
        for (o = 0; o < 9; ++o) {
            this.addSlot(new Slot((Container)playerInventory, k++, 8 + o * 18, 142));
        }
        for (o = 0; o < 3; ++o) {
            for (int n = 0; n < 9; ++n) {
                this.addSlot(new Slot((Container)playerInventory, k++, 8 + n * 18, 84 + o * 18));
            }
        }
        this.addSlot(new BagSlot(this.bagcontainer, 0, 80, 32, bag, (HolderLookup.Provider)playerInventory.player.level().registryAccess()));
    }

    public boolean stillValid(Player player) {
        return this.bag.getItem() instanceof MagicBagItem;
    }

    public ItemStack quickMoveStack(Player player, int index) {
        return ItemStack.EMPTY;
    }

    public void clicked(int slotIndex, int button, ClickType actionType, Player player) {
        block26: {
            try {
                RegistryAccess ra = player.level().registryAccess();
                if (slotIndex == 36) {
                    Slot slot = (Slot)this.slots.get(slotIndex);
                    if (button != 0 && button != 1) break block26;
                    switch (actionType) {
                        case QUICK_CRAFT: 
                        case PICKUP: {
                            ItemStack carried = Compat.get_carried(player, this);
                            if (this.bag != null) {
                                ItemStack itemStack = slot.getItem();
                                ItemStack itemStack2 = itemStack.copy();
                                int total = MagicBagItem.getTotal(this.bag);
                                if (carried.isEmpty()) {
                                    if (total > 0) {
                                        int c = 1;
                                        if (button == 1) {
                                            int m;
                                            c = m = itemStack.getMaxStackSize();
                                            if (total < m) {
                                                c = total;
                                            }
                                        }
                                        itemStack2.setCount(c);
                                        MagicBagItem.dec(this.bag, c);
                                        if (total - c == 0) {
                                            MagicBagItem.setItem(this.bag, ItemStack.EMPTY, (HolderLookup.Provider)ra);
                                            slot.set(ItemStack.EMPTY);
                                        }
                                        Compat.set_carried(player, this, itemStack2);
                                        break;
                                    }
                                    MagicBagItem.setItem(this.bag, ItemStack.EMPTY, (HolderLookup.Provider)ra);
                                    slot.set(ItemStack.EMPTY);
                                    break;
                                }
                                ItemStack bag_item = MagicBagItem.getItem(this.bag, (HolderLookup.Provider)ra);
                                ItemStack itemStack3 = Compat.get_carried(player, this);
                                if (itemStack3.isStackable()) {
                                    if (bag_item.isEmpty()) {
                                        MagicBagItem.setItem(this.bag, itemStack3, (HolderLookup.Provider)ra);
                                        bag_item = itemStack3.copy();
                                        bag_item.setCount(1);
                                    }
                                    if (itemStack3.getItem() == bag_item.getItem()) {
                                        boolean tags_match = true;
                                        if (itemStack3.getTags().findAny().isPresent() || bag_item.getTags().findAny().isPresent()) {
                                            tags_match = itemStack3.getTags().equals(bag_item.getTags());
                                        }
                                        if (tags_match && MagicBagItem.inc(this.bag, itemStack3.getCount())) {
                                            Compat.set_carried(player, this, ItemStack.EMPTY);
                                            break;
                                        }
                                    }
                                }
                            }
                            break block26;
                        }
                        case QUICK_MOVE: {
                            int m;
                            int free_slot = this.playerInventory.getFreeSlot();
                            if (free_slot == -1) break;
                            ItemStack bag_item = MagicBagItem.getItem(this.bag, (HolderLookup.Provider)ra);
                            int total = MagicBagItem.getTotal(this.bag);
                            int c = m = bag_item.getMaxStackSize();
                            if (total < m) {
                                c = total;
                            }
                            MagicBagItem.dec(this.bag, c);
                            ItemStack item = bag_item.copy();
                            item.setCount(c);
                            this.playerInventory.setItem(free_slot, item);
                        }
                    }
                    break block26;
                }
                if (actionType == ClickType.QUICK_MOVE && slotIndex < this.slots.size()) {
                    Slot slot_src = (Slot)this.slots.get(slotIndex);
                    Slot slot_dst = (Slot)this.slots.get(36);
                    ItemStack item_src = slot_src.getItem().copy();
                    if (item_src.isStackable()) {
                        if (slot_dst.hasItem()) {
                            ItemStack item_dst = slot_dst.getItem();
                            if (item_src.getItem() == item_dst.getItem() && MagicBagItem.inc(this.bag, item_src.getCount())) {
                                slot_src.set(ItemStack.EMPTY);
                            }
                        } else {
                            MagicBagItem.setItem(this.bag, item_src, (HolderLookup.Provider)ra);
                            if (MagicBagItem.inc(this.bag, item_src.getCount())) {
                                slot_src.set(ItemStack.EMPTY);
                            }
                        }
                    }
                } else {
                    super.clicked(slotIndex, button, actionType, player);
                }
            }
            catch (Exception var8) {
                CrashReport crashReport = CrashReport.forThrowable((Throwable)var8, (String)"Container click");
                CrashReportCategory crashReportCategory = crashReport.addCategory("Click info");
                crashReportCategory.setDetail("Menu Type", () -> this.getType() != null ? BuiltInRegistries.MENU.getKey((Object)this.getType()).toString() : "<no type>");
                crashReportCategory.setDetail("Menu Class", () -> ((Object)((Object)this)).getClass().getCanonicalName());
                crashReportCategory.setDetail("Slot Count", (Object)this.slots.size());
                crashReportCategory.setDetail("Slot", (Object)slotIndex);
                crashReportCategory.setDetail("Button", (Object)button);
                crashReportCategory.setDetail("Type", (Object)actionType);
                throw new ReportedException(crashReport);
            }
        }
    }
}

