/*
 * Decompiled with CFR 0.152.
 */
package net.nicguzzo.wands.menues;

import dev.architectury.networking.NetworkManager;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.stream.IntStream;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.component.CustomData;
import net.nicguzzo.wands.WandsMod;
import net.nicguzzo.wands.items.WandItem;
import net.nicguzzo.wands.networking.Networking;
import net.nicguzzo.wands.utils.Compat;
import net.nicguzzo.wands.wand.PlayerWand;
import net.nicguzzo.wands.wand.Wand;
import org.apache.commons.lang3.ArrayUtils;

public class WandMenu
extends AbstractContainerMenu {
    public ItemStack wand;
    public final Inventory playerInventory;
    private final SimpleContainer simplecontainer;

    public WandMenu(int syncId, Inventory playerInventory, FriendlyByteBuf buf) {
        this(syncId, playerInventory, Objects.requireNonNull(buf.readNbt()).read(ItemStack.MAP_CODEC).orElse(ItemStack.EMPTY));
    }

    public WandMenu(int syncId, Inventory playerInventory, ItemStack _wand) {
        super((MenuType)WandsMod.WAND_CONTAINER.get(), syncId);
        int o;
        this.wand = _wand;
        this.playerInventory = playerInventory;
        this.simplecontainer = new SimpleContainer(this, 9){

            public void setChanged() {
                super.setChanged();
            }
        };
        int k = 0;
        for (o = 0; o < 9; ++o) {
            this.addSlot(new Slot((Container)playerInventory, k++, 8 + o * 18, 142));
        }
        for (o = 0; o < 3; ++o) {
            for (int n = 0; n < 9; ++n) {
                this.addSlot(new Slot((Container)playerInventory, k++, 8 + n * 18, 84 + o * 18));
            }
        }
        for (o = 0; o < 9; ++o) {
            this.addSlot(new WandSlot(this, (Container)this.simplecontainer, o, 8 + o * 18, 32));
        }
    }

    public boolean stillValid(Player player) {
        return this.wand.getItem() instanceof WandItem;
    }

    boolean mayPlace(ItemStack itemStack) {
        boolean is_tool = itemStack.get(DataComponents.TOOL) != null;
        return (is_tool || itemStack.getItem() instanceof ShearsItem) && !(itemStack.getItem() instanceof WandItem);
    }

    boolean insert(ItemStack itemStack, int s, int e) {
        return false;
    }

    public ItemStack quickMoveStack(Player player, int index) {
        return ItemStack.EMPTY;
    }

    public void clicked(int slotIndex, int button, ClickType actionType, Player player) {
        try {
            Wand wnd;
            if (player.level().isClientSide()) {
                return;
            }
            if (actionType == ClickType.PICKUP && slotIndex >= 36 && slotIndex < 45 && this.wand != null) {
                int i;
                int n_items = 0;
                for (int i2 = 0; i2 < 9; ++i2) {
                    if (this.simplecontainer.getItem(i2).isEmpty()) continue;
                    ++n_items;
                }
                int inv_free = 0;
                for (i = 0; i < player.getInventory().getContainerSize(); ++i) {
                    if (!player.getInventory().getItem(i).isEmpty()) continue;
                    ++inv_free;
                }
                if (n_items <= inv_free) {
                    for (i = 0; i < 9; ++i) {
                        int free_slot;
                        if (this.simplecontainer.getItem(i).isEmpty() || (free_slot = player.getInventory().getFreeSlot()) == -1) continue;
                        player.getInventory().setItem(free_slot, this.simplecontainer.removeItem(i, 1));
                        CompoundTag tag = Compat.getTags(this.wand);
                        tag.remove("Tools");
                        CustomData.set((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)this.wand, (CompoundTag)tag);
                    }
                } else {
                    player.displayClientMessage((Component)Compat.literal("need " + n_items + " free inventory slots to reclaim items"), false);
                }
            }
            if (actionType == ClickType.PICKUP && slotIndex >= 0 && slotIndex < 36 && this.wand != null && (wnd = PlayerWand.get(player)) != null && wnd.player_data != null) {
                if (button == 0) {
                    Optional a;
                    if (wnd.player_data.get("Tools") == null) {
                        int[] i = new int[]{};
                        wnd.player_data.putIntArray("Tools", i);
                    }
                    if (wnd.player_data.get("Tools") != null && (a = wnd.player_data.getIntArray("Tools")).isPresent()) {
                        IntArrayTag tools = new IntArrayTag((int[])a.get());
                        IntTag it = IntTag.valueOf((int)slotIndex);
                        IntStream oi = Arrays.stream((int[])a.get()).filter(aa -> aa == it.value());
                        OptionalInt tool_slot = oi.findFirst();
                        if (tool_slot.isPresent()) {
                            int idx = ArrayUtils.indexOf((int[])((int[])a.get()), (int)tool_slot.getAsInt());
                            if (idx >= 0 && idx < tools.size()) {
                                tools.remove(idx);
                            }
                        } else {
                            tools.addTag(tools.size(), (Tag)it);
                        }
                        wnd.player_data.put("Tools", (Tag)tools);
                    }
                }
                if (button == 1) {
                    // empty if block
                }
                NetworkManager.sendToPlayer((ServerPlayer)((ServerPlayer)player), (CustomPacketPayload)new Networking.PlayerDataPacket(wnd.player_data));
            }
        }
        catch (Exception var8) {
            CrashReport crashReport = CrashReport.forThrowable((Throwable)var8, (String)"Container click");
            CrashReportCategory crashReportCategory = crashReport.addCategory("Click info");
            crashReportCategory.setDetail("Menu Type", () -> this.getType() != null ? BuiltInRegistries.MENU.getKey((Object)this.getType()).toString() : "<no type>");
            crashReportCategory.setDetail("Menu Class", () -> ((Object)((Object)this)).getClass().getCanonicalName());
            crashReportCategory.setDetail("Slot Count", (Object)this.slots.size());
            crashReportCategory.setDetail("Slot", (Object)slotIndex);
            crashReportCategory.setDetail("Button", (Object)button);
            crashReportCategory.setDetail("Type", (Object)actionType);
            throw new ReportedException(crashReport);
        }
    }

    class WandSlot
    extends Slot {
        public WandSlot(WandMenu this$0, Container container, int i, int j, int k) {
            super(container, i, j, k);
        }

        public boolean mayPlace(ItemStack itemStack) {
            boolean is_tool = itemStack.get(DataComponents.TOOL) != null;
            return (is_tool || itemStack.getItem() instanceof ShearsItem) && !(itemStack.getItem() instanceof WandItem);
        }
    }
}

