/*
 * Decompiled with CFR 0.152.
 */
package net.nicguzzo.wands.mixin;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.nicguzzo.wands.items.MagicBagItem;
import net.nicguzzo.wands.utils.WandUtils;
import org.joml.Matrix3x2fStack;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={GuiGraphics.class})
public abstract class ItemRendererMixin {
    @Final
    @Shadow
    private Matrix3x2fStack pose;

    @Shadow
    protected abstract void renderItem(LivingEntity var1, Level var2, ItemStack var3, int var4, int var5, int var6);

    @Inject(method={"renderItem(Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/level/Level;Lnet/minecraft/world/item/ItemStack;III)V"}, at={@At(value="TAIL")})
    public void renderItem(LivingEntity livingEntity, Level level, ItemStack itemStack, int i, int j, int k, CallbackInfo cb) {
        ItemStack item_in_bag;
        if (level != null && WandUtils.is_magicbag(itemStack) && !(item_in_bag = MagicBagItem.getItem(itemStack, (HolderLookup.Provider)level.registryAccess())).isEmpty() && itemStack.get(DataComponents.ITEM_MODEL) != null) {
            this.pose.pushMatrix();
            this.pose.translate((float)(i + 8), (float)(j + 8));
            this.pose.scale(0.5f, 0.5f);
            this.pose.translate(0.0f, -0.3f);
            this.pose.translate(-((float)(i + 8)), -((float)(j + 8)));
            this.renderItem(livingEntity, level, item_in_bag, i, j + 5, k);
            this.pose.popMatrix();
        }
    }
}

