/*
 * Decompiled with CFR 0.152.
 */
package net.nicguzzo.wands.utils;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.state.BlockState;

public class CircularBuffer {
    private int size;
    private P[] elem;
    private int max;
    private int top;
    private int bottom;
    private int last;

    public CircularBuffer(int max) {
        this.max = max;
        this.elem = new P[this.max];
        this.size = 0;
        this.bottom = -1;
        this.top = -1;
        this.last = -1;
    }

    public int size() {
        return this.size;
    }

    public boolean can_go_forward() {
        if (this.top >= this.bottom) {
            return this.top < this.last;
        }
        return this.top > this.last;
    }

    public void put(BlockPos p, BlockState s, boolean d) {
        this.forward();
        if (this.elem[this.top] == null) {
            this.elem[this.top] = new P(this);
        }
        this.elem[this.top].pos.set((Vec3i)p);
        this.elem[this.top].state = s;
        this.elem[this.top].destroyed = d;
    }

    public void forward() {
        this.top = (this.top + 1) % this.max;
        if (this.top > this.last) {
            this.last = this.top;
        }
        if (this.top <= this.bottom) {
            this.bottom = (this.bottom + 1) % this.max;
        }
        if (this.bottom == -1) {
            this.bottom = 0;
        }
        if (this.size < this.max) {
            ++this.size;
        }
    }

    public P peek() {
        if (this.size == 0) {
            return null;
        }
        return this.elem[this.top];
    }

    public P pop() {
        if (this.size == 0) {
            return null;
        }
        P e = this.elem[this.top];
        if (this.size == 1) {
            this.top = -1;
            this.bottom = -1;
            this.size = 0;
        } else {
            this.top = this.top == 0 ? this.max - 1 : Math.abs((this.top - 1) % this.max);
            --this.size;
        }
        return e;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void print() {
        System.out.println("undo buffer");
        for (int i = 0; i < this.last + 1 && i < this.max; ++i) {
            P e = this.elem[i];
            System.out.println("i: " + i + " elem: " + String.valueOf(e.state) + " pos" + String.valueOf(e.pos));
        }
        System.out.println("top: " + this.top);
        System.out.println("bottom: " + this.bottom);
        System.out.println("size: " + this.size);
        System.out.println("last: " + this.last);
    }

    public class P {
        public BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        public BlockState state = null;
        public boolean destroyed = false;

        public P(CircularBuffer this$0) {
        }
    }
}

