/*
 * Decompiled with CFR 0.152.
 */
package net.nicguzzo.wands.utils;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.architectury.event.events.client.ClientGuiEvent;
import dev.architectury.registry.client.keymappings.KeyMappingRegistry;
import dev.architectury.registry.menu.MenuRegistry;
import java.util.NoSuchElementException;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.nicguzzo.wands.client.WandsModClient;
import net.nicguzzo.wands.menues.MagicBagMenu;
import net.nicguzzo.wands.menues.PaletteMenu;
import net.nicguzzo.wands.menues.WandMenu;
import net.nicguzzo.wands.utils.WandUtils;
import org.jetbrains.annotations.NotNull;

public class Compat {
    public static boolean has_mending(ItemStack item, Level l) {
        RegistryAccess ra = l.registryAccess();
        int level = 0;
        try {
            level = ra.lookup(Registries.ENCHANTMENT).map(e -> e.get(Enchantments.MENDING)).orElseThrow().map(e -> EnchantmentHelper.getItemEnchantmentLevel((Holder)e, (ItemStack)item)).orElseThrow();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return level > 0;
    }

    public static int get_fortune_level(ItemStack item, Level l) {
        RegistryAccess ra = l.registryAccess();
        int level = 0;
        try {
            level = ra.lookup(Registries.ENCHANTMENT).map(e -> e.get(Enchantments.FORTUNE)).orElseThrow().map(e -> EnchantmentHelper.getItemEnchantmentLevel((Holder)e, (ItemStack)item)).orElseThrow();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return level;
    }

    public static boolean has_silktouch(ItemStack item, Level l) {
        RegistryAccess ra = l.registryAccess();
        boolean st = false;
        try {
            st = 0 != ra.lookup(Registries.ENCHANTMENT).map(e -> e.get(Enchantments.SILK_TOUCH)).orElseThrow().map(e -> EnchantmentHelper.getItemEnchantmentLevel((Holder)e, (ItemStack)item)).orElseThrow();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return st;
    }

    public static ResourceLocation create_resource(String res) {
        return ResourceLocation.fromNamespaceAndPath((String)"wands", (String)res);
    }

    public static ResourceLocation create_resource_mc(String res) {
        return ResourceLocation.withDefaultNamespace((String)res);
    }

    public static CreativeModeTab create_tab(ResourceLocation res) {
        return null;
    }

    public static boolean is_creative(Player player) {
        return player.getAbilities().instabuild;
    }

    public static Inventory get_inventory(Player player) {
        return player.getInventory();
    }

    public static void open_menu(ServerPlayer player, final ItemStack item, final int m) {
        MenuRegistry.openExtendedMenu((ServerPlayer)player, (MenuProvider)new MenuProvider(){

            @NotNull
            public Component getDisplayName() {
                return Compat.translatable(item.getItem().getDescriptionId());
            }

            public AbstractContainerMenu createMenu(int syncId, Inventory inv, Player player) {
                AbstractContainerMenu menu = null;
                switch (m) {
                    case 0: {
                        menu = new WandMenu(syncId, inv, item);
                        break;
                    }
                    case 1: {
                        menu = new PaletteMenu(syncId, inv, item);
                        break;
                    }
                    case 2: {
                        menu = new MagicBagMenu(syncId, inv, item);
                    }
                }
                return menu;
            }
        }, buf -> {
            ServerLevel level = player.level();
            RegistryAccess provider = level.registryAccess();
            CompoundTag tag = WandUtils.ItemStack_save(item, (HolderLookup.Provider)provider);
            buf.writeNbt((Tag)tag);
        });
    }

    public static void set_carried(Player player, AbstractContainerMenu menu, ItemStack itemStack) {
        menu.setCarried(itemStack);
    }

    public static ItemStack get_carried(Player player, AbstractContainerMenu menu) {
        return menu.getCarried();
    }

    public static void set_identity(PoseStack m) {
        m.setIdentity();
    }

    public static MutableComponent translatable(String key) {
        return Component.translatable((String)key);
    }

    public static MutableComponent literal(String msg) {
        return Component.literal((String)msg);
    }

    public static void register_key(KeyMapping k) {
        KeyMappingRegistry.register((KeyMapping)k);
    }

    public static void render_info() {
        ClientGuiEvent.RENDER_HUD.register((e, d) -> WandsModClient.render_wand_info(e));
    }

    public static BlockPos get_player_pos(Player player) {
        return player.getOnPos();
    }

    public static Vec3 get_player_pos_center(Player player) {
        return player.getOnPos().getCenter();
    }

    public static boolean is_same(ItemStack i1, ItemStack i2) {
        return ItemStack.isSameItem((ItemStack)i2, (ItemStack)i2);
    }

    public static Level player_level(Player player) {
        return player.level();
    }

    public static CompoundTag getTags(ItemStack stack) {
        CustomData data = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
        if (data != null) {
            return data.copyTag();
        }
        return new CompoundTag();
    }

    public static void toast(Toast toast) {
        Minecraft.getInstance().getToastManager().addToast(toast);
    }

    public final class NbtType {
        public static final int END = 0;
        public static final int BYTE = 1;
        public static final int SHORT = 2;
        public static final int INT = 3;
        public static final int LONG = 4;
        public static final int FLOAT = 5;
        public static final int DOUBLE = 6;
        public static final int BYTE_ARRAY = 7;
        public static final int STRING = 8;
        public static final int LIST = 9;
        public static final int COMPOUND = 10;
        public static final int INT_ARRAY = 11;
        public static final int LONG_ARRAY = 12;
        public static final int NUMBER = 99;

        private NbtType(Compat this$0) {
        }
    }
}

