/*
 * Decompiled with CFR 0.152.
 */
package net.nicguzzo.wands.utils;

import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.TagValueOutput;
import net.nicguzzo.wands.items.MagicBagItem;
import net.nicguzzo.wands.items.WandItem;
import net.nicguzzo.wands.mixin.AxeItemAccessor;
import net.nicguzzo.wands.mixin.HoeItemAccessor;
import net.nicguzzo.wands.mixin.ShovelItemAccessor;

public class WandUtils {
    public static boolean is_tillable(BlockState state) {
        return HoeItemAccessor.getTillables().get(state.getBlock()) != null;
    }

    public static boolean is_strippable(BlockState state) {
        return AxeItemAccessor.getStrippables().get(state.getBlock()) != null;
    }

    public static boolean is_flattenable(BlockState state) {
        return ShovelItemAccessor.getFlattenables().get(state.getBlock()) != null;
    }

    public static boolean is_wand(ItemStack stack) {
        return stack != null && !stack.isEmpty() && stack.getItem() instanceof WandItem;
    }

    public static boolean is_shulker(ItemStack item_stack) {
        return Block.byItem((Item)item_stack.getItem()) instanceof ShulkerBoxBlock;
    }

    public static boolean is_magicbag(ItemStack item_stack) {
        return item_stack.getItem() instanceof MagicBagItem;
    }

    public static int count_in_shulker(ItemStack shulker, Item item, HolderLookup.Provider provider) {
        ItemContainerContents contents;
        int n = 0;
        if (item != null && (contents = (ItemContainerContents)shulker.get(DataComponents.CONTAINER)) != null) {
            Iterable shulker_items = contents.nonEmptyItems();
            for (ItemStack s : shulker_items) {
                if (WandUtils.is_magicbag(s)) {
                    int total = MagicBagItem.getTotal(s);
                    ItemStack stack2 = MagicBagItem.getItem(s, provider);
                    if (stack2.isEmpty() || !stack2.is(item) || total <= 0) continue;
                    n += total;
                    continue;
                }
                if (s.isEmpty() || !s.is(item)) continue;
                n += s.getCount();
            }
        }
        return n;
    }

    public static boolean is_plant(BlockState state) {
        return state.getBlock() instanceof BushBlock || state.getBlock() instanceof VineBlock;
    }

    public static double unitCoord(double a) {
        double b = a - (double)((int)a);
        if (b < 0.0) {
            b = 1.0 + b;
        }
        return b;
    }

    public static float calc_xp(int level, float prog) {
        float xp = WandUtils.calc_xp_level(level);
        if (prog > 0.0f) {
            xp += prog * (WandUtils.calc_xp_level(level + 1) - xp);
        }
        return xp;
    }

    public static float calc_xp_level(int level) {
        int level2 = level * level;
        float xp_points = level >= 32 ? 4.5f * (float)level2 - 162.5f * (float)level + 2220.0f : (level >= 17 ? 2.5f * (float)level2 - 40.5f * (float)level + 360.0f : (float)(level2 + 6 * level));
        return xp_points;
    }

    public static int calc_xp_to_next_level(int level) {
        int xp = level >= 32 ? 9 * level - 158 : (level >= 17 ? 5 * level - 38 : 2 * level + 7);
        return xp;
    }

    public static boolean pickaxe_minable(BlockState state) {
        return state.is(BlockTags.MINEABLE_WITH_PICKAXE);
    }

    public static double mapRange(double a1, double a2, double b1, double b2, double s) {
        return b1 + (s - a1) * (b2 - b1) / (a2 - a1);
    }

    public static int mapRange(int a1, int a2, int b1, int b2, int s) {
        int den = a2 - a1;
        if (den == 0) {
            return b1;
        }
        return b1 + (s - a1) * (b2 - b1) / den;
    }

    public static CompoundTag ItemStack_save(ItemStack item, HolderLookup.Provider provider) {
        ProblemReporter.Collector reporter = new ProblemReporter.Collector();
        TagValueOutput tvo = TagValueOutput.createWithContext((ProblemReporter)reporter, (HolderLookup.Provider)provider);
        tvo.store(ItemStack.MAP_CODEC, (Object)item);
        return tvo.buildResult();
    }

    public static Optional<ItemStack> ItemStack_read(CompoundTag item, HolderLookup.Provider provider) {
        ProblemReporter.Collector reporter = new ProblemReporter.Collector();
        TagValueInput tvi = (TagValueInput)TagValueInput.create((ProblemReporter)reporter, (HolderLookup.Provider)provider, (CompoundTag)item);
        return tvi.read(ItemStack.MAP_CODEC);
    }
}

