/*
 * Decompiled with CFR 0.152.
 */
package net.nicguzzo.wands.wand;

import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.block.Rotation;
import net.nicguzzo.wands.WandsMod;
import net.nicguzzo.wands.utils.Compat;
import net.nicguzzo.wands.utils.WandUtils;
import net.nicguzzo.wands.wand.WandMode;
import net.nicguzzo.wands.wand.modes.AreaMode;
import net.nicguzzo.wands.wand.modes.BlastMode;
import net.nicguzzo.wands.wand.modes.CircleMode;
import net.nicguzzo.wands.wand.modes.CopyMode;
import net.nicguzzo.wands.wand.modes.DirectionMode;
import net.nicguzzo.wands.wand.modes.FillMode;
import net.nicguzzo.wands.wand.modes.GridMode;
import net.nicguzzo.wands.wand.modes.LineMode;
import net.nicguzzo.wands.wand.modes.PasteMode;
import net.nicguzzo.wands.wand.modes.RockMode;
import net.nicguzzo.wands.wand.modes.RowColMode;
import net.nicguzzo.wands.wand.modes.SphereMode;
import net.nicguzzo.wands.wand.modes.TunnelMode;
import net.nicguzzo.wands.wand.modes.VeinMode;

public class WandProps {
    public static Mode[] modes = Mode.values();
    public static Action[] actions = Action.values();
    public static Orientation[] orientations = Orientation.values();
    public static Plane[] planes = Plane.values();
    public static Direction.Axis[] axes = Direction.Axis.values();
    public static Rotation[] rotations = Rotation.values();
    public static StateMode[] state_modes = StateMode.values();
    public static MirrorAxis[] mirrorAxes = MirrorAxis.values();

    public static boolean getFlag(ItemStack stack, Flag flag) {
        if (WandUtils.is_wand(stack)) {
            CompoundTag tag = Compat.getTags(stack);
            if (tag.contains(flag.toString())) {
                return tag.getBoolean(flag.toString()).orElse(flag.get_default());
            }
            tag.putBoolean(flag.toString(), flag.get_default());
            return flag.get_default();
        }
        return false;
    }

    public static void setFlag(ItemStack stack, Flag flag, boolean f) {
        if (WandUtils.is_wand(stack)) {
            CompoundTag tag = Compat.getTags(stack);
            tag.putBoolean(flag.toString(), f);
            CustomData.set((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)stack, (CompoundTag)tag);
        }
    }

    public static void toggleFlag(ItemStack stack, Flag flag) {
        if (WandUtils.is_wand(stack)) {
            CompoundTag tag = Compat.getTags(stack);
            boolean b = WandProps.getFlag(stack, flag);
            tag.putBoolean(flag.toString(), !b);
            CustomData.set((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)stack, (CompoundTag)tag);
        }
    }

    public static void setVal(ItemStack stack, Value v, int n) {
        if (WandUtils.is_wand(stack)) {
            if (n > v.max) {
                n = v.max;
            }
            if (n < v.min) {
                n = v.min;
            }
            CompoundTag tag = Compat.getTags(stack);
            tag.putInt(v.toString(), n);
            CustomData.set((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)stack, (CompoundTag)tag);
        }
    }

    public static void incVal(ItemStack stack, Value v, int inc, int max) {
        if (WandUtils.is_wand(stack)) {
            CompoundTag tag = Compat.getTags(stack);
            int n = tag.getInt(v.toString()).orElse(v.def);
            if (n > v.max) {
                n = v.max;
            }
            if (n < v.min) {
                n = v.min;
            }
            if (n + inc <= max) {
                tag.putInt(v.toString(), n + inc);
                CustomData.set((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)stack, (CompoundTag)tag);
            }
        }
    }

    public static void incVal(ItemStack stack, Value v, int inc) {
        WandProps.incVal(stack, v, inc, v.max);
    }

    public static void decVal(ItemStack stack, Value v, int inc, int min) {
        if (WandUtils.is_wand(stack)) {
            CompoundTag tag = Compat.getTags(stack);
            int n = tag.getInt(v.toString()).orElse(v.def);
            if (n > v.max) {
                n = v.max;
            }
            if (n < v.min) {
                n = v.min;
            }
            if (n - inc >= min) {
                tag.putInt(v.toString(), n - inc);
                CustomData.set((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)stack, (CompoundTag)tag);
            }
        }
    }

    public static void decVal(ItemStack stack, Value v, int dec) {
        WandProps.decVal(stack, v, dec, v.min);
    }

    public static int getVal(ItemStack stack, Value v) {
        if (!WandUtils.is_wand(stack)) {
            return -1;
        }
        CompoundTag tag = Compat.getTags(stack);
        int i = !tag.contains(v.toString()) ? v.def : tag.getInt(v.toString()).orElse(v.def);
        if (i > v.max) {
            i = v.max;
            tag.putInt(v.toString(), i);
            CustomData.set((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)stack, (CompoundTag)tag);
        }
        if (i < v.min) {
            i = v.min;
            tag.putInt(v.toString(), i);
            CustomData.set((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)stack, (CompoundTag)tag);
        }
        if (i < v.min) {
            return v.min;
        }
        if (i > v.max) {
            return v.max;
        }
        return i;
    }

    public static Mode getMode(ItemStack stack) {
        if (!WandUtils.is_wand(stack)) {
            return Mode.DIRECTION;
        }
        CompoundTag tag = Compat.getTags(stack);
        int m = tag.getInt("mode").orElse(0);
        if (m >= 0 && m < modes.length) {
            return modes[m];
        }
        return Mode.DIRECTION;
    }

    public static void setMode(ItemStack stack, Mode mode) {
        if (!WandUtils.is_wand(stack)) {
            return;
        }
        CompoundTag tag = Compat.getTags(stack);
        tag.putInt("mode", mode.ordinal());
        CustomData.set((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)stack, (CompoundTag)tag);
    }

    public static void nextMode(ItemStack stack, boolean can_blast) {
        if (!WandUtils.is_wand(stack)) {
            return;
        }
        CompoundTag tag = Compat.getTags(stack);
        int mode = (tag.getInt("mode").orElse(0) + 1) % modes.length;
        if (mode == Mode.VEIN.ordinal() && !WandsMod.config.enable_vein_mode) {
            mode = Mode.BLAST.ordinal();
        }
        if (!can_blast && mode == Mode.BLAST.ordinal() || !WandsMod.config.enable_blast_mode && mode == Mode.BLAST.ordinal()) {
            mode = Mode.DIRECTION.ordinal();
        }
        tag.putInt("mode", mode);
        CustomData.set((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)stack, (CompoundTag)tag);
    }

    public static void prevMode(ItemStack stack, boolean can_blast) {
        if (!WandUtils.is_wand(stack)) {
            return;
        }
        CompoundTag tag = Compat.getTags(stack);
        int mode = tag.getInt("mode").orElse(1) - 1;
        if (mode < 0) {
            mode = modes.length - 1;
        }
        if (!can_blast && mode == Mode.BLAST.ordinal() || !WandsMod.config.enable_blast_mode && mode == Mode.BLAST.ordinal()) {
            mode = Mode.BLAST.ordinal() - 1;
        }
        if (mode == Mode.VEIN.ordinal() && !WandsMod.config.enable_vein_mode) {
            mode = Mode.VEIN.ordinal() - 1;
        }
        tag.putInt("mode", mode);
        CustomData.set((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)stack, (CompoundTag)tag);
    }

    public static Orientation getOrientation(ItemStack stack) {
        if (!WandUtils.is_wand(stack)) {
            return Orientation.ROW;
        }
        CompoundTag tag = Compat.getTags(stack);
        return orientations[tag.getInt("orientation").orElse(0)];
    }

    public static void setOrientation(ItemStack stack, Orientation o) {
        if (!WandUtils.is_wand(stack)) {
            return;
        }
        CompoundTag tag = Compat.getTags(stack);
        tag.putInt("orientation", o.ordinal());
        CustomData.set((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)stack, (CompoundTag)tag);
    }

    public static void nextOrientation(ItemStack stack) {
        if (!WandUtils.is_wand(stack)) {
            return;
        }
        CompoundTag tag = Compat.getTags(stack);
        int o = (tag.getInt("orientation").orElse(0) + 1) % 2;
        tag.putInt("orientation", o);
        CustomData.set((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)stack, (CompoundTag)tag);
    }

    public static Plane getPlane(ItemStack stack) {
        Plane plane = Plane.XZ;
        if (!WandUtils.is_wand(stack)) {
            return plane;
        }
        CompoundTag tag = Compat.getTags(stack);
        int p = tag.getInt("plane").orElse(0);
        CustomData.set((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)stack, (CompoundTag)tag);
        if (p >= 0 && p < planes.length) {
            plane = planes[p];
        }
        return plane;
    }

    public static void setPlane(ItemStack stack, Plane p) {
        if (!WandUtils.is_wand(stack)) {
            return;
        }
        CompoundTag tag = Compat.getTags(stack);
        tag.putInt("plane", p.ordinal());
        CustomData.set((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)stack, (CompoundTag)tag);
    }

    public static void nextPlane(ItemStack stack) {
        if (!WandUtils.is_wand(stack)) {
            return;
        }
        CompoundTag tag = Compat.getTags(stack);
        int plane = (tag.getInt("plane").orElse(0) + 1) % 3;
        tag.putInt("plane", plane);
        CustomData.set((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)stack, (CompoundTag)tag);
    }

    public static Rotation getRotation(ItemStack stack) {
        if (!WandUtils.is_wand(stack)) {
            return Rotation.NONE;
        }
        CompoundTag tag = Compat.getTags(stack);
        return rotations[tag.getInt("rotation").orElse(0)];
    }

    public static void nextRotation(ItemStack stack) {
        if (!WandUtils.is_wand(stack)) {
            return;
        }
        CompoundTag tag = Compat.getTags(stack);
        int rot = (tag.getInt("rotation").orElse(0) + 1) % rotations.length;
        tag.putInt("rotation", rot);
        CustomData.set((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)stack, (CompoundTag)tag);
    }

    public static void setRotation(ItemStack stack, Rotation rot) {
        if (!WandUtils.is_wand(stack)) {
            return;
        }
        CompoundTag tag = Compat.getTags(stack);
        tag.putInt("rotation", rot.ordinal());
        CustomData.set((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)stack, (CompoundTag)tag);
    }

    public static Action getAction(ItemStack stack) {
        CompoundTag tag;
        int m;
        if (WandUtils.is_wand(stack) && (m = (tag = Compat.getTags(stack)).getInt("action").orElse(0).intValue()) < actions.length) {
            return actions[m];
        }
        return Action.PLACE;
    }

    public static void setAction(ItemStack stack, Action a) {
        if (WandUtils.is_wand(stack)) {
            CompoundTag tag = Compat.getTags(stack);
            if (WandsMod.config.disable_destroy_replace && (a == Action.DESTROY || a == Action.REPLACE)) {
                a = Action.PLACE;
            }
            tag.putInt("action", a.ordinal());
            CustomData.set((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)stack, (CompoundTag)tag);
        }
    }

    public static void nextAction(ItemStack stack) {
        if (WandUtils.is_wand(stack)) {
            CompoundTag tag = Compat.getTags(stack);
            int a = (tag.getInt("action").orElse(0) + 1) % actions.length;
            if (WandsMod.config.disable_destroy_replace && (a == Action.DESTROY.ordinal() || a == Action.REPLACE.ordinal())) {
                a = Action.USE.ordinal();
            }
            tag.putInt("action", a);
            CustomData.set((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)stack, (CompoundTag)tag);
        }
    }

    public static void prevAction(ItemStack stack) {
        if (WandUtils.is_wand(stack)) {
            CompoundTag tag = Compat.getTags(stack);
            int a = tag.getInt("action").orElse(0) - 1;
            if (a < 0) {
                a = actions.length - 1;
            }
            if (WandsMod.config.disable_destroy_replace && (a == Action.DESTROY.ordinal() || a == Action.REPLACE.ordinal())) {
                a = Action.PLACE.ordinal();
            }
            tag.putInt("action", a);
            CustomData.set((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)stack, (CompoundTag)tag);
        }
    }

    public static Direction.Axis getAxis(ItemStack stack) {
        int p;
        Direction.Axis axis = Direction.Axis.Y;
        CompoundTag tag = Compat.getTags(stack);
        if (WandUtils.is_wand(stack) && (p = tag.getInt("axis").orElse(0).intValue()) >= 0 && p < axes.length) {
            axis = axes[p];
        }
        return axis;
    }

    public static void setAxis(ItemStack stack, Direction.Axis axis) {
        if (WandUtils.is_wand(stack)) {
            CompoundTag tag = Compat.getTags(stack);
            tag.putInt("axis", axis.ordinal());
            CustomData.set((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)stack, (CompoundTag)tag);
        }
    }

    public static void setAxis(ItemStack stack, int a) {
        if (stack != null && WandUtils.is_wand(stack) && !stack.isEmpty()) {
            CompoundTag tag = Compat.getTags(stack);
            tag.putInt("axis", a);
            CustomData.set((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)stack, (CompoundTag)tag);
        }
    }

    public static void nextAxis(ItemStack stack) {
        if (WandUtils.is_wand(stack)) {
            CompoundTag tag = Compat.getTags(stack);
            int axis = (tag.getInt("axis").orElse(0) + 1) % 3;
            tag.putInt("axis", axis);
            CustomData.set((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)stack, (CompoundTag)tag);
        }
    }

    public static StateMode getStateMode(ItemStack stack) {
        CompoundTag tag;
        int m;
        if (WandUtils.is_wand(stack) && (m = (tag = Compat.getTags(stack)).getInt("state_mode").orElse(0).intValue()) < state_modes.length) {
            return state_modes[m];
        }
        return StateMode.TARGET;
    }

    public static void setStateMode(ItemStack stack, StateMode mode) {
        if (WandUtils.is_wand(stack)) {
            CompoundTag tag = Compat.getTags(stack);
            tag.putInt("state_mode", mode.ordinal());
            CustomData.set((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)stack, (CompoundTag)tag);
        }
    }

    public static void incGrid(ItemStack stack, Value v, int n, int limit) {
        if (WandUtils.is_wand(stack)) {
            int c;
            CompoundTag tag = Compat.getTags(stack);
            if (v.coval != null && (c = tag.getInt(v.coval.toString()).orElse(v.def).intValue()) * n <= limit) {
                int nn = tag.getInt(v.toString()).orElse(v.def);
                tag.putInt(v.toString(), nn + n);
                CustomData.set((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)stack, (CompoundTag)tag);
            }
        }
    }

    public static enum Flag {
        INVERTED{

            public String toString() {
                return "inverted";
            }

            @Override
            public boolean get_default() {
                return false;
            }
        }
        ,
        CFILLED{

            public String toString() {
                return "cfill";
            }

            @Override
            public boolean get_default() {
                return false;
            }
        }
        ,
        EVEN{

            public String toString() {
                return "circle_even";
            }

            @Override
            public boolean get_default() {
                return false;
            }
        }
        ,
        DIAGSPREAD{

            public String toString() {
                return "diag_spread";
            }

            @Override
            public boolean get_default() {
                return false;
            }
        }
        ,
        MATCHSTATE{

            public String toString() {
                return "match_state";
            }

            @Override
            public boolean get_default() {
                return false;
            }
        }
        ,
        INCSELBLOCK{

            public String toString() {
                return "inc_sel_block";
            }

            @Override
            public boolean get_default() {
                return false;
            }
        }
        ,
        STAIRSLAB{

            public String toString() {
                return "stair_slab";
            }

            @Override
            public boolean get_default() {
                return false;
            }
        }
        ,
        RFILLED{

            public String toString() {
                return "rfill";
            }

            @Override
            public boolean get_default() {
                return true;
            }
        }
        ,
        TARGET_AIR{

            public String toString() {
                return "target_air";
            }

            @Override
            public boolean get_default() {
                return false;
            }
        };


        public abstract boolean get_default();
    }

    public static enum Value {
        MULTIPLIER{

            public String toString() {
                return "multiplier";
            }
        }
        ,
        ROWCOLLIM{

            public String toString() {
                return "row_col_limit";
            }
        }
        ,
        AREALIM{

            public String toString() {
                return "area_limit";
            }
        }
        ,
        BLASTRAD{

            public String toString() {
                return "blast_radius";
            }
        }
        ,
        GRIDM{

            public String toString() {
                return "grid_m";
            }
        }
        ,
        GRIDN{

            public String toString() {
                return "grid_n";
            }
        }
        ,
        GRIDMS{

            public String toString() {
                return "grid_msp";
            }
        }
        ,
        GRIDNS{

            public String toString() {
                return "grid_nsp";
            }
        }
        ,
        GRIDMOFF{

            public String toString() {
                return "grid_moff";
            }
        }
        ,
        GRIDNOFF{

            public String toString() {
                return "grid_noff";
            }
        }
        ,
        MIRRORAXIS{

            public String toString() {
                return "mirror_axis";
            }
        }
        ,
        SKIPBLOCK{

            public String toString() {
                return "skip_block";
            }
        }
        ,
        TUNNEL_W{

            public String toString() {
                return "tunnel_w";
            }
        }
        ,
        TUNNEL_H{

            public String toString() {
                return "tunnel_h";
            }
        }
        ,
        TUNNEL_OX{

            public String toString() {
                return "tunnel_ox";
            }
        }
        ,
        TUNNEL_OY{

            public String toString() {
                return "tunnel_oy";
            }
        }
        ,
        TUNNEL_DEPTH{

            public String toString() {
                return "tunnel_d";
            }
        }
        ,
        ROCK_RADIUS{

            public String toString() {
                return "rock_radius";
            }
        }
        ,
        ROCK_NOISE{

            public String toString() {
                return "rock_noise";
            }
        }
        ,
        AIR_TARGET_DISTANCE{

            public String toString() {
                return "air_target_distance";
            }
        };

        public int def = 0;
        public int min = 0;
        public int max = 2048;
        public Value coval = null;

        static {
            Value.MULTIPLIER.def = 1;
            Value.MULTIPLIER.min = 1;
            Value.MULTIPLIER.max = 16;
            Value.ROWCOLLIM.def = 0;
            Value.ROWCOLLIM.min = 0;
            Value.BLASTRAD.def = 4;
            Value.BLASTRAD.min = 4;
            Value.BLASTRAD.max = 16;
            Value.GRIDM.coval = GRIDN;
            Value.GRIDN.coval = GRIDM;
            Value.GRIDM.min = 1;
            Value.GRIDN.min = 1;
            Value.MIRRORAXIS.min = 0;
            Value.MIRRORAXIS.max = 2;
            Value.SKIPBLOCK.max = 100;
            Value.TUNNEL_W.min = 1;
            Value.TUNNEL_H.min = 1;
            Value.TUNNEL_H.def = 2;
            Value.TUNNEL_DEPTH.def = 3;
            Value.TUNNEL_DEPTH.min = 1;
            Value.ROCK_RADIUS.min = 0;
            Value.ROCK_RADIUS.def = 2;
            Value.ROCK_NOISE.min = 0;
            Value.ROCK_NOISE.max = 16;
            Value.ROCK_NOISE.def = 3;
            Value.AIR_TARGET_DISTANCE.def = 0;
            Value.AIR_TARGET_DISTANCE.min = 0;
            Value.AIR_TARGET_DISTANCE.max = 10;
        }
    }

    public static enum Mode {
        DIRECTION{

            public String toString() {
                return "wands.modes.direction";
            }

            @Override
            public WandMode get_mode() {
                return new DirectionMode();
            }

            @Override
            public boolean can_target_air() {
                return false;
            }

            @Override
            public int n_clicks() {
                return 1;
            }
        }
        ,
        ROW_COL{

            public String toString() {
                return "wands.modes.row_col";
            }

            @Override
            public WandMode get_mode() {
                return new RowColMode();
            }

            @Override
            public boolean can_target_air() {
                return true;
            }

            @Override
            public int n_clicks() {
                return 1;
            }
        }
        ,
        FILL{

            public String toString() {
                return "wands.modes.fill";
            }

            @Override
            public WandMode get_mode() {
                return new FillMode();
            }

            @Override
            public boolean can_target_air() {
                return true;
            }

            @Override
            public int n_clicks() {
                return 2;
            }
        }
        ,
        AREA{

            public String toString() {
                return "wands.modes.area";
            }

            @Override
            public WandMode get_mode() {
                return new AreaMode();
            }

            @Override
            public boolean can_target_air() {
                return false;
            }

            @Override
            public int n_clicks() {
                return 1;
            }
        }
        ,
        GRID{

            public String toString() {
                return "wands.modes.grid";
            }

            @Override
            public WandMode get_mode() {
                return new GridMode();
            }

            @Override
            public boolean can_target_air() {
                return true;
            }

            @Override
            public int n_clicks() {
                return 1;
            }
        }
        ,
        LINE{

            public String toString() {
                return "wands.modes.line";
            }

            @Override
            public WandMode get_mode() {
                return new LineMode();
            }

            @Override
            public boolean can_target_air() {
                return true;
            }

            @Override
            public int n_clicks() {
                return 2;
            }
        }
        ,
        CIRCLE{

            public String toString() {
                return "wands.modes.circle";
            }

            @Override
            public WandMode get_mode() {
                return new CircleMode();
            }

            @Override
            public boolean can_target_air() {
                return true;
            }

            @Override
            public int n_clicks() {
                return 2;
            }
        }
        ,
        COPY{

            public String toString() {
                return "wands.modes.copy";
            }

            @Override
            public WandMode get_mode() {
                return new CopyMode();
            }

            @Override
            public boolean can_target_air() {
                return true;
            }

            @Override
            public int n_clicks() {
                return 2;
            }
        }
        ,
        PASTE{

            public String toString() {
                return "wands.modes.paste";
            }

            @Override
            public WandMode get_mode() {
                return new PasteMode();
            }

            @Override
            public boolean can_target_air() {
                return true;
            }

            @Override
            public int n_clicks() {
                return 1;
            }
        }
        ,
        TUNNEL{

            public String toString() {
                return "wands.modes.tunnel";
            }

            @Override
            public WandMode get_mode() {
                return new TunnelMode();
            }

            @Override
            public boolean can_target_air() {
                return true;
            }

            @Override
            public int n_clicks() {
                return 1;
            }
        }
        ,
        VEIN{

            public String toString() {
                return "wands.modes.vein";
            }

            @Override
            public WandMode get_mode() {
                return new VeinMode();
            }

            @Override
            public boolean can_target_air() {
                return false;
            }

            @Override
            public int n_clicks() {
                return 1;
            }
        }
        ,
        BLAST{

            public String toString() {
                return "wands.modes.blast";
            }

            @Override
            public WandMode get_mode() {
                return new BlastMode();
            }

            @Override
            public boolean can_target_air() {
                return true;
            }

            @Override
            public int n_clicks() {
                return 1;
            }
        }
        ,
        SPHERE{

            public String toString() {
                return "wands.modes.sphere";
            }

            @Override
            public WandMode get_mode() {
                return new SphereMode();
            }

            @Override
            public boolean can_target_air() {
                return true;
            }

            @Override
            public int n_clicks() {
                return 2;
            }
        }
        ,
        ROCK{

            public String toString() {
                return "wands.modes.rock";
            }

            @Override
            public WandMode get_mode() {
                return new RockMode();
            }

            @Override
            public boolean can_target_air() {
                return true;
            }

            @Override
            public int n_clicks() {
                return 1;
            }
        };


        public abstract WandMode get_mode();

        public abstract boolean can_target_air();

        public abstract int n_clicks();
    }

    public static enum Orientation {
        ROW{

            public String toString() {
                return "wands.orientation.row";
            }
        }
        ,
        COL{

            public String toString() {
                return "wands.orientation.col";
            }
        };

    }

    public static enum Plane {
        XZ,
        XY,
        YZ;

    }

    public static enum Action {
        PLACE{

            public String toString() {
                return "wands.action.place";
            }
        }
        ,
        REPLACE{

            public String toString() {
                return "wands.action.replace";
            }
        }
        ,
        DESTROY{

            public String toString() {
                return "wands.action.destroy";
            }
        }
        ,
        USE{

            public String toString() {
                return "wands.action.use";
            }
        };

    }

    public static enum StateMode {
        CLONE{

            public String toString() {
                return "wands.state_mode.clone";
            }
        }
        ,
        APPLY{

            public String toString() {
                return "wands.state_mode.apply";
            }
        }
        ,
        TARGET{

            public String toString() {
                return "wands.state_mode.target";
            }
        };

    }

    public static enum MirrorAxis {
        NONE,
        LEFT_RIGHT,
        FRONT_BACK;

    }
}

