/*
 * Decompiled with CFR 0.152.
 */
package net.nicguzzo.wands.items;

import dev.architectury.platform.Platform;
import dev.architectury.utils.Env;
import java.util.List;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_7225;
import net.minecraft.class_9279;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import net.nicguzzo.wands.utils.Compat;
import net.nicguzzo.wands.utils.WandUtils;
import org.jetbrains.annotations.NotNull;

public class MagicBagItem
extends class_1792 {
    public MagicBagItemTier tier;
    public int limit = Integer.MAX_VALUE;

    public MagicBagItem(MagicBagItemTier tier, int limit, class_1792.class_1793 properties) {
        super(properties);
        this.tier = tier;
        if (limit > 0) {
            this.limit = limit;
        }
    }

    public class_1269 method_7836(class_1937 world, class_1657 player, class_1268 interactionHand) {
        class_1799 magic_bag = player.method_5998(interactionHand);
        if (!world.method_8608()) {
            Compat.open_menu((class_3222)player, magic_bag, 2);
        }
        return class_1269.field_5811;
    }

    public static int getTotal(class_1799 bag) {
        if (bag != null && bag.method_7909() instanceof MagicBagItem) {
            class_2487 tag = Compat.getTags(bag);
            return tag.method_10550("total").orElse(0);
        }
        return 0;
    }

    public static boolean inc(class_1799 bag, int n) {
        if (bag != null && bag.method_7909() instanceof MagicBagItem) {
            int lim = ((MagicBagItem)bag.method_7909()).limit;
            class_2487 tag = Compat.getTags(bag);
            int total = tag.method_10550("total").orElse(0);
            if (total + n < lim) {
                tag.method_10569("total", total + n);
                class_9279.method_57453((class_9331)class_9334.field_49628, (class_1799)bag, (class_2487)tag);
                return true;
            }
        }
        return false;
    }

    public static void dec(class_1799 bag, int n) {
        if (bag != null && bag.method_7909() instanceof MagicBagItem) {
            class_2487 tag = Compat.getTags(bag);
            int total = tag.method_10550("total").orElse(0);
            if (total - n >= 0) {
                tag.method_10569("total", total - n);
            } else {
                tag.method_10569("total", 0);
            }
            class_9279.method_57453((class_9331)class_9334.field_49628, (class_1799)bag, (class_2487)tag);
        }
    }

    public static void setItem(class_1799 bag, class_1799 item, class_7225.class_7874 ra) {
        if (bag != null && item != null && !item.method_7960() && bag.method_7909() instanceof MagicBagItem) {
            class_1799 item2 = item.method_7972();
            item2.method_7939(1);
            class_2487 tag = Compat.getTags(bag);
            if (ra != null) {
                class_2487 t = WandUtils.ItemStack_save(item2, ra);
                tag.method_10566("item", (class_2520)t);
                class_9279.method_57453((class_9331)class_9334.field_49628, (class_1799)bag, (class_2487)tag);
            }
        }
        if (item.method_7960()) {
            class_9279.method_57453((class_9331)class_9334.field_49628, (class_1799)bag, (class_2487)new class_2487());
        }
    }

    public static class_1799 getItem(class_1799 bag, class_7225.class_7874 ra) {
        if (bag != null && bag.method_7909() instanceof MagicBagItem) {
            Optional<class_1799> item;
            class_2487 tag = Compat.getTags(bag);
            if (ra != null && tag.method_10562("item").isPresent() && (item = WandUtils.ItemStack_read((class_2487)tag.method_10562("item").get(), ra)).isPresent()) {
                return item.get();
            }
        }
        return class_1799.field_8037;
    }

    @Environment(value=EnvType.CLIENT)
    public void appendHoverText(class_1799 stack, class_1792.class_9635 tooltipContext, List<class_2561> list, class_1836 tooltipFlag) {
        class_1799 i = MagicBagItem.getItem(stack, tooltipContext.method_59527());
        if (i.method_7960()) {
            list.add((class_2561)Compat.literal("item: none"));
        } else {
            list.add((class_2561)Compat.literal("item: ").method_10852((class_2561)class_2561.method_43471((String)i.method_7909().method_7876())));
        }
        list.add((class_2561)Compat.literal("total: " + MagicBagItem.getTotal(stack)));
    }

    @NotNull
    public class_2561 method_7864(class_1799 itemStack) {
        class_1799 item;
        if (Platform.getEnvironment() == Env.CLIENT && !itemStack.method_7960() && itemStack.method_7909() instanceof MagicBagItem && !(item = MagicBagItem.getItem(itemStack, (class_7225.class_7874)class_310.method_1551().field_1687.method_30349())).method_7960()) {
            return Compat.literal("Bag of ").method_10852((class_2561)class_2561.method_43471((String)item.method_7909().method_7876())).method_27693(" - Tier " + (this.tier.ordinal() + 1));
        }
        return super.method_7864(itemStack);
    }

    public static enum MagicBagItemTier {
        MAGIC_BAG_TIER_1,
        MAGIC_BAG_TIER_2,
        MAGIC_BAG_TIER_3;

    }
}

