/*
 * Decompiled with CFR 0.152.
 */
package net.nicguzzo.wands.wand.modes;

import net.nicguzzo.wands.wand.Wand;
import net.nicguzzo.wands.wand.WandMode;
import net.nicguzzo.wands.wand.WandProps;

public class CircleMode
extends WandMode {
    @Override
    public void place_in_buffer(Wand wand) {
        int plane = WandProps.getPlane(wand.wand_stack).ordinal();
        boolean fill = WandProps.getFlag(wand.wand_stack, WandProps.Flag.CFILLED);
        boolean even = WandProps.getFlag(wand.wand_stack, WandProps.Flag.EVEN);
        wand.block_buffer.reset();
        int diameter = 0;
        if (wand.getP1() != null && (wand.getP2() != null || wand.preview)) {
            int xc = wand.getP1().method_10263();
            int yc = wand.getP1().method_10264();
            int zc = wand.getP1().method_10260();
            int px = wand.pos.method_10263() - xc;
            int py = wand.pos.method_10264() - yc;
            int pz = wand.pos.method_10260() - zc;
            int r = (int)Math.sqrt(px * px + py * py + pz * pz);
            int radius = r + 1;
            if (r < 1) {
                return;
            }
            diameter = 2 * r;
            if (plane == 0) {
                int x = r;
                int y = 0;
                int z = 0;
                int d = 1 - r;
                do {
                    this.drawCircleOctants(xc, yc, zc, x, y, z, plane, even, fill, wand);
                    ++z;
                    if (d < 0) {
                        d += 2 * z + 1;
                        continue;
                    }
                    d += 2 * (z - --x) + 1;
                } while (z <= x);
                if (fill && !even) {
                    if (r == 1) {
                        wand.add_to_buffer(xc, yc, zc);
                    } else {
                        int r2 = r * r;
                        for (z = -r; z <= r; ++z) {
                            for (x = -r; x <= r; ++x) {
                                if (x * x + z * z >= r2) continue;
                                wand.add_to_buffer(xc + x, yc, zc + z);
                            }
                        }
                    }
                }
            } else if (plane == 1) {
                int x = r;
                int y = 0;
                int z = 0;
                int d = 1 - r;
                do {
                    this.drawCircleOctants(xc, yc, zc, x, y, z, plane, even, fill, wand);
                    ++y;
                    if (d < 0) {
                        d += 2 * y + 1;
                        continue;
                    }
                    d += 2 * (y - --x) + 1;
                } while (y <= x);
                if (fill && !even) {
                    if (r == 1) {
                        wand.add_to_buffer(xc, yc, zc);
                    } else {
                        int r2 = r * r;
                        for (y = -r; y <= r; ++y) {
                            for (x = -r; x <= r; ++x) {
                                if (x * x + y * y > r2) continue;
                                wand.add_to_buffer(xc + x, yc + y, zc);
                            }
                        }
                    }
                }
            } else if (plane == 2) {
                int x = 0;
                int y = 0;
                int z = r;
                int d = 1 - r;
                do {
                    this.drawCircleOctants(xc, yc, zc, x, y, z, plane, even, fill, wand);
                    ++y;
                    if (d < 0) {
                        d += 2 * y + 1;
                        continue;
                    }
                    d += 2 * (y - --z) + 1;
                } while (y <= z);
                if (fill && !even) {
                    int r2 = r * r;
                    for (z = -r; z <= r; ++z) {
                        for (y = -r; y <= r; ++y) {
                            if (y * y + z * z > r2) continue;
                            wand.add_to_buffer(xc, yc + y, zc + z);
                        }
                    }
                }
            }
        }
        wand.validate_buffer();
    }

    void drawCircleOctants(int xc, int yc, int zc, int x, int y, int z, int plane, boolean even, boolean fill, Wand wand) {
        switch (plane) {
            case 0: {
                if (even) {
                    wand.add_to_buffer(xc + x, yc, zc + z);
                    wand.add_to_buffer(xc + z, yc, zc + x);
                    wand.add_to_buffer(xc + z, yc, zc - x - 1);
                    wand.add_to_buffer(xc + x, yc, zc - z - 1);
                    wand.add_to_buffer(xc - x - 1, yc, zc - z - 1);
                    wand.add_to_buffer(xc - z - 1, yc, zc - x - 1);
                    wand.add_to_buffer(xc - z - 1, yc, zc + x);
                    wand.add_to_buffer(xc - x - 1, yc, zc + z);
                    if (!fill) break;
                    break;
                }
                wand.add_to_buffer(xc + x, yc, zc + z);
                if (x != z) {
                    wand.add_to_buffer(xc + z, yc, zc + x);
                    wand.add_to_buffer(xc + z, yc, zc - x);
                    wand.add_to_buffer(xc - x, yc, zc - z);
                }
                if (z <= 0) break;
                wand.add_to_buffer(xc + x, yc, zc - z);
                wand.add_to_buffer(xc - z, yc, zc - x);
                wand.add_to_buffer(xc - z, yc, zc + x);
                if (x == z) break;
                wand.add_to_buffer(xc - x, yc, zc + z);
                break;
            }
            case 1: {
                if (even) {
                    wand.add_to_buffer(xc + x, yc + y, zc);
                    wand.add_to_buffer(xc + y, yc + x, zc);
                    wand.add_to_buffer(xc + y, yc - x - 1, zc);
                    wand.add_to_buffer(xc - x - 1, yc - y - 1, zc);
                    wand.add_to_buffer(xc + x, yc - y - 1, zc);
                    wand.add_to_buffer(xc - y - 1, yc - x - 1, zc);
                    wand.add_to_buffer(xc - y - 1, yc + x, zc);
                    wand.add_to_buffer(xc - x - 1, yc + y, zc);
                    break;
                }
                wand.add_to_buffer(xc + x, yc + y, zc);
                if (x != y) {
                    wand.add_to_buffer(xc + y, yc + x, zc);
                    wand.add_to_buffer(xc + y, yc - x, zc);
                    wand.add_to_buffer(xc - x, yc - y, zc);
                }
                if (y <= 0) break;
                wand.add_to_buffer(xc + x, yc - y, zc);
                wand.add_to_buffer(xc - y, yc - x, zc);
                wand.add_to_buffer(xc - y, yc + x, zc);
                if (x == y) break;
                wand.add_to_buffer(xc - x, yc + y, zc);
                break;
            }
            case 2: {
                if (even) {
                    wand.add_to_buffer(xc, yc + z, zc + y);
                    wand.add_to_buffer(xc, yc + y, zc + z);
                    wand.add_to_buffer(xc, yc + y, zc - z - 1);
                    wand.add_to_buffer(xc, yc - z - 1, zc - y - 1);
                    wand.add_to_buffer(xc, yc + z, zc - y - 1);
                    wand.add_to_buffer(xc, yc - y - 1, zc - z - 1);
                    wand.add_to_buffer(xc, yc - y - 1, zc + z);
                    wand.add_to_buffer(xc, yc - z - 1, zc + y);
                    break;
                }
                wand.add_to_buffer(xc, yc + y, zc + z);
                if (y != z) {
                    wand.add_to_buffer(xc, yc + z, zc + y);
                    wand.add_to_buffer(xc, yc + z, zc - y);
                    wand.add_to_buffer(xc, yc - y, zc - z);
                }
                if (z <= 0) break;
                wand.add_to_buffer(xc, yc + y, zc - z);
                wand.add_to_buffer(xc, yc - z, zc - y);
                wand.add_to_buffer(xc, yc - z, zc + y);
                if (y == z) break;
                wand.add_to_buffer(xc, yc - y, zc + z);
            }
        }
    }
}

