/*
 * Decompiled with CFR 0.152.
 */
package com.macuguita.lib.supporters;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.macuguita.lib.MacuguitaLib;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class RoleChecker {
    private static final String ROLES_URL = "https://raw.githubusercontent.com/macuguita/macuguita-website/refs/heads/main/supporters.json";
    private static Map<String, Set<UUID>> cachedRoles = new HashMap<String, Set<UUID>>();
    private static long lastFetchTime = 0L;
    private static final int CACHE_REFRESH_INTERVAL_MINUTES = 60;
    private static final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);

    public static void init() {
        RoleChecker.fetchRoles();
        scheduler.scheduleAtFixedRate(RoleChecker::fetchRoles, 60L, 60L, TimeUnit.MINUTES);
        MacuguitaLib.LOGGER.info("RoleChecker initialized with cache refresh every 60 minutes.");
    }

    private static void fetchRoles() {
        try {
            URI uri = new URI(ROLES_URL);
            URL url = uri.toURL();
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            if (!url.getProtocol().equals("https")) {
                MacuguitaLib.LOGGER.error("Roles URL must use HTTPS for security.");
                throw new RuntimeException("Roles URL must use HTTPS for security.");
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            JsonObject json = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            reader.close();
            JsonObject rolesObject = json.getAsJsonObject("roles");
            HashMap<String, Set<UUID>> newRoles = new HashMap<String, Set<UUID>>();
            for (String role : rolesObject.keySet()) {
                HashSet uuids = new HashSet();
                rolesObject.getAsJsonArray(role).forEach(element -> {
                    try {
                        uuids.add(UUID.fromString(element.getAsString()));
                    }
                    catch (IllegalArgumentException e) {
                        MacuguitaLib.LOGGER.error("Invalid UUID in roles JSON: " + element.getAsString());
                    }
                });
                newRoles.put(role, uuids);
            }
            cachedRoles = newRoles;
            lastFetchTime = System.currentTimeMillis();
            MacuguitaLib.LOGGER.info("Roles cache updated at " + String.valueOf(new Date(lastFetchTime)));
        }
        catch (Exception e) {
            MacuguitaLib.LOGGER.error("Failed to fetch roles from URL: https://raw.githubusercontent.com/macuguita/macuguita-website/refs/heads/main/supporters.json", (Throwable)e);
        }
    }

    public static String getPlayerRole(UUID playerUUID) {
        for (Map.Entry<String, Set<UUID>> entry : cachedRoles.entrySet()) {
            if (!entry.getValue().contains(playerUUID)) continue;
            return entry.getKey();
        }
        return null;
    }

    public static boolean hasRole(UUID playerUUID, String role) {
        return cachedRoles.containsKey(role) && cachedRoles.get(role).contains(playerUUID);
    }
}

