package com.macuguita.lib.platform.utils.neoforge;

import com.macuguita.lib.platform.utils.GuitaItemGroup;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.CreativeModeTab;

public class GuitaItemGroupImpl {
    public static CreativeModeTab create(GuitaItemGroup tab) {
        var creativeTab = CreativeModeTab.builder()
                .icon(() -> tab.icon.get())
                .title(Component.translatable("itemGroup." + tab.id.getNamespace() + "." + tab.id.getPath()));
        if (tab.hideScrollBar) creativeTab.noScrollBar();
        if (tab.hideTitle) creativeTab.hideTitle();
        creativeTab.displayItems((params, output) -> tab.contents.stream().flatMap(Supplier::get).forEach(output::accept));
        return creativeTab.build();
    }
}
