/*
 * Decompiled with CFR 0.152.
 */
package com.macuguita.lib.mixin;

import com.macuguita.lib.supporters.Capes;
import com.macuguita.lib.supporters.RoleChecker;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.core.ClientAsset;
import net.minecraft.resources.Identifier;
import net.minecraft.world.entity.player.PlayerSkin;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={PlayerInfo.class})
public class PlayerListEntryMixin {
    @Inject(method={"getSkin()Lnet/minecraft/world/entity/player/PlayerSkin;"}, at={@At(value="TAIL")}, order=1001, cancellable=true)
    private void onGetSkinTextures(CallbackInfoReturnable<PlayerSkin> cir) {
        Identifier capeTexture;
        PlayerInfo player = (PlayerInfo)this;
        PlayerSkin originalTextures = (PlayerSkin)cir.getReturnValue();
        if (originalTextures == null) {
            return;
        }
        String role = RoleChecker.getPlayerRole(player.getProfile().id());
        if (role != null && (capeTexture = Capes.getCapeTextureForRole(role)) != null) {
            ClientAsset.ResourceTexture capeAsset = new ClientAsset.ResourceTexture(capeTexture);
            cir.setReturnValue((Object)new PlayerSkin(originalTextures.body(), (ClientAsset.Texture)capeAsset, originalTextures.elytra(), originalTextures.model(), originalTextures.secure()));
        }
    }
}

