/*
 * Decompiled with CFR 0.152.
 */
package com.macuguita.lib.platform.registry.builtin;

import com.macuguita.lib.platform.registry.GuitaRegistries;
import com.macuguita.lib.platform.registry.GuitaRegistry;
import com.macuguita.lib.platform.registry.GuitaRegistryEntry;
import com.macuguita.lib.platform.registry.builtin.base.ItemConvertibleEntry;
import com.macuguita.lib.platform.registry.builtin.base.ItemConvertibleHolderEntryGuita;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;

public class GuitaBlockRegistry
implements GuitaRegistry<Block> {
    private final String namespace;
    private final GuitaRegistry<Block> registry;

    public GuitaBlockRegistry(String id) {
        this(GuitaRegistries.create(BuiltInRegistries.BLOCK, id));
    }

    public GuitaBlockRegistry(GuitaRegistry<Block> parent) {
        this.namespace = Objects.requireNonNull(parent.namespace(), "Parent registry must have a namespace.");
        this.registry = parent;
    }

    public <I extends Block> ItemConvertibleEntry<I> register(String id, Function<BlockBehaviour.Properties, I> factory, Supplier<BlockBehaviour.Properties> getter) {
        ResourceKey key = ResourceKey.create((ResourceKey)BuiltInRegistries.BLOCK.key(), (Identifier)Identifier.fromNamespaceAndPath((String)this.namespace, (String)id));
        return this.register(id, () -> (Block)factory.apply(((BlockBehaviour.Properties)getter.get()).setId(key)));
    }

    @Override
    public String namespace() {
        return this.namespace;
    }

    @Override
    public <I extends Block> ItemConvertibleEntry<I> register(String id, Supplier<I> supplier) {
        return new ItemConvertibleEntry<I>(this.registry.register(id, supplier));
    }

    @Override
    public ItemConvertibleHolderEntryGuita<Block> registerRegistryEntry(String id, Supplier<Block> supplier) {
        return new ItemConvertibleHolderEntryGuita<Block>(this.registry.registerRegistryEntry(id, supplier));
    }

    @Override
    public Collection<GuitaRegistryEntry<Block>> getEntries() {
        return this.registry.getEntries();
    }

    @Override
    public void init() {
        this.registry.init();
    }
}

