/*
 * Decompiled with CFR 0.152.
 */
package com.macuguita.lib.platform.registry.builtin;

import com.macuguita.lib.platform.registry.GuitaRegistries;
import com.macuguita.lib.platform.registry.GuitaRegistry;
import com.macuguita.lib.platform.registry.GuitaRegistryEntry;
import com.macuguita.lib.platform.registry.builtin.base.ItemConvertibleEntry;
import com.macuguita.lib.platform.registry.builtin.base.ItemConvertibleHolderEntryGuita;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public class GuitaItemRegistry
implements GuitaRegistry<Item> {
    private final String namespace;
    private final GuitaRegistry<Item> registry;

    public GuitaItemRegistry(String id) {
        this(GuitaRegistries.create(BuiltInRegistries.ITEM, id));
    }

    public GuitaItemRegistry(GuitaRegistry<Item> parent) {
        this.namespace = Objects.requireNonNull(parent.namespace(), "Parent registry must have a namespace.");
        this.registry = parent;
    }

    public <I extends Item> ItemConvertibleEntry<I> register(String id, Function<Item.Properties, I> factory, Supplier<Item.Properties> getter) {
        ResourceKey key = ResourceKey.create((ResourceKey)BuiltInRegistries.ITEM.key(), (Identifier)Identifier.fromNamespaceAndPath((String)this.namespace, (String)id));
        return this.register(id, () -> (Item)factory.apply(((Item.Properties)getter.get()).setId(key)));
    }

    public ItemConvertibleEntry<BlockItem> register(String id, Supplier<? extends Block> supplier, Supplier<Item.Properties> getter) {
        return this.register(id, (Item.Properties properties) -> new BlockItem((Block)supplier.get(), properties.useBlockDescriptionPrefix()), getter);
    }

    @Override
    public String namespace() {
        return this.namespace;
    }

    @Override
    public <I extends Item> ItemConvertibleEntry<I> register(String id, Supplier<I> supplier) {
        return new ItemConvertibleEntry<I>(this.registry.register(id, supplier));
    }

    @Override
    public ItemConvertibleHolderEntryGuita<Item> registerRegistryEntry(String id, Supplier<Item> supplier) {
        return new ItemConvertibleHolderEntryGuita<Item>(this.registry.registerRegistryEntry(id, supplier));
    }

    @Override
    public Collection<GuitaRegistryEntry<Item>> getEntries() {
        return this.registry.getEntries();
    }

    @Override
    public void init() {
        this.registry.init();
    }
}

