/*
 * Decompiled with CFR 0.152.
 */
package com.macuguita.lib.platform.utils;

import com.macuguita.lib.platform.registry.GuitaRegistry;
import com.macuguita.lib.platform.utils.neoforge.GuitaItemGroupImpl;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.resources.Identifier;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class GuitaItemGroup {
    public final Identifier id;
    public Supplier<ItemStack> icon;
    public boolean hideScrollBar;
    public boolean hideTitle;
    public final List<Supplier<Stream<ItemStack>>> contents = new ArrayList<Supplier<Stream<ItemStack>>>();

    public GuitaItemGroup(Identifier id) {
        this.id = id;
    }

    public GuitaItemGroup setItemIcon(Supplier<? extends ItemLike> icon) {
        return this.setStackIcon(() -> new ItemStack((ItemLike)icon.get()));
    }

    public GuitaItemGroup setStackIcon(Supplier<ItemStack> icon) {
        this.icon = icon;
        return this;
    }

    public GuitaItemGroup hideTitle() {
        this.hideTitle = true;
        return this;
    }

    public GuitaItemGroup hideScrollBar() {
        this.hideScrollBar = true;
        return this;
    }

    public <I extends ItemLike, T extends GuitaRegistry<I>> GuitaItemGroup addRegistry(T registry) {
        return this.addContent(() -> registry.boundStream().map(ItemStack::new));
    }

    public GuitaItemGroup addStack(Supplier<ItemStack> stack) {
        return this.addContent(() -> Stream.of((ItemStack)stack.get()));
    }

    public GuitaItemGroup addStack(ItemStack stack) {
        return this.addStack(() -> stack);
    }

    public GuitaItemGroup addStack(ItemLike item) {
        return this.addStack(new ItemStack(item));
    }

    public GuitaItemGroup addContent(Supplier<Stream<ItemStack>> content) {
        this.contents.add(content);
        return this;
    }

    public CreativeModeTab build() {
        return GuitaItemGroup.create(this);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static CreativeModeTab create(GuitaItemGroup tab) {
        return GuitaItemGroupImpl.create(tab);
    }
}

