/*
 * Decompiled with CFR 0.152.
 */
package com.macuguita.lib.mixin;

import com.macuguita.lib.supporters.Capes;
import com.macuguita.lib.supporters.RoleChecker;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.resources.ResourceLocation;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AbstractClientPlayer.class})
public class AbstractClientPlayerEntityMixin {
    @Inject(method={"getSkin()Lnet/minecraft/client/resources/PlayerSkin;"}, at={@At(value="RETURN")}, cancellable=true)
    private void onGetSkinTextures(CallbackInfoReturnable<PlayerSkin> cir) {
        ResourceLocation capeTexture;
        AbstractClientPlayer player = (AbstractClientPlayer)this;
        PlayerSkin originalTextures = (PlayerSkin)cir.getReturnValue();
        if (originalTextures == null) {
            return;
        }
        String role = RoleChecker.getPlayerRole(player.getUUID());
        if (role != null && (capeTexture = Capes.getCapeTextureForRole(role)) != null) {
            cir.setReturnValue((Object)new PlayerSkin(originalTextures.texture(), originalTextures.textureUrl(), capeTexture, originalTextures.elytraTexture(), originalTextures.model(), originalTextures.secure()));
        }
    }
}

