/*
 * Decompiled with CFR 0.152.
 */
package io.github.catomon.nowaitvillagerscream;

import io.github.catomon.nowaitvillagerscream.EntityFollowSoundInstance;
import io.github.catomon.nowaitvillagerscream.PlayVillagerScreamSoundPayload;
import io.github.catomon.nowaitvillagerscream.VillagerEventHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class ClientPacketHandler {
    public static void handle(PlayVillagerScreamSoundPayload payload, IPayloadContext context) {
        context.enqueueWork(() -> {
            Entity entity;
            Minecraft mc = Minecraft.getInstance();
            ClientLevel world = mc.level;
            if (world != null && (entity = world.getEntity(payload.entityId())) instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                SoundEvent sound = (SoundEvent)VillagerEventHandler.VILLAGER_SCREAM_SOUND.get();
                EntityFollowSoundInstance followSoundInstance = new EntityFollowSoundInstance(livingEntity, sound);
                float pitch = livingEntity.isBaby() ? 1.5f : 1.0f;
                followSoundInstance.setPitch(pitch);
                mc.getSoundManager().play((SoundInstance)followSoundInstance);
            }
        });
    }
}

