/*
 * Decompiled with CFR 0.152.
 */
package io.github.catomon.nowaitvillagerscream;

import io.github.catomon.nowaitvillagerscream.PlayVillagerScreamSoundPayload;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.npc.Villager;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

@EventBusSubscriber
public class VillagerEventHandler {
    private static long lastSoundTime = 0L;
    private static final long COOLDOWN_MS = 30000L;
    private static final DeferredRegister<SoundEvent> SOUND_EVENTS = DeferredRegister.create((Registry)BuiltInRegistries.SOUND_EVENT, (String)"nowaitvillagerscream");
    public static final DeferredHolder<SoundEvent, SoundEvent> VILLAGER_SCREAM_SOUND = SOUND_EVENTS.register("villager_scream", () -> SoundEvent.createVariableRangeEvent((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"nowaitvillagerscream", (String)"villager_scream")));

    public static void register(IEventBus bus) {
        SOUND_EVENTS.register(bus);
    }

    @SubscribeEvent
    public static void onVillagerAttacked(LivingDamageEvent.Post event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Villager) {
            Villager villager = (Villager)livingEntity;
            long now = System.currentTimeMillis();
            if (villager.getHealth() - event.getNewDamage() > 0.0f && now - lastSoundTime > 30000L) {
                PacketDistributor.sendToPlayersTrackingEntity((Entity)villager, (CustomPacketPayload)new PlayVillagerScreamSoundPayload(villager.getId()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                lastSoundTime = now;
            }
        }
    }
}

