/*
 * Decompiled with CFR 0.152.
 */
package io.github.catomon.nowaitvillagerscream;

import io.github.catomon.nowaitvillagerscream.EntityFollowSoundInstance;
import io.github.catomon.nowaitvillagerscream.PlayVillagerScreamSoundPacket;
import io.github.catomon.nowaitvillagerscream.VillagerEventHandler;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class ClientPacketHandler {
    public static void handle(PlayVillagerScreamSoundPacket pkt, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        if (context.getDirection().getReceptionSide() == LogicalSide.CLIENT) {
            context.enqueueWork(() -> {
                Entity entity;
                Minecraft mc = Minecraft.m_91087_();
                ClientLevel world = mc.f_91073_;
                if (world != null && (entity = world.m_6815_(pkt.entityId)) instanceof LivingEntity) {
                    LivingEntity livingEntity = (LivingEntity)entity;
                    SoundEvent sound = (SoundEvent)VillagerEventHandler.VILLAGER_SCREAM_SOUND.get();
                    EntityFollowSoundInstance followSoundInstance = new EntityFollowSoundInstance(livingEntity, sound);
                    float pitch = 1.0f;
                    if (livingEntity.m_6162_()) {
                        pitch = 1.2f;
                    }
                    followSoundInstance.setPitch(pitch);
                    mc.m_91106_().m_120367_((SoundInstance)followSoundInstance);
                }
            });
        }
        context.setPacketHandled(true);
    }
}

