/*
 * Decompiled with CFR 0.152.
 */
package io.github.catomon.nowaitvillagerscream;

import io.github.catomon.nowaitvillagerscream.NetworkHandler;
import io.github.catomon.nowaitvillagerscream.PlayVillagerScreamSoundPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.npc.Villager;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber
public class VillagerEventHandler {
    private static long lastSoundTime = 0L;
    private static final DeferredRegister<SoundEvent> SOUND_EVENTS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.SOUND_EVENTS, (String)"nowaitvillagerscream");
    public static final RegistryObject<SoundEvent> VILLAGER_SCREAM_SOUND = SOUND_EVENTS.register("villager_scream", () -> new SoundEvent(ResourceLocation.fromNamespaceAndPath((String)"nowaitvillagerscream", (String)"villager_scream")));

    public static void register(IEventBus bus) {
        SOUND_EVENTS.register(bus);
    }

    @SubscribeEvent
    public static void onVillagerAttacked(LivingHurtEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Villager) {
            Villager villager = (Villager)livingEntity;
            long now = System.currentTimeMillis();
            if (villager.m_21223_() - event.getAmount() > 0.0f && now - lastSoundTime > 30000L) {
                NetworkHandler.CHANNEL.send(PacketDistributor.TRACKING_ENTITY.with(() -> villager), (Object)new PlayVillagerScreamSoundPacket(villager.m_19879_()));
                lastSoundTime = now;
            }
        }
    }
}

